/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Counter;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.DelegatingHasContextAndHeaders;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseContext;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.scan.ScanContext;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public abstract class SearchContext
extends DelegatingHasContextAndHeaders
implements Releasable {
    private static ThreadLocal<SearchContext> current = new ThreadLocal();
    public static final int DEFAULT_TERMINATE_AFTER = 0;
    private Multimap<Lifetime, Releasable> clearables = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InnerHitsContext innerHitsContext;
    protected final ParseFieldMatcher parseFieldMatcher;
    private boolean nowInMillisUsed;

    public static void setCurrent(SearchContext value) {
        current.set(value);
        QueryParseContext.setTypes(value.types());
    }

    public static void removeCurrent() {
        current.remove();
        QueryParseContext.removeTypes();
    }

    public static SearchContext current() {
        return current.get();
    }

    protected SearchContext(ParseFieldMatcher parseFieldMatcher, HasContextAndHeaders contextHeaders) {
        super(contextHeaders);
        this.parseFieldMatcher = parseFieldMatcher;
    }

    public ParseFieldMatcher parseFieldMatcher() {
        return this.parseFieldMatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.clearReleasables(Lifetime.CONTEXT);
            }
            finally {
                this.doClose();
            }
        }
    }

    protected abstract void doClose();

    public abstract void preProcess();

    public abstract Query searchFilter(String[] var1);

    public abstract long id();

    public abstract String source();

    public abstract ShardSearchRequest request();

    public abstract SearchType searchType();

    public abstract SearchContext searchType(SearchType var1);

    public abstract SearchShardTarget shardTarget();

    public abstract int numberOfShards();

    public abstract boolean hasTypes();

    public abstract String[] types();

    public abstract float queryBoost();

    public abstract SearchContext queryBoost(float var1);

    public abstract long getOriginNanoTime();

    public final long nowInMillis() {
        this.nowInMillisUsed = true;
        return this.nowInMillisImpl();
    }

    public final boolean nowInMillisUsed() {
        return this.nowInMillisUsed;
    }

    protected abstract long nowInMillisImpl();

    public abstract ScrollContext scrollContext();

    public abstract SearchContext scrollContext(ScrollContext var1);

    public abstract SearchContextAggregations aggregations();

    public abstract SearchContext aggregations(SearchContextAggregations var1);

    public abstract <SubPhaseContext extends FetchSubPhaseContext> SubPhaseContext getFetchSubPhaseContext(FetchSubPhase.ContextFactory<SubPhaseContext> var1);

    public abstract SearchContextHighlight highlight();

    public abstract void highlight(SearchContextHighlight var1);

    public InnerHitsContext innerHits() {
        if (this.innerHitsContext == null) {
            this.innerHitsContext = new InnerHitsContext();
        }
        return this.innerHitsContext;
    }

    public abstract SuggestionSearchContext suggest();

    public abstract void suggest(SuggestionSearchContext var1);

    public abstract List<RescoreSearchContext> rescore();

    public abstract void addRescore(RescoreSearchContext var1);

    public abstract boolean hasScriptFields();

    public abstract ScriptFieldsContext scriptFields();

    public abstract boolean sourceRequested();

    public abstract boolean hasFetchSourceContext();

    public abstract FetchSourceContext fetchSourceContext();

    public abstract SearchContext fetchSourceContext(FetchSourceContext var1);

    public abstract ContextIndexSearcher searcher();

    public abstract IndexShard indexShard();

    public abstract MapperService mapperService();

    public abstract AnalysisService analysisService();

    public abstract IndexQueryParserService queryParserService();

    public abstract SimilarityService similarityService();

    public abstract ScriptService scriptService();

    public abstract PageCacheRecycler pageCacheRecycler();

    public abstract BigArrays bigArrays();

    public abstract BitsetFilterCache bitsetFilterCache();

    public abstract IndexFieldDataService fieldData();

    public abstract long timeoutInMillis();

    public abstract void timeoutInMillis(long var1);

    public abstract int terminateAfter();

    public abstract void terminateAfter(int var1);

    public abstract SearchContext minimumScore(float var1);

    public abstract Float minimumScore();

    public abstract SearchContext sort(Sort var1);

    public abstract Sort sort();

    public abstract SearchContext trackScores(boolean var1);

    public abstract boolean trackScores();

    public abstract SearchContext parsedPostFilter(ParsedQuery var1);

    public abstract ParsedQuery parsedPostFilter();

    public abstract Query aliasFilter();

    public abstract SearchContext parsedQuery(ParsedQuery var1);

    public abstract ParsedQuery parsedQuery();

    public abstract Query query();

    public abstract int from();

    public abstract SearchContext from(int var1);

    public abstract int size();

    public abstract SearchContext size(int var1);

    public abstract boolean hasFieldNames();

    public abstract List<String> fieldNames();

    public abstract void emptyFieldNames();

    public abstract boolean explain();

    public abstract void explain(boolean var1);

    @Nullable
    public abstract List<String> groupStats();

    public abstract void groupStats(List<String> var1);

    public abstract boolean version();

    public abstract void version(boolean var1);

    public abstract int[] docIdsToLoad();

    public abstract int docIdsToLoadFrom();

    public abstract int docIdsToLoadSize();

    public abstract SearchContext docIdsToLoad(int[] var1, int var2, int var3);

    public abstract void accessed(long var1);

    public abstract long lastAccessTime();

    public abstract long keepAlive();

    public abstract void keepAlive(long var1);

    public abstract SearchLookup lookup();

    public abstract DfsSearchResult dfsResult();

    public abstract QuerySearchResult queryResult();

    public abstract FetchSearchResult fetchResult();

    public abstract Profilers getProfilers();

    public void addReleasable(Releasable releasable, Lifetime lifetime) {
        if (this.clearables == null) {
            this.clearables = MultimapBuilder.enumKeys(Lifetime.class).arrayListValues().build();
        }
        this.clearables.put((Object)lifetime, (Object)releasable);
    }

    public void clearReleasables(Lifetime lifetime) {
        if (this.clearables != null) {
            ArrayList<Collection> releasables = new ArrayList<Collection>();
            for (Lifetime lc : Lifetime.values()) {
                if (lc.compareTo(lifetime) > 0) break;
                releasables.add(this.clearables.removeAll((Object)lc));
            }
            Releasables.close(Iterables.concat(releasables));
        }
    }

    public abstract ScanContext scanContext();

    public abstract MappedFieldType smartNameFieldType(String var1);

    public abstract MappedFieldType smartNameFieldTypeFromAnyType(String var1);

    public abstract ObjectMapper getObjectMapper(String var1);

    public abstract Counter timeEstimateCounter();

    public abstract Map<Class<?>, Collector> queryCollectors();

    public static enum Lifetime {
        COLLECTION,
        PHASE,
        CONTEXT;

    }
}

