/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.expressions.js.VariableContext;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleConstValueSource;
import org.apache.lucene.search.SortField;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.script.ClassPermission;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.expression.CountMethodValueSource;
import org.elasticsearch.script.expression.DateMethodValueSource;
import org.elasticsearch.script.expression.ExpressionExecutableScript;
import org.elasticsearch.script.expression.ExpressionSearchScript;
import org.elasticsearch.script.expression.FieldDataValueSource;
import org.elasticsearch.script.expression.ReplaceableConstValueSource;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.lookup.SearchLookup;

public class ExpressionScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "expression";
    protected static final String GET_YEAR_METHOD = "getYear";
    protected static final String GET_MONTH_METHOD = "getMonth";
    protected static final String GET_DAY_OF_MONTH_METHOD = "getDayOfMonth";
    protected static final String GET_HOUR_OF_DAY_METHOD = "getHourOfDay";
    protected static final String GET_MINUTES_METHOD = "getMinutes";
    protected static final String GET_SECONDS_METHOD = "getSeconds";
    protected static final String MINIMUM_METHOD = "min";
    protected static final String MAXIMUM_METHOD = "max";
    protected static final String AVERAGE_METHOD = "avg";
    protected static final String MEDIAN_METHOD = "median";
    protected static final String SUM_METHOD = "sum";
    protected static final String COUNT_METHOD = "count";

    @Inject
    public ExpressionScriptEngineService(Settings settings) {
        super(settings);
    }

    public String[] types() {
        return new String[]{NAME};
    }

    public String[] extensions() {
        return new String[]{NAME};
    }

    public boolean sandboxed() {
        return true;
    }

    public Object compile(final String script) {
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(new PrivilegedAction<Expression>(){

            @Override
            public Expression run() {
                try {
                    final AccessControlContext engineContext = AccessController.getContext();
                    ClassLoader loader = this.getClass().getClassLoader();
                    if (sm != null) {
                        loader = new ClassLoader(loader){

                            @Override
                            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                                try {
                                    engineContext.checkPermission((Permission)new ClassPermission(name));
                                }
                                catch (SecurityException e) {
                                    throw new ClassNotFoundException(name, e);
                                }
                                return super.loadClass(name, resolve);
                            }
                        };
                    }
                    return JavascriptCompiler.compile((String)script, (Map)JavascriptCompiler.DEFAULT_FUNCTIONS, (ClassLoader)loader);
                }
                catch (ParseException e) {
                    throw new ScriptException("Failed to parse expression: " + script, (Throwable)e);
                }
            }
        });
    }

    public SearchScript search(CompiledScript compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        try {
            Expression expr = (Expression)compiledScript.compiled();
            MapperService mapper = lookup.doc().mapperService();
            SimpleBindings bindings = new SimpleBindings();
            ReplaceableConstValueSource specialValue = null;
            for (String variable : expr.variables) {
                if (variable.equals("_score")) {
                    bindings.add(new SortField("_score", SortField.Type.SCORE));
                    continue;
                }
                if (variable.equals("_value")) {
                    specialValue = new ReplaceableConstValueSource();
                    bindings.add("_value", (ValueSource)specialValue);
                    continue;
                }
                if (vars != null && vars.containsKey(variable)) {
                    Object value = vars.get(variable);
                    if (value instanceof Number) {
                        bindings.add(variable, (ValueSource)new DoubleConstValueSource(((Number)value).doubleValue()));
                        continue;
                    }
                    throw new ScriptException("Parameter [" + variable + "] must be a numeric type");
                }
                String fieldname = null;
                String methodname = null;
                VariableContext[] parts = VariableContext.parse((String)variable);
                if (!parts[0].text.equals("doc")) {
                    throw new ScriptException("Unknown variable [" + parts[0].text + "] in expression");
                }
                if (parts.length < 2 || parts[1].type != VariableContext.Type.STR_INDEX) {
                    throw new ScriptException("Variable 'doc' in expression must be used with a specific field like: doc['myfield']");
                }
                fieldname = parts[1].text;
                if (parts.length == 3) {
                    if (parts[2].type == VariableContext.Type.METHOD) {
                        methodname = parts[2].text;
                    } else if (parts[2].type != VariableContext.Type.MEMBER || !"value".equals(parts[2].text)) {
                        throw new ScriptException("Only the member variable [value] or member methods may be accessed on a field when not accessing the field directly");
                    }
                }
                if (parts.length > 3) {
                    throw new ScriptException("Variable [" + variable + "] does not follow an allowed format of either doc['field'] or doc['field'].method()");
                }
                MappedFieldType fieldType = mapper.smartNameFieldType(fieldname);
                if (fieldType == null) {
                    throw new ScriptException("Field [" + fieldname + "] used in expression does not exist in mappings");
                }
                if (!fieldType.isNumeric()) {
                    throw new ScriptException("Field [" + fieldname + "] used in expression must be numeric");
                }
                IndexFieldData fieldData = lookup.doc().fieldDataService().getForField((MappedFieldType)((NumberFieldMapper.NumberFieldType)fieldType));
                if (methodname == null) {
                    bindings.add(variable, (ValueSource)new FieldDataValueSource(fieldData, MultiValueMode.MIN));
                    continue;
                }
                bindings.add(variable, this.getMethodValueSource(fieldType, fieldData, fieldname, methodname));
            }
            boolean needsScores = expr.getSortField((Bindings)bindings, false).needsScores();
            return new ExpressionSearchScript(compiledScript, bindings, specialValue, needsScores);
        }
        catch (Exception exception) {
            throw new ScriptException("Error during search with " + compiledScript, (Throwable)exception);
        }
    }

    protected ValueSource getMethodValueSource(MappedFieldType fieldType, IndexFieldData<?> fieldData, String fieldName, String methodName) {
        switch (methodName) {
            case "getYear": {
                return this.getDateMethodValueSource(fieldType, fieldData, fieldName, methodName, 1);
            }
            case "getMonth": {
                return this.getDateMethodValueSource(fieldType, fieldData, fieldName, methodName, 2);
            }
            case "getDayOfMonth": {
                return this.getDateMethodValueSource(fieldType, fieldData, fieldName, methodName, 5);
            }
            case "getHourOfDay": {
                return this.getDateMethodValueSource(fieldType, fieldData, fieldName, methodName, 11);
            }
            case "getMinutes": {
                return this.getDateMethodValueSource(fieldType, fieldData, fieldName, methodName, 12);
            }
            case "getSeconds": {
                return this.getDateMethodValueSource(fieldType, fieldData, fieldName, methodName, 13);
            }
            case "min": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            }
            case "max": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MAX);
            }
            case "avg": {
                return new FieldDataValueSource(fieldData, MultiValueMode.AVG);
            }
            case "median": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MEDIAN);
            }
            case "sum": {
                return new FieldDataValueSource(fieldData, MultiValueMode.SUM);
            }
            case "count": {
                return new CountMethodValueSource(fieldData);
            }
        }
        throw new IllegalArgumentException("Member method [" + methodName + "] does not exist.");
    }

    protected ValueSource getDateMethodValueSource(MappedFieldType fieldType, IndexFieldData<?> fieldData, String fieldName, String methodName, int calendarType) {
        if (!(fieldType instanceof DateFieldMapper.DateFieldType)) {
            throw new IllegalArgumentException("Member method [" + methodName + "] can only be used with a date field type, not the field [" + fieldName + "].");
        }
        return new DateMethodValueSource(fieldData, MultiValueMode.MIN, methodName, calendarType);
    }

    public ExecutableScript executable(CompiledScript compiledScript, Map<String, Object> vars) {
        return new ExpressionExecutableScript(compiledScript, vars);
    }

    public void close() {
    }

    public void scriptRemoved(CompiledScript script) {
    }
}

