/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class ResizeAtom
extends Atom {
    private Atom base;
    private int wunit;
    private int hunit;
    private float w;
    private float h;
    private boolean keepaspectratio;

    public ResizeAtom(Atom atom, String string, String string2, boolean bl) {
        this.type = atom.type;
        this.base = atom;
        this.keepaspectratio = bl;
        float[] fArray = SpaceAtom.getLength(string == null ? "" : string);
        float[] fArray2 = SpaceAtom.getLength(string2 == null ? "" : string2);
        if (fArray.length != 2) {
            this.wunit = -1;
        } else {
            this.wunit = (int)fArray[0];
            this.w = fArray[1];
        }
        if (fArray2.length != 2) {
            this.hunit = -1;
        } else {
            this.hunit = (int)fArray2[0];
            this.h = fArray2[1];
        }
    }

    public int getLeftType() {
        return this.base.getLeftType();
    }

    public int getRightType() {
        return this.base.getRightType();
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box = this.base.createBox(teXEnvironment);
        if (this.wunit == -1 && this.hunit == -1) {
            return box;
        }
        double d = 1.0;
        double d2 = 1.0;
        if (this.wunit != -1 && this.hunit != -1) {
            d = this.w * SpaceAtom.getFactor(this.wunit, teXEnvironment) / box.width;
            d2 = this.h * SpaceAtom.getFactor(this.hunit, teXEnvironment) / box.height;
            if (this.keepaspectratio) {
                d2 = d = Math.min(d, d2);
            }
        } else if (this.wunit != -1 && this.hunit == -1) {
            d2 = d = (double)(this.w * SpaceAtom.getFactor(this.wunit, teXEnvironment) / box.width);
        } else {
            d = d2 = (double)(this.h * SpaceAtom.getFactor(this.hunit, teXEnvironment) / box.height);
        }
        return new ScaleBox(box, d, d2);
    }
}

