/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.BaseType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.FormattedTypeBaseAttrRef;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormattedType
extends BaseType {
    private Domain baseDomain = null;
    private Table baseClass = null;
    private String minimum = null;
    private String maximum = null;
    private ArrayList baseAttrRef = null;
    private String prefix = null;

    public Table getDefinedBaseStruct() {
        return this.baseClass;
    }

    public Table getBaseStruct() {
        Table baseStruct = null;
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.getBaseStruct();
        }
        baseStruct = this.getDefinedBaseStruct();
        if (baseStruct == null) {
            baseStruct = ((FormattedType)this.getExtending()).getBaseStruct();
        }
        return baseStruct;
    }

    public void setBaseStruct(Table baseClass) {
        this.baseClass = baseClass;
    }

    public Domain getDefinedBaseDomain() {
        return this.baseDomain;
    }

    public void setBaseDomain(Domain baseDomain) {
        this.baseDomain = baseDomain;
    }

    public String getDefinedMaximum() {
        return this.maximum;
    }

    public String getMaximum() {
        if (this.maximum != null) {
            return this.maximum;
        }
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.getMaximum();
        }
        String max = null;
        FormattedType baseFormatType = (FormattedType)this.getExtending();
        while (baseFormatType != null) {
            max = baseFormatType.maximum;
            if (max != null) break;
            baseFormatType = (FormattedType)baseFormatType.getExtending();
        }
        if (max == null) {
            StringBuffer fmt = new StringBuffer();
            FormattedType lastParent = null;
            Iterator baseAttri = this.iteratorBaseAttrRef();
            while (baseAttri.hasNext()) {
                String prefix;
                FormattedTypeBaseAttrRef baseAttrRef = (FormattedTypeBaseAttrRef)baseAttri.next();
                if (lastParent != baseAttrRef.getParent() && (prefix = (lastParent = baseAttrRef.getParent()).getDefinedPrefix()) != null) {
                    fmt.append(prefix);
                }
                if (baseAttrRef.getFormatted() != null) {
                    fmt.append(((FormattedType)baseAttrRef.getFormatted().getType()).getMaximum());
                } else {
                    fmt.append(((NumericType)baseAttrRef.getAttr().getDomainResolvingAliases()).getMaximum().toString());
                }
                if (baseAttrRef.getPostfix() == null) continue;
                fmt.append(baseAttrRef.getPostfix());
            }
            max = fmt.toString();
        }
        return max;
    }

    public void setMaximum(String maximum) {
        this.maximum = maximum;
    }

    public String getDefinedMinimum() {
        return this.minimum;
    }

    public String getMinimum() {
        if (this.minimum != null) {
            return this.minimum;
        }
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.getMinimum();
        }
        String min = null;
        FormattedType baseFormatType = (FormattedType)this.getExtending();
        while (baseFormatType != null) {
            min = baseFormatType.minimum;
            if (min != null) break;
            baseFormatType = (FormattedType)baseFormatType.getExtending();
        }
        if (min == null) {
            StringBuffer fmt = new StringBuffer();
            FormattedType lastParent = null;
            Iterator baseAttri = this.iteratorBaseAttrRef();
            while (baseAttri.hasNext()) {
                String prefix;
                FormattedTypeBaseAttrRef baseAttrRef = (FormattedTypeBaseAttrRef)baseAttri.next();
                if (lastParent != baseAttrRef.getParent() && (prefix = (lastParent = baseAttrRef.getParent()).getDefinedPrefix()) != null) {
                    fmt.append(prefix);
                }
                if (baseAttrRef.getFormatted() != null) {
                    fmt.append(((FormattedType)baseAttrRef.getFormatted().getType()).getMinimum());
                } else {
                    fmt.append(((NumericType)baseAttrRef.getAttr().getDomainResolvingAliases()).getMinimum().toString());
                }
                if (baseAttrRef.getPostfix() == null) continue;
                fmt.append(baseAttrRef.getPostfix());
            }
            min = fmt.toString();
        }
        return min;
    }

    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    public PrecisionDecimal[] valueOf(String value) {
        String regexp = this.getRegExp();
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            throw new NumberFormatException();
        }
        PrecisionDecimal[] ret = new PrecisionDecimal[matcher.groupCount()];
        int i = 1;
        while (i <= matcher.groupCount()) {
            ret[i - 1] = new PrecisionDecimal(matcher.group(i));
            ++i;
        }
        return ret;
    }

    public String getRegExp() {
        FormattedType format = this;
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            format = (FormattedType)baseDomain.getType();
        }
        StringBuffer fmt = new StringBuffer();
        FormattedType lastParent = null;
        Iterator baseAttri = format.iteratorBaseAttrRef();
        while (baseAttri.hasNext()) {
            String prefix;
            FormattedTypeBaseAttrRef baseAttrRef = (FormattedTypeBaseAttrRef)baseAttri.next();
            if (lastParent != baseAttrRef.getParent() && (prefix = (lastParent = baseAttrRef.getParent()).getDefinedPrefix()) != null) {
                fmt.append(prefix);
            }
            if (baseAttrRef.getFormatted() != null) {
                fmt.append(((FormattedType)baseAttrRef.getFormatted().getType()).getRegExp());
            } else {
                fmt.append("([\\+\\-0-9\\.]+)");
            }
            if (baseAttrRef.getPostfix() == null) continue;
            fmt.append(baseAttrRef.getPostfix());
        }
        return fmt.toString();
    }

    public boolean isValueInRange(String value) {
        PrecisionDecimal[] minimum = this.valueOf(this.getMinimum());
        PrecisionDecimal[] maximum = this.valueOf(this.getMaximum());
        PrecisionDecimal[] val = this.valueOf(value);
        int i = 0;
        while (i < val.length) {
            if (val[i].compareTo(minimum[i]) == -1 || val[i].compareTo(maximum[i]) == 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkStructuralEquivalence(Element with) {
        return super.checkStructuralEquivalence(with);
    }

    public void addBaseAttrRef(FormattedTypeBaseAttrRef ref) {
        if (this.baseAttrRef == null) {
            this.baseAttrRef = new ArrayList();
        }
        this.baseAttrRef.add(ref);
    }

    public Iterator iteratorDefinedBaseAttrRef() {
        if (this.baseAttrRef == null) {
            return new ArrayList().iterator();
        }
        return this.baseAttrRef.iterator();
    }

    public Iterator iteratorBaseAttrRef() {
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.iteratorBaseAttrRef();
        }
        ArrayList ret = new ArrayList();
        if (this.baseAttrRef != null) {
            ret.addAll(this.baseAttrRef);
        }
        FormattedType baseFormatType = (FormattedType)this.getExtending();
        while (baseFormatType != null) {
            if (baseFormatType.baseAttrRef != null) {
                ret.addAll(0, baseFormatType.baseAttrRef);
            }
            baseFormatType = (FormattedType)baseFormatType.getExtending();
        }
        return ret.iterator();
    }

    public String getDefinedPrefix() {
        return this.prefix;
    }

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.getPrefix();
        }
        FormattedType baseFormatType = (FormattedType)this.getExtending();
        if (baseFormatType == null) {
            return null;
        }
        return baseFormatType.getPrefix();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFormat() {
        StringBuffer fmt = new StringBuffer();
        FormattedType lastParent = null;
        Iterator baseAttri = this.iteratorBaseAttrRef();
        while (baseAttri.hasNext()) {
            String prefix;
            FormattedTypeBaseAttrRef baseAttrRef = (FormattedTypeBaseAttrRef)baseAttri.next();
            if (lastParent != baseAttrRef.getParent() && (prefix = (lastParent = baseAttrRef.getParent()).getDefinedPrefix()) != null) {
                fmt.append("\"" + prefix + "\"");
            }
            fmt.append(baseAttrRef.getAttr().getName());
            if (baseAttrRef.getFormatted() != null) {
                fmt.append("/");
                fmt.append(baseAttrRef.getFormatted().getScopedName(null));
            } else if (baseAttrRef.getIntPos() > 0) {
                fmt.append("/");
                fmt.append(baseAttrRef.getIntPos());
            }
            if (baseAttrRef.getPostfix() == null) continue;
            fmt.append("\"" + baseAttrRef.getPostfix() + "\"");
        }
        return fmt.toString();
    }

    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!wantToExtend.getClass().equals(this.getClass())) {
            throw new Ili2cSemanticException(rsrc.getString("err_type_ExtOther"));
        }
    }
}

