/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolBioMeshRenderer;
import org.jmol.java.BS;
import org.jmol.render.MeshRenderer;
import org.jmol.render.ShapeRenderer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapebio.BioShape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

public class BioMeshRenderer
extends MeshRenderer
implements JmolBioMeshRenderer {
    private Mesh[] meshes;
    private boolean[] meshReady;
    private BS bsRenderMesh;
    private BioShapeRenderer bsr;
    private boolean doCap0;
    private boolean doCap1;
    private static final int ABSOLUTE_MIN_MESH_SIZE = 3;
    private static final int MIN_MESH_RENDER_SIZE = 8;
    private P3[] controlHermites;
    private V3[] wingHermites;
    private P3[] radiusHermites;
    private V3 norm = new V3();
    private final V3 wing = new V3();
    private final V3 wing1 = new V3();
    private final V3 wingT = new V3();
    private final A4 aa = new A4();
    private final P3 pt = new P3();
    private final P3 pt1 = new P3();
    private final P3 ptPrev = new P3();
    private final P3 ptNext = new P3();
    private final M3 mat = new M3();
    private static final int MODE_TUBE = 0;
    private static final int MODE_FLAT = 1;
    private static final int MODE_ELLIPTICAL = 2;
    private static final int MODE_NONELLIPTICAL = 3;
    private BS bsTemp;
    private final V3 norml = new V3();

    protected boolean render() {
        return false;
    }

    public void initialize(ShapeRenderer shapeRenderer, BioShape bioShape, int n) {
        this.bsr = (BioShapeRenderer)shapeRenderer;
        this.bsRenderMesh = BS.newN((int)n);
        this.meshReady = bioShape.meshReady;
        this.meshes = bioShape.meshes;
    }

    private void renderBioMesh(Mesh mesh) {
        if (mesh.normalsTemp != null) {
            mesh.setNormixes(mesh.normalsTemp);
            mesh.normalsTemp = null;
        } else if (mesh.normixes == null) {
            mesh.initialize(1073741958, null, null);
        }
        this.renderMesh2(mesh);
    }

    public void setFancyRibbon(int n) {
        try {
            if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, this.bsr.madBeg, this.bsr.madMid, this.bsr.madEnd, this.bsr.aspectRatio, this.bsr.isNucleic ? 4 : 7))) {
                return;
            }
            this.meshes[n].setColix(this.bsr.colix);
            this.meshes[n].setColixBack(this.bsr.colixBack);
            this.bsRenderMesh.set(n);
        }
        catch (Exception exception) {
            this.bsRenderMesh.clear(n);
            this.meshes[n] = null;
            Logger.error((String)("render mesh error hermiteRibbon: " + exception.toString()));
        }
    }

    public void setFancyConic(int n, int n2) {
        try {
            if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, this.bsr.madBeg, this.bsr.madMid, this.bsr.madEnd, 1.0f, n2))) {
                return;
            }
            this.meshes[n].setColix(this.bsr.colix);
            this.bsRenderMesh.set(n);
            return;
        }
        catch (Exception exception) {
            this.bsRenderMesh.clear(n);
            this.meshes[n] = null;
            Logger.error((String)("render mesh error hermiteConic: " + exception.toString()));
            return;
        }
    }

    public void setFancyArrowHead(int n) {
        try {
            this.doCap0 = true;
            this.doCap1 = false;
            if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, (int)Math.floor((double)this.bsr.madBeg * 1.2), (int)Math.floor((double)this.bsr.madBeg * 0.6), 0, this.bsr.aspectRatio == 1.0f ? this.bsr.aspectRatio : this.bsr.aspectRatio / 2.0f, 7))) {
                return;
            }
            this.meshes[n].setColix(this.bsr.colix);
            this.bsRenderMesh.set(n);
            return;
        }
        catch (Exception exception) {
            this.bsRenderMesh.clear(n);
            this.meshes[n] = null;
            Logger.error((String)("render mesh error hermiteArrowHead: " + exception.toString()));
            return;
        }
    }

    private boolean createMesh(int n, int n2, int n3, int n4, float f, int n5) {
        int n6;
        boolean bl;
        this.bsr.setNeighbors(n);
        P3[] p3Array = this.bsr.controlPoints;
        if (p3Array[n].distanceSquared((T3)p3Array[this.bsr.iNext]) == 0.0f) {
            return false;
        }
        boolean bl2 = f != 1.0f && this.bsr.wingVectors != null;
        boolean bl3 = f == 0.0f;
        boolean bl4 = this.bsr.cartoonsFancy || this.bsr.hermiteLevel >= 6;
        int n7 = (this.bsr.hermiteLevel + 1) * 2 + 1;
        int n8 = bl3 ? 4 : (this.bsr.hermiteLevel + 1) * 4 - 2;
        float f2 = (float)(bl3 ? Math.PI / (double)(n8 - 1) : Math.PI * 2 / (double)n8);
        Mesh mesh = this.meshes[n] = new Mesh().mesh1(this.vwr, "mesh_" + this.shapeID + "_" + n, (short)0, n);
        boolean bl5 = bl = n2 != n3 || n3 != n4;
        if (this.controlHermites == null || this.controlHermites.length < n7 + 1) {
            this.controlHermites = new P3[n7 + 1];
        }
        GData.getHermiteList((int)n5, (T3)p3Array[this.bsr.iPrev], (T3)p3Array[n], (T3)p3Array[this.bsr.iNext], (T3)p3Array[this.bsr.iNext2], (T3)p3Array[this.bsr.iNext3], (T3[])this.controlHermites, (int)0, (int)n7, (boolean)true);
        if (this.wingHermites == null || this.wingHermites.length < n7 + 1) {
            this.wingHermites = new V3[n7 + 1];
        }
        this.wing.setT((T3)this.bsr.wingVectors[this.bsr.iPrev]);
        if (n4 == 0) {
            this.wing.scale(2.0f);
        }
        GData.getHermiteList((int)n5, (T3)this.wing, (T3)this.bsr.wingVectors[n], (T3)this.bsr.wingVectors[this.bsr.iNext], (T3)this.bsr.wingVectors[this.bsr.iNext2], (T3)this.bsr.wingVectors[this.bsr.iNext3], (T3[])this.wingHermites, (int)0, (int)n7, (boolean)false);
        float f3 = (float)n2 / 2000.0f;
        float f4 = (float)n3 / 2000.0f;
        float f5 = (float)n4 / 2000.0f;
        if (bl) {
            if (this.radiusHermites == null || this.radiusHermites.length < (n7 + 1 >> 1) + 1) {
                this.radiusHermites = new P3[(n7 + 1 >> 1) + 1];
            }
            this.ptPrev.set(f3, f3, 0.0f);
            this.pt.set(f3, f4, 0.0f);
            this.pt1.set(f4, f5, 0.0f);
            this.ptNext.set(f5, f5, 0.0f);
            GData.getHermiteList((int)4, (T3)this.ptPrev, (T3)this.pt, (T3)this.pt1, (T3)this.ptNext, (T3)this.ptNext, (T3[])this.radiusHermites, (int)0, (int)(n7 + 1 >> 1), (boolean)true);
        }
        int n9 = 0;
        int n10 = n7 >> 1;
        int n11 = (n8 + 2) / 4;
        int n12 = (3 * n8 + 2) / 4;
        int n13 = !bl2 ? 0 : (bl3 ? 1 : (bl4 ? 2 : 3));
        boolean bl6 = n13 == 0 || n13 == 3;
        for (n6 = 0; n6 < n7; ++n6) {
            this.norm.sub2((T3)this.controlHermites[n6 + 1], (T3)this.controlHermites[n6]);
            float f6 = !bl ? f3 : (n6 < n10 ? this.radiusHermites[n6].x : this.radiusHermites[n6 - n10].y);
            this.wing.setT((T3)this.wingHermites[n6]);
            this.wing1.setT((T3)this.wing);
            switch (n13) {
                case 1: {
                    break;
                }
                case 2: {
                    this.wing1.cross((T3)this.norm, (T3)this.wing);
                    this.wing1.normalize();
                    this.wing1.scale(this.wing.length() / f);
                    break;
                }
                case 3: {
                    this.wing.scale(2.0f / f);
                    this.wing1.sub((T3)this.wing);
                    break;
                }
                case 0: {
                    this.wing.cross((T3)this.wing, (T3)this.norm);
                    this.wing.normalize();
                }
            }
            this.wing.scale(f6);
            this.wing1.scale(f6);
            if (bl6) {
                this.aa.setVA(this.norm, f2);
                this.mat.setAA(this.aa);
            }
            this.pt1.setT((T3)this.controlHermites[n6]);
            float f7 = bl3 ? 0.0f : f2;
            int n14 = 0;
            while (n14 < n8) {
                if (bl6 && n14 > 0) {
                    this.mat.rotate((T3)this.wing);
                }
                switch (n13) {
                    case 1: {
                        this.wingT.setT((T3)this.wing1);
                        this.wingT.scale((float)Math.cos(f7));
                        break;
                    }
                    case 2: {
                        this.wingT.setT((T3)this.wing1);
                        this.wingT.scale((float)Math.sin(f7));
                        this.wingT.scaleAdd2((float)Math.cos(f7), (T3)this.wing, (T3)this.wingT);
                        break;
                    }
                    case 3: {
                        this.wingT.setT((T3)this.wing);
                        if (n14 == n11 || n14 == n12) {
                            this.wing1.scale(-1.0f);
                        }
                        this.wingT.add((T3)this.wing1);
                        break;
                    }
                    case 0: {
                        this.wingT.setT((T3)this.wing);
                    }
                }
                this.pt.add2((T3)this.pt1, (T3)this.wingT);
                mesh.addV((T3)this.pt, true);
                ++n14;
                f7 += f2;
            }
            if (n6 > 0) {
                n14 = bl3 ? n8 - 1 : n8;
                for (int i = 0; i < n14; ++i) {
                    int n15 = n9 - n8 + i;
                    int n16 = n9 - n8 + (i + 1) % n8;
                    int n17 = n9 + (i + 1) % n8;
                    int n18 = n9 + i;
                    if (i < n14 / 2) {
                        mesh.addQuad(n15, n16, n17, n18);
                        continue;
                    }
                    mesh.addQuad(n16, n17, n18, n15);
                }
            }
            n9 += n8;
        }
        if (!bl3) {
            n6 = n9;
            if (this.doCap0) {
                int n19;
                T3[] t3Array = mesh.getVertices();
                for (n19 = 0; n19 < n8; ++n19) {
                    mesh.addV(t3Array[n19], true);
                }
                n9 += n8;
                n19 = this.bsr.hermiteLevel * 2;
                while (--n19 >= 0) {
                    mesh.addQuad(n9 - n8 + n19 + 2, n9 - n8 + n19 + 1, n9 - n8 + (n8 - n19) % n8, n9 - n19 - 1);
                }
            }
            if (this.doCap1) {
                int n20;
                T3[] t3Array = mesh.getVertices();
                for (n20 = 0; n20 < n8; ++n20) {
                    mesh.addV(t3Array[n6 - n8 + n20], true);
                }
                n9 += n8;
                n20 = this.bsr.hermiteLevel * 2;
                while (--n20 >= 0) {
                    mesh.addQuad(n9 - n20 - 1, n9 - n8 + (n8 - n20) % n8, n9 - n8 + n20 + 1, n9 - n8 + n20 + 2);
                }
            }
        }
        this.meshReady[n] = true;
        this.adjustCartoonSeamNormals(n, n8);
        mesh.setVisibilityFlags(1);
        return true;
    }

    void adjustCartoonSeamNormals(int n, int n2) {
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        if (n == this.bsr.iNext - 1 && this.bsr.iNext < this.bsr.monomerCount && this.bsr.monomers[n].getStrucNo() == this.bsr.monomers[this.bsr.iNext].getStrucNo() && this.meshReady[n] && this.meshReady[this.bsr.iNext]) {
            try {
                V3[] v3Array = this.meshes[this.bsr.iNext].getNormalsTemp();
                V3[] v3Array2 = this.meshes[n].getNormalsTemp();
                int n3 = v3Array2.length;
                if (this.doCap0) {
                    n3 -= n2;
                }
                for (int i = 1; i <= n2; ++i) {
                    this.norml.add2((T3)v3Array2[n3 - i], (T3)v3Array[n2 - i]);
                    this.norml.normalize();
                    v3Array2[n3 - i].setT((T3)this.norml);
                    v3Array[n2 - i].setT((T3)this.norml);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void renderMeshes() {
        if (this.bsRenderMesh.isEmpty()) {
            return;
        }
        this.setColix(this.bsr.colix);
        int n = this.bsRenderMesh.nextSetBit(0);
        while (n >= 0) {
            this.renderBioMesh(this.meshes[n]);
            n = this.bsRenderMesh.nextSetBit(n + 1);
        }
    }

    public void initBS() {
        this.bsRenderMesh.clearAll();
    }

    public boolean check(boolean bl, boolean bl2) {
        this.doCap0 = bl;
        this.doCap1 = bl2;
        return this.exportType == 1 || this.checkDiameter(this.bsr.diameterBeg) || this.checkDiameter(this.bsr.diameterMid) || this.checkDiameter(this.bsr.diameterEnd);
    }

    private boolean checkDiameter(int n) {
        return this.bsr.isHighRes & n > 3 || n >= 8;
    }
}

