/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javajs.util.P3;
import javajs.util.SB;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Node;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;

class Leaf
extends Element {
    P3[] tuples;

    Leaf(Bspt bspt, Leaf leaf, int n) {
        this.bspt = bspt;
        this.count = 0;
        this.tuples = new P3[2];
        if (leaf == null) {
            return;
        }
        for (int i = n; i < 2; ++i) {
            this.tuples[this.count++] = leaf.tuples[i];
            leaf.tuples[i] = null;
        }
        leaf.count = n;
    }

    void sort(int n) {
        int n2 = this.count;
        while (--n2 > 0) {
            P3 p3 = this.tuples[n2];
            float f = Node.getDimensionValue(p3, n);
            int n3 = n2;
            while (--n3 >= 0) {
                P3 p32 = this.tuples[n3];
                float f2 = Node.getDimensionValue(p32, n);
                if (!(f2 > f)) continue;
                this.tuples[n2] = p32;
                this.tuples[n3] = p3;
                p3 = p32;
                f = f2;
            }
        }
    }

    @Override
    Element addTuple(int n, P3 p3) {
        if (this.count < 2) {
            this.tuples[this.count++] = p3;
            return this;
        }
        Node node = new Node(this.bspt, n, this);
        return node.addTuple(n, p3);
    }

    @Override
    void dump(int n, SB sB) {
        for (int i = 0; i < this.count; ++i) {
            P3 p3 = this.tuples[i];
            for (int j = 0; j < n; ++j) {
                sB.append(".");
            }
            sB.append(Escape.eP(p3)).append("Leaf ").appendI(i).append(": ").append(((Atom)p3).getInfo());
        }
    }

    public String toString() {
        return "leaf:" + this.count + "\n";
    }
}

