/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;

public class CacheListeners<K, V> {
    public final ICache<K, V> cache;
    public final ConcurrentMap<Long, ICacheEventQueue<K, V>> eventQMap = new ConcurrentHashMap<Long, ICacheEventQueue<K, V>>();

    public CacheListeners(ICache<K, V> iCache) {
        if (iCache == null) {
            throw new IllegalArgumentException("cache must not be null");
        }
        this.cache = iCache;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n CacheListeners");
        if (this.cache != null) {
            stringBuilder.append("\n Region = " + this.cache.getCacheName());
        }
        if (this.eventQMap != null) {
            stringBuilder.append("\n Event Queue Map ");
            stringBuilder.append("\n size = " + this.eventQMap.size());
            Iterator iterator = this.eventQMap.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append("\n Entry: " + iterator.next());
            }
        } else {
            stringBuilder.append("\n No Listeners. ");
        }
        return stringBuilder.toString();
    }
}

