/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;
import org.sejda.sambox.filter.IdentityFilter;

final class CryptFilter
extends Filter {
    CryptFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        COSName encryptionName = (COSName)parameters.getDictionaryObject(COSName.NAME);
        if (encryptionName == null || encryptionName.equals(COSName.IDENTITY)) {
            IdentityFilter identityFilter = new IdentityFilter();
            ((Filter)identityFilter).decode(encoded, decoded, parameters, index);
            return new DecodeResult(parameters);
        }
        throw new IOException("Unsupported crypt filter " + encryptionName.getName());
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        COSName encryptionName = (COSName)parameters.getDictionaryObject(COSName.NAME);
        if (encryptionName != null && !encryptionName.equals(COSName.IDENTITY)) {
            throw new IOException("Unsupported crypt filter " + encryptionName.getName());
        }
        IdentityFilter identityFilter = new IdentityFilter();
        ((Filter)identityFilter).encode(input, encoded, parameters);
    }
}

