/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.XrefStream;
import org.sejda.sambox.util.Charsets;
import org.sejda.sambox.xref.XrefEntry;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPDFWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPDFWriter.class);
    byte COMMENT = (byte)37;
    byte[] GARBAGE = new byte[]{-89, -29, -15, -15};
    private IndirectObjectsWriter writer;

    public DefaultPDFWriter(IndirectObjectsWriter writer) {
        RequireUtils.requireNotNullArg(writer, "Cannot write to a null COSWriter");
        this.writer = writer;
    }

    public void writeHeader(String version) throws IOException {
        LOG.debug("Writing header " + version);
        this.writer().write("%PDF-");
        this.writer().write(version);
        this.writer().writeEOL();
        this.writer().write(this.COMMENT);
        this.writer().write(this.GARBAGE);
        this.writer().writeEOL();
    }

    public long writeXrefTable() throws IOException {
        long startxref = this.writer().offset();
        LOG.debug("Writing xref table at offset " + startxref);
        if (this.writer.context().putWritten(XrefEntry.DEFAULT_FREE_ENTRY) != null) {
            LOG.warn("Reserved object number 0 has been overwritten with the expected free entry");
        }
        this.writer().write("xref");
        this.writer().writeEOL();
        this.writer().write("0 " + this.writer.context().written());
        this.writer().writeEOL();
        for (long key = 0L; key <= this.writer.context().highestWritten().getObjectNumber(); ++key) {
            this.writer().write(Optional.ofNullable(this.writer.context().getWritten(key)).orElse(XrefEntry.DEFAULT_FREE_ENTRY).toXrefTableEntry());
        }
        return startxref;
    }

    public void writeTrailer(COSDictionary trailer, long startxref) throws IOException {
        LOG.trace("Writing trailer");
        trailer.removeItem(COSName.PREV);
        trailer.removeItem(COSName.XREF_STM);
        trailer.removeItem(COSName.DOC_CHECKSUM);
        trailer.removeItem(COSName.DECODE_PARMS);
        trailer.removeItem(COSName.F_DECODE_PARMS);
        trailer.removeItem(COSName.F_FILTER);
        trailer.removeItem(COSName.F);
        trailer.setLong(COSName.SIZE, this.writer.context().highestWritten().getObjectNumber() + 1L);
        this.writer.write("trailer".getBytes(Charsets.US_ASCII));
        this.writer.writeEOL();
        trailer.getCOSObject().accept(this.writer.writer());
        this.writeXrefFooter(startxref);
    }

    public void writeXrefStream(COSDictionary trailer) throws IOException {
        long startxref = this.writer().offset();
        LOG.debug("Writing xref stream at offset " + startxref);
        XrefEntry entry = XrefEntry.inUseEntry(this.writer.context().highestWritten().getObjectNumber() + 1L, startxref, 0);
        this.writer.context().putWritten(entry);
        this.writer.writeObject(new IndirectCOSObjectReference(entry.getObjectNumber(), entry.getGenerationNumber(), new XrefStream(trailer, this.writer.context())));
        this.writeXrefFooter(startxref);
    }

    private void writeXrefFooter(long startxref) throws IOException {
        this.writer.write("startxref".getBytes(Charsets.US_ASCII));
        this.writer.writeEOL();
        this.writer.write(Long.toString(startxref));
        this.writer.writeEOL();
        this.writer.write("%%EOF".getBytes(Charsets.US_ASCII));
        this.writer.writeEOL();
    }

    IndirectObjectsWriter writer() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.writer);
    }
}

