# Auto-generated by BabelAPI, do not modify.
"""
This namespace contains endpoints and data types for creating and managing shared links.
Additionally, this namespace contains endpoints for creating and managing shared folders.
"""

try:
    from . import babel_validators as bv
except (SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import babel_validators as bv

try:
    from . import (
        async,
        files,
        team,
    )
except (SystemError, ValueError):
    import async
    import files
    import team

class Visibility(object):
    """
    Who can access a shared link. The most open visibility is ``public``. The
    default depends on many aspects, such as team and user preferences and
    shared folder settings.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar public: Anyone who has received the link can access it. No login
        required.
    :ivar team_only: Only members of the same team can access the link. Login is
        required.
    :ivar password: A link-specific password is required to access the link.
        Login is not required.
    :ivar team_and_password: Only members of the same team who have the
        link-specific password can access the link.
    :ivar shared_folder_only: Only members of the shared folder containing the
        linked file can access the link. Login is required.
    :ivar other: An unknown restriction is in place.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    public = None
    # Attribute is overwritten below the class definition
    team_only = None
    # Attribute is overwritten below the class definition
    password = None
    # Attribute is overwritten below the class definition
    team_and_password = None
    # Attribute is overwritten below the class definition
    shared_folder_only = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_public(self):
        """
        Check if the union tag is ``public``.

        :rtype: bool
        """
        return self._tag == 'public'

    def is_team_only(self):
        """
        Check if the union tag is ``team_only``.

        :rtype: bool
        """
        return self._tag == 'team_only'

    def is_password(self):
        """
        Check if the union tag is ``password``.

        :rtype: bool
        """
        return self._tag == 'password'

    def is_team_and_password(self):
        """
        Check if the union tag is ``team_and_password``.

        :rtype: bool
        """
        return self._tag == 'team_and_password'

    def is_shared_folder_only(self):
        """
        Check if the union tag is ``shared_folder_only``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_only'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'Visibility(%r, %r)' % (self._tag, self._value)

class LinkMetadata(object):
    """
    Metadata for a shared link. This can be either a :class:`PathLinkMetadata`
    or :class:`CollectionLinkMetadata`.

    :ivar url: URL of the shared link.
    :ivar visibility: Who can access the link.
    :ivar expires: Expiration time, if set. By default the link won't expire.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
        '_visibility_value',
        '_visibility_present',
        '_expires_value',
        '_expires_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 visibility=None,
                 expires=None):
        self._url_value = None
        self._url_present = False
        self._visibility_value = None
        self._visibility_present = False
        self._expires_value = None
        self._expires_present = False
        if url is not None:
            self.url = url
        if visibility is not None:
            self.visibility = visibility
        if expires is not None:
            self.expires = expires

    @property
    def url(self):
        """
        URL of the shared link.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    @property
    def visibility(self):
        """
        Who can access the link.

        :rtype: Visibility
        """
        if self._visibility_present:
            return self._visibility_value
        else:
            raise AttributeError("missing required field 'visibility'")

    @visibility.setter
    def visibility(self, val):
        self._visibility_validator.validate_type_only(val)
        self._visibility_value = val
        self._visibility_present = True

    @visibility.deleter
    def visibility(self):
        self._visibility_value = None
        self._visibility_present = False

    @property
    def expires(self):
        """
        Expiration time, if set. By default the link won't expire.

        :rtype: datetime.datetime
        """
        if self._expires_present:
            return self._expires_value
        else:
            return None

    @expires.setter
    def expires(self, val):
        if val is None:
            del self.expires
            return
        val = self._expires_validator.validate(val)
        self._expires_value = val
        self._expires_present = True

    @expires.deleter
    def expires(self):
        self._expires_value = None
        self._expires_present = False

    def __repr__(self):
        return 'LinkMetadata(url={!r}, visibility={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._expires_value,
        )

class PathLinkMetadata(LinkMetadata):
    """
    Metadata for a path-based shared link.

    :ivar path: Path in user's Dropbox.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 visibility=None,
                 path=None,
                 expires=None):
        super(PathLinkMetadata, self).__init__(url,
                                               visibility,
                                               expires)
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        Path in user's Dropbox.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'PathLinkMetadata(url={!r}, visibility={!r}, path={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._path_value,
            self._expires_value,
        )

class CollectionLinkMetadata(LinkMetadata):
    """
    Metadata for a collection-based shared link.
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None,
                 visibility=None,
                 expires=None):
        super(CollectionLinkMetadata, self).__init__(url,
                                                     visibility,
                                                     expires)

    def __repr__(self):
        return 'CollectionLinkMetadata(url={!r}, visibility={!r}, expires={!r})'.format(
            self._url_value,
            self._visibility_value,
            self._expires_value,
        )

class GetSharedLinksArg(object):
    """
    :ivar path: See get_shared_links description.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        See get_shared_links description.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            return None

    @path.setter
    def path(self, val):
        if val is None:
            del self.path
            return
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'GetSharedLinksArg(path={!r})'.format(
            self._path_value,
        )

class GetSharedLinksResult(object):
    """
    :ivar links: Shared links applicable to the path argument.
    """

    __slots__ = [
        '_links_value',
        '_links_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 links=None):
        self._links_value = None
        self._links_present = False
        if links is not None:
            self.links = links

    @property
    def links(self):
        """
        Shared links applicable to the path argument.

        :rtype: list of [LinkMetadata]
        """
        if self._links_present:
            return self._links_value
        else:
            raise AttributeError("missing required field 'links'")

    @links.setter
    def links(self, val):
        val = self._links_validator.validate(val)
        self._links_value = val
        self._links_present = True

    @links.deleter
    def links(self):
        self._links_value = None
        self._links_present = False

    def __repr__(self):
        return 'GetSharedLinksResult(links={!r})'.format(
            self._links_value,
        )

class GetSharedLinksError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param str val:
        :rtype: GetSharedLinksError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: str
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetSharedLinksError(%r, %r)' % (self._tag, self._value)

class PendingUploadMode(object):
    """
    Flag to indicate pending upload default (for linking to not-yet-existing
    paths).

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar file: Assume pending uploads are files.
    :ivar folder: Assume pending uploads are folders.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = None
    # Attribute is overwritten below the class definition
    file = None
    # Attribute is overwritten below the class definition
    folder = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_file(self):
        """
        Check if the union tag is ``file``.

        :rtype: bool
        """
        return self._tag == 'file'

    def is_folder(self):
        """
        Check if the union tag is ``folder``.

        :rtype: bool
        """
        return self._tag == 'folder'

    def __repr__(self):
        return 'PendingUploadMode(%r, %r)' % (self._tag, self._value)

class CreateSharedLinkArg(object):
    """
    :ivar path: The path to share.
    :ivar short_url: Whether to return a shortened URL.
    :ivar pending_upload: If it's okay to share a path that does not yet exist,
        set this to either ``PendingUploadMode.file`` or
        ``PendingUploadMode.folder`` to indicate whether to assume it's a file
        or folder.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_short_url_value',
        '_short_url_present',
        '_pending_upload_value',
        '_pending_upload_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 short_url=None,
                 pending_upload=None):
        self._path_value = None
        self._path_present = False
        self._short_url_value = None
        self._short_url_present = False
        self._pending_upload_value = None
        self._pending_upload_present = False
        if path is not None:
            self.path = path
        if short_url is not None:
            self.short_url = short_url
        if pending_upload is not None:
            self.pending_upload = pending_upload

    @property
    def path(self):
        """
        The path to share.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def short_url(self):
        """
        Whether to return a shortened URL.

        :rtype: bool
        """
        if self._short_url_present:
            return self._short_url_value
        else:
            return False

    @short_url.setter
    def short_url(self, val):
        val = self._short_url_validator.validate(val)
        self._short_url_value = val
        self._short_url_present = True

    @short_url.deleter
    def short_url(self):
        self._short_url_value = None
        self._short_url_present = False

    @property
    def pending_upload(self):
        """
        If it's okay to share a path that does not yet exist, set this to either
        ``PendingUploadMode.file`` or ``PendingUploadMode.folder`` to indicate
        whether to assume it's a file or folder.

        :rtype: PendingUploadMode
        """
        if self._pending_upload_present:
            return self._pending_upload_value
        else:
            return None

    @pending_upload.setter
    def pending_upload(self, val):
        if val is None:
            del self.pending_upload
            return
        self._pending_upload_validator.validate_type_only(val)
        self._pending_upload_value = val
        self._pending_upload_present = True

    @pending_upload.deleter
    def pending_upload(self):
        self._pending_upload_value = None
        self._pending_upload_present = False

    def __repr__(self):
        return 'CreateSharedLinkArg(path={!r}, short_url={!r}, pending_upload={!r})'.format(
            self._path_value,
            self._short_url_value,
            self._pending_upload_value,
        )

class CreateSharedLinkError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param files.LookupError val:
        :rtype: CreateSharedLinkError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: files.LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'CreateSharedLinkError(%r, %r)' % (self._tag, self._value)

class RevokeSharedLinkArg(object):
    """
    :ivar url: URL of the shared link.
    """

    __slots__ = [
        '_url_value',
        '_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 url=None):
        self._url_value = None
        self._url_present = False
        if url is not None:
            self.url = url

    @property
    def url(self):
        """
        URL of the shared link.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    def __repr__(self):
        return 'RevokeSharedLinkArg(url={!r})'.format(
            self._url_value,
        )

class RevokeSharedLinkError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar shared_link_malformed: Shared link is malformed.
    :ivar shared_link_not_found: Shared link not found.
    :ivar shared_link_access_denied: Shared link access denied.
    :ivar other: An unspecified error.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    shared_link_malformed = None
    # Attribute is overwritten below the class definition
    shared_link_not_found = None
    # Attribute is overwritten below the class definition
    shared_link_access_denied = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_shared_link_malformed(self):
        """
        Check if the union tag is ``shared_link_malformed``.

        :rtype: bool
        """
        return self._tag == 'shared_link_malformed'

    def is_shared_link_not_found(self):
        """
        Check if the union tag is ``shared_link_not_found``.

        :rtype: bool
        """
        return self._tag == 'shared_link_not_found'

    def is_shared_link_access_denied(self):
        """
        Check if the union tag is ``shared_link_access_denied``.

        :rtype: bool
        """
        return self._tag == 'shared_link_access_denied'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'RevokeSharedLinkError(%r, %r)' % (self._tag, self._value)

class AccessLevel(object):
    """
    Defines the access levels for collaborators.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar owner: The collaborator is the owner of the shared folder. Owners can
        view and edit the shared folder as well as set the folder's policies
        using update_folder_policy.
    :ivar editor: The collaborator can both view and edit the shared folder.
    :ivar viewer: The collaborator can only view the shared folder.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    owner = None
    # Attribute is overwritten below the class definition
    editor = None
    # Attribute is overwritten below the class definition
    viewer = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_owner(self):
        """
        Check if the union tag is ``owner``.

        :rtype: bool
        """
        return self._tag == 'owner'

    def is_editor(self):
        """
        Check if the union tag is ``editor``.

        :rtype: bool
        """
        return self._tag == 'editor'

    def is_viewer(self):
        """
        Check if the union tag is ``viewer``.

        :rtype: bool
        """
        return self._tag == 'viewer'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'AccessLevel(%r, %r)' % (self._tag, self._value)

class FolderPolicy(object):
    """
    A set of policies governing membership and privileges for a shared folder.

    :ivar member_policy: Who can be a member of this shared folder. Only set if
        the user is a member of a team.
    :ivar acl_update_policy: Who can add and remove members from this shared
        folder.
    :ivar shared_link_policy: Who links can be shared with.
    """

    __slots__ = [
        '_member_policy_value',
        '_member_policy_present',
        '_acl_update_policy_value',
        '_acl_update_policy_present',
        '_shared_link_policy_value',
        '_shared_link_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 acl_update_policy=None,
                 shared_link_policy=None,
                 member_policy=None):
        self._member_policy_value = None
        self._member_policy_present = False
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False
        if member_policy is not None:
            self.member_policy = member_policy
        if acl_update_policy is not None:
            self.acl_update_policy = acl_update_policy
        if shared_link_policy is not None:
            self.shared_link_policy = shared_link_policy

    @property
    def member_policy(self):
        """
        Who can be a member of this shared folder. Only set if the user is a
        member of a team.

        :rtype: MemberPolicy
        """
        if self._member_policy_present:
            return self._member_policy_value
        else:
            return None

    @member_policy.setter
    def member_policy(self, val):
        if val is None:
            del self.member_policy
            return
        self._member_policy_validator.validate_type_only(val)
        self._member_policy_value = val
        self._member_policy_present = True

    @member_policy.deleter
    def member_policy(self):
        self._member_policy_value = None
        self._member_policy_present = False

    @property
    def acl_update_policy(self):
        """
        Who can add and remove members from this shared folder.

        :rtype: AclUpdatePolicy
        """
        if self._acl_update_policy_present:
            return self._acl_update_policy_value
        else:
            raise AttributeError("missing required field 'acl_update_policy'")

    @acl_update_policy.setter
    def acl_update_policy(self, val):
        self._acl_update_policy_validator.validate_type_only(val)
        self._acl_update_policy_value = val
        self._acl_update_policy_present = True

    @acl_update_policy.deleter
    def acl_update_policy(self):
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False

    @property
    def shared_link_policy(self):
        """
        Who links can be shared with.

        :rtype: SharedLinkPolicy
        """
        if self._shared_link_policy_present:
            return self._shared_link_policy_value
        else:
            raise AttributeError("missing required field 'shared_link_policy'")

    @shared_link_policy.setter
    def shared_link_policy(self, val):
        self._shared_link_policy_validator.validate_type_only(val)
        self._shared_link_policy_value = val
        self._shared_link_policy_present = True

    @shared_link_policy.deleter
    def shared_link_policy(self):
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False

    def __repr__(self):
        return 'FolderPolicy(acl_update_policy={!r}, shared_link_policy={!r}, member_policy={!r})'.format(
            self._acl_update_policy_value,
            self._shared_link_policy_value,
            self._member_policy_value,
        )

class MemberPolicy(object):
    """
    Policy governing who can be a member of a shared folder. Only applicable to
    folders owned by a user on a team.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar team: Only a teammate can become a member.
    :ivar anyone: Anyone can become a member.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    team = None
    # Attribute is overwritten below the class definition
    anyone = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_anyone(self):
        """
        Check if the union tag is ``anyone``.

        :rtype: bool
        """
        return self._tag == 'anyone'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'MemberPolicy(%r, %r)' % (self._tag, self._value)

class AclUpdatePolicy(object):
    """
    Policy governing who can change a shared folder's access control list (ACL).
    In other words, who can add, remove, or change the privileges of members.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar owner: Only the owner can update the ACL.
    :ivar editors: Any editor can update the ACL. This may be further restricted
        to editors on the same team.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    owner = None
    # Attribute is overwritten below the class definition
    editors = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_owner(self):
        """
        Check if the union tag is ``owner``.

        :rtype: bool
        """
        return self._tag == 'owner'

    def is_editors(self):
        """
        Check if the union tag is ``editors``.

        :rtype: bool
        """
        return self._tag == 'editors'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'AclUpdatePolicy(%r, %r)' % (self._tag, self._value)

class SharedLinkPolicy(object):
    """
    Policy governing who can view shared links.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar anyone: Links can be shared with anyone.
    :ivar members: Links can only be shared among members of the shared folder.
    :ivar other: An unknown shared link policy.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    anyone = None
    # Attribute is overwritten below the class definition
    members = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_anyone(self):
        """
        Check if the union tag is ``anyone``.

        :rtype: bool
        """
        return self._tag == 'anyone'

    def is_members(self):
        """
        Check if the union tag is ``members``.

        :rtype: bool
        """
        return self._tag == 'members'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedLinkPolicy(%r, %r)' % (self._tag, self._value)

class MembershipInfo(object):
    """
    The information about a member of the shared folder.

    :ivar access_type: The access type for this member.
    """

    __slots__ = [
        '_access_type_value',
        '_access_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None):
        self._access_type_value = None
        self._access_type_present = False
        if access_type is not None:
            self.access_type = access_type

    @property
    def access_type(self):
        """
        The access type for this member.

        :rtype: AccessLevel
        """
        if self._access_type_present:
            return self._access_type_value
        else:
            raise AttributeError("missing required field 'access_type'")

    @access_type.setter
    def access_type(self, val):
        self._access_type_validator.validate_type_only(val)
        self._access_type_value = val
        self._access_type_present = True

    @access_type.deleter
    def access_type(self):
        self._access_type_value = None
        self._access_type_present = False

    def __repr__(self):
        return 'MembershipInfo(access_type={!r})'.format(
            self._access_type_value,
        )

class UserInfo(object):
    """
    Basic information about a user. Use users.get_account and
    users.get_account_batch` to obtain more detailed information.

    :ivar account_id: The account ID of the user.
    :ivar same_team: If the user is in the same team as current user.
    :ivar team_member_id: The team member ID of the shared folder member. Only
        present if ``same_team`` is true.
    """

    __slots__ = [
        '_account_id_value',
        '_account_id_present',
        '_same_team_value',
        '_same_team_present',
        '_team_member_id_value',
        '_team_member_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 account_id=None,
                 same_team=None,
                 team_member_id=None):
        self._account_id_value = None
        self._account_id_present = False
        self._same_team_value = None
        self._same_team_present = False
        self._team_member_id_value = None
        self._team_member_id_present = False
        if account_id is not None:
            self.account_id = account_id
        if same_team is not None:
            self.same_team = same_team
        if team_member_id is not None:
            self.team_member_id = team_member_id

    @property
    def account_id(self):
        """
        The account ID of the user.

        :rtype: str
        """
        if self._account_id_present:
            return self._account_id_value
        else:
            raise AttributeError("missing required field 'account_id'")

    @account_id.setter
    def account_id(self, val):
        val = self._account_id_validator.validate(val)
        self._account_id_value = val
        self._account_id_present = True

    @account_id.deleter
    def account_id(self):
        self._account_id_value = None
        self._account_id_present = False

    @property
    def same_team(self):
        """
        If the user is in the same team as current user.

        :rtype: bool
        """
        if self._same_team_present:
            return self._same_team_value
        else:
            raise AttributeError("missing required field 'same_team'")

    @same_team.setter
    def same_team(self, val):
        val = self._same_team_validator.validate(val)
        self._same_team_value = val
        self._same_team_present = True

    @same_team.deleter
    def same_team(self):
        self._same_team_value = None
        self._same_team_present = False

    @property
    def team_member_id(self):
        """
        The team member ID of the shared folder member. Only present if
        ``same_team`` is true.

        :rtype: str
        """
        if self._team_member_id_present:
            return self._team_member_id_value
        else:
            return None

    @team_member_id.setter
    def team_member_id(self, val):
        if val is None:
            del self.team_member_id
            return
        val = self._team_member_id_validator.validate(val)
        self._team_member_id_value = val
        self._team_member_id_present = True

    @team_member_id.deleter
    def team_member_id(self):
        self._team_member_id_value = None
        self._team_member_id_present = False

    def __repr__(self):
        return 'UserInfo(account_id={!r}, same_team={!r}, team_member_id={!r})'.format(
            self._account_id_value,
            self._same_team_value,
            self._team_member_id_value,
        )

class UserMembershipInfo(MembershipInfo):
    """
    The information about a user member of the shared folder.

    :ivar user: The account information for the membership user.
    """

    __slots__ = [
        '_user_value',
        '_user_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 user=None):
        super(UserMembershipInfo, self).__init__(access_type)
        self._user_value = None
        self._user_present = False
        if user is not None:
            self.user = user

    @property
    def user(self):
        """
        The account information for the membership user.

        :rtype: UserInfo
        """
        if self._user_present:
            return self._user_value
        else:
            raise AttributeError("missing required field 'user'")

    @user.setter
    def user(self, val):
        self._user_validator.validate_type_only(val)
        self._user_value = val
        self._user_present = True

    @user.deleter
    def user(self):
        self._user_value = None
        self._user_present = False

    def __repr__(self):
        return 'UserMembershipInfo(access_type={!r}, user={!r})'.format(
            self._access_type_value,
            self._user_value,
        )

class InviteeInfo(object):
    """
    The information about a user invited to become a member a shared folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str email: E-mail address of invited user.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def email(cls, val):
        """
        Create an instance of this class set to the ``email`` tag with value
        ``val``.

        :param str val:
        :rtype: InviteeInfo
        """
        return cls('email', val)

    def is_email(self):
        """
        Check if the union tag is ``email``.

        :rtype: bool
        """
        return self._tag == 'email'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_email(self):
        """
        E-mail address of invited user.

        Only call this if :meth:`is_email` is true.

        :rtype: str
        """
        if not self.is_email():
            raise AttributeError("tag 'email' not set")
        return self._value

    def __repr__(self):
        return 'InviteeInfo(%r, %r)' % (self._tag, self._value)

class InviteeMembershipInfo(MembershipInfo):
    """
    The information about a user invited to become a member of a shared folder.

    :ivar invitee: The information for the invited user.
    """

    __slots__ = [
        '_invitee_value',
        '_invitee_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 invitee=None):
        super(InviteeMembershipInfo, self).__init__(access_type)
        self._invitee_value = None
        self._invitee_present = False
        if invitee is not None:
            self.invitee = invitee

    @property
    def invitee(self):
        """
        The information for the invited user.

        :rtype: InviteeInfo
        """
        if self._invitee_present:
            return self._invitee_value
        else:
            raise AttributeError("missing required field 'invitee'")

    @invitee.setter
    def invitee(self, val):
        self._invitee_validator.validate_type_only(val)
        self._invitee_value = val
        self._invitee_present = True

    @invitee.deleter
    def invitee(self):
        self._invitee_value = None
        self._invitee_present = False

    def __repr__(self):
        return 'InviteeMembershipInfo(access_type={!r}, invitee={!r})'.format(
            self._access_type_value,
            self._invitee_value,
        )

class GroupInfo(team.GroupSummary):
    """
    The information about a group. Groups is a way to manage a list of users
    who need same access permission to the shared folder.

    :ivar same_team: If the group is owned by the current user's team.
    """

    __slots__ = [
        '_same_team_value',
        '_same_team_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_name=None,
                 group_id=None,
                 member_count=None,
                 same_team=None,
                 group_external_id=None):
        super(GroupInfo, self).__init__(group_name,
                                        group_id,
                                        member_count,
                                        group_external_id)
        self._same_team_value = None
        self._same_team_present = False
        if same_team is not None:
            self.same_team = same_team

    @property
    def same_team(self):
        """
        If the group is owned by the current user's team.

        :rtype: bool
        """
        if self._same_team_present:
            return self._same_team_value
        else:
            raise AttributeError("missing required field 'same_team'")

    @same_team.setter
    def same_team(self, val):
        val = self._same_team_validator.validate(val)
        self._same_team_value = val
        self._same_team_present = True

    @same_team.deleter
    def same_team(self):
        self._same_team_value = None
        self._same_team_present = False

    def __repr__(self):
        return 'GroupInfo(group_name={!r}, group_id={!r}, member_count={!r}, same_team={!r}, group_external_id={!r})'.format(
            self._group_name_value,
            self._group_id_value,
            self._member_count_value,
            self._same_team_value,
            self._group_external_id_value,
        )

class GroupMembershipInfo(MembershipInfo):
    """
    The information about a group member of the shared folder.

    :ivar group: The information about the membership group.
    """

    __slots__ = [
        '_group_value',
        '_group_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_type=None,
                 group=None):
        super(GroupMembershipInfo, self).__init__(access_type)
        self._group_value = None
        self._group_present = False
        if group is not None:
            self.group = group

    @property
    def group(self):
        """
        The information about the membership group.

        :rtype: GroupInfo
        """
        if self._group_present:
            return self._group_value
        else:
            raise AttributeError("missing required field 'group'")

    @group.setter
    def group(self, val):
        self._group_validator.validate_type_only(val)
        self._group_value = val
        self._group_present = True

    @group.deleter
    def group(self):
        self._group_value = None
        self._group_present = False

    def __repr__(self):
        return 'GroupMembershipInfo(access_type={!r}, group={!r})'.format(
            self._access_type_value,
            self._group_value,
        )

class SharedFolderMetadata(object):
    """
    The metadata which includes basic information about the shared folder.

    :ivar path_lower: The lower-cased full path of this shared folder. Absent
        for unmounted folders.
    :ivar name: The name of the this shared folder.
    :ivar shared_folder_id: The ID of the shared folder.
    :ivar access_type: The current user's access level for this shared folder.
    :ivar is_team_folder: Whether this folder is a `team folder
        <https://www.dropbox.com/en/help/986>`_.
    :ivar policy: Policies governing this shared folder.
    """

    __slots__ = [
        '_path_lower_value',
        '_path_lower_present',
        '_name_value',
        '_name_present',
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_access_type_value',
        '_access_type_present',
        '_is_team_folder_value',
        '_is_team_folder_present',
        '_policy_value',
        '_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 shared_folder_id=None,
                 access_type=None,
                 is_team_folder=None,
                 policy=None,
                 path_lower=None):
        self._path_lower_value = None
        self._path_lower_present = False
        self._name_value = None
        self._name_present = False
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._access_type_value = None
        self._access_type_present = False
        self._is_team_folder_value = None
        self._is_team_folder_present = False
        self._policy_value = None
        self._policy_present = False
        if path_lower is not None:
            self.path_lower = path_lower
        if name is not None:
            self.name = name
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if access_type is not None:
            self.access_type = access_type
        if is_team_folder is not None:
            self.is_team_folder = is_team_folder
        if policy is not None:
            self.policy = policy

    @property
    def path_lower(self):
        """
        The lower-cased full path of this shared folder. Absent for unmounted
        folders.

        :rtype: str
        """
        if self._path_lower_present:
            return self._path_lower_value
        else:
            return None

    @path_lower.setter
    def path_lower(self, val):
        if val is None:
            del self.path_lower
            return
        val = self._path_lower_validator.validate(val)
        self._path_lower_value = val
        self._path_lower_present = True

    @path_lower.deleter
    def path_lower(self):
        self._path_lower_value = None
        self._path_lower_present = False

    @property
    def name(self):
        """
        The name of the this shared folder.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def shared_folder_id(self):
        """
        The ID of the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def access_type(self):
        """
        The current user's access level for this shared folder.

        :rtype: AccessLevel
        """
        if self._access_type_present:
            return self._access_type_value
        else:
            raise AttributeError("missing required field 'access_type'")

    @access_type.setter
    def access_type(self, val):
        self._access_type_validator.validate_type_only(val)
        self._access_type_value = val
        self._access_type_present = True

    @access_type.deleter
    def access_type(self):
        self._access_type_value = None
        self._access_type_present = False

    @property
    def is_team_folder(self):
        """
        Whether this folder is a `team folder
        <https://www.dropbox.com/en/help/986>`_.

        :rtype: bool
        """
        if self._is_team_folder_present:
            return self._is_team_folder_value
        else:
            raise AttributeError("missing required field 'is_team_folder'")

    @is_team_folder.setter
    def is_team_folder(self, val):
        val = self._is_team_folder_validator.validate(val)
        self._is_team_folder_value = val
        self._is_team_folder_present = True

    @is_team_folder.deleter
    def is_team_folder(self):
        self._is_team_folder_value = None
        self._is_team_folder_present = False

    @property
    def policy(self):
        """
        Policies governing this shared folder.

        :rtype: FolderPolicy
        """
        if self._policy_present:
            return self._policy_value
        else:
            raise AttributeError("missing required field 'policy'")

    @policy.setter
    def policy(self, val):
        self._policy_validator.validate_type_only(val)
        self._policy_value = val
        self._policy_present = True

    @policy.deleter
    def policy(self):
        self._policy_value = None
        self._policy_present = False

    def __repr__(self):
        return 'SharedFolderMetadata(name={!r}, shared_folder_id={!r}, access_type={!r}, is_team_folder={!r}, policy={!r}, path_lower={!r})'.format(
            self._name_value,
            self._shared_folder_id_value,
            self._access_type_value,
            self._is_team_folder_value,
            self._policy_value,
            self._path_lower_value,
        )

class SharedFolderAccessError(object):
    """
    There is an error accessing the shared folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_id: This shared folder ID is invalid.
    :ivar not_a_member: The user is not a member of the shared folder thus
        cannot access it.
    :ivar no_permission: The current user does not have sufficient privileges to
        perform the desired action.
    :ivar email_unverified: The current account's e-mail address is unverified.
    :ivar team_folder: The current user cannot perform this action on a team
        shared folder.
    :ivar unmounted: The shared folder is unmounted.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_id = None
    # Attribute is overwritten below the class definition
    not_a_member = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    email_unverified = None
    # Attribute is overwritten below the class definition
    team_folder = None
    # Attribute is overwritten below the class definition
    unmounted = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_id(self):
        """
        Check if the union tag is ``invalid_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_id'

    def is_not_a_member(self):
        """
        Check if the union tag is ``not_a_member``.

        :rtype: bool
        """
        return self._tag == 'not_a_member'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_email_unverified(self):
        """
        Check if the union tag is ``email_unverified``.

        :rtype: bool
        """
        return self._tag == 'email_unverified'

    def is_team_folder(self):
        """
        Check if the union tag is ``team_folder``.

        :rtype: bool
        """
        return self._tag == 'team_folder'

    def is_unmounted(self):
        """
        Check if the union tag is ``unmounted``.

        :rtype: bool
        """
        return self._tag == 'unmounted'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedFolderAccessError(%r, %r)' % (self._tag, self._value)

class ListFoldersResult(object):
    """
    Result for list_folders. Unmounted shared folders can be identified by the
    absence of ``SharedFolderMetadata.path_lower``.

    :ivar entries: List of all shared folders the authenticated user has access
        to.
    :ivar cursor: Present if there are additional shared folders that have not
        been returned yet. Pass the cursor into list_folders/continue to list
        additional folders.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None,
                 cursor=None):
        self._entries_value = None
        self._entries_present = False
        self._cursor_value = None
        self._cursor_present = False
        if entries is not None:
            self.entries = entries
        if cursor is not None:
            self.cursor = cursor

    @property
    def entries(self):
        """
        List of all shared folders the authenticated user has access to.

        :rtype: list of [SharedFolderMetadata]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    @property
    def cursor(self):
        """
        Present if there are additional shared folders that have not been
        returned yet. Pass the cursor into list_folders/continue to list
        additional folders.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            return None

    @cursor.setter
    def cursor(self, val):
        if val is None:
            del self.cursor
            return
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFoldersResult(entries={!r}, cursor={!r})'.format(
            self._entries_value,
            self._cursor_value,
        )

class ListFoldersContinueArg(object):
    """
    :ivar cursor: The cursor returned by your last call to list_folders or
        list_folders/continue.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor returned by your last call to list_folders or
        list_folders/continue.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFoldersContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

class ListFoldersContinueError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_cursor: ``ListFoldersContinueArg.cursor`` is invalid.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_cursor = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_cursor(self):
        """
        Check if the union tag is ``invalid_cursor``.

        :rtype: bool
        """
        return self._tag == 'invalid_cursor'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ListFoldersContinueError(%r, %r)' % (self._tag, self._value)

class GetMetadataArgs(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'GetMetadataArgs(shared_folder_id={!r})'.format(
            self._shared_folder_id_value,
        )

class ListFolderMembersArgs(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'ListFolderMembersArgs(shared_folder_id={!r})'.format(
            self._shared_folder_id_value,
        )

class SharedFolderMembers(object):
    """
    Shared folder user and group membership.

    :ivar users: The list of user members of the shared folder.
    :ivar groups: The list of group members of the shared folder.
    :ivar invitees: The list of invited members of the shared folder. This list
        will not include invitees that have already accepted or declined to join
        the shared folder.
    :ivar cursor: Present if there are additional shared folder members that
        have not been returned yet. Pass the cursor into
        list_folder_members/continue to list additional members.
    """

    __slots__ = [
        '_users_value',
        '_users_present',
        '_groups_value',
        '_groups_present',
        '_invitees_value',
        '_invitees_present',
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 users=None,
                 groups=None,
                 invitees=None,
                 cursor=None):
        self._users_value = None
        self._users_present = False
        self._groups_value = None
        self._groups_present = False
        self._invitees_value = None
        self._invitees_present = False
        self._cursor_value = None
        self._cursor_present = False
        if users is not None:
            self.users = users
        if groups is not None:
            self.groups = groups
        if invitees is not None:
            self.invitees = invitees
        if cursor is not None:
            self.cursor = cursor

    @property
    def users(self):
        """
        The list of user members of the shared folder.

        :rtype: list of [UserMembershipInfo]
        """
        if self._users_present:
            return self._users_value
        else:
            raise AttributeError("missing required field 'users'")

    @users.setter
    def users(self, val):
        val = self._users_validator.validate(val)
        self._users_value = val
        self._users_present = True

    @users.deleter
    def users(self):
        self._users_value = None
        self._users_present = False

    @property
    def groups(self):
        """
        The list of group members of the shared folder.

        :rtype: list of [GroupMembershipInfo]
        """
        if self._groups_present:
            return self._groups_value
        else:
            raise AttributeError("missing required field 'groups'")

    @groups.setter
    def groups(self, val):
        val = self._groups_validator.validate(val)
        self._groups_value = val
        self._groups_present = True

    @groups.deleter
    def groups(self):
        self._groups_value = None
        self._groups_present = False

    @property
    def invitees(self):
        """
        The list of invited members of the shared folder. This list will not
        include invitees that have already accepted or declined to join the
        shared folder.

        :rtype: list of [InviteeMembershipInfo]
        """
        if self._invitees_present:
            return self._invitees_value
        else:
            raise AttributeError("missing required field 'invitees'")

    @invitees.setter
    def invitees(self, val):
        val = self._invitees_validator.validate(val)
        self._invitees_value = val
        self._invitees_present = True

    @invitees.deleter
    def invitees(self):
        self._invitees_value = None
        self._invitees_present = False

    @property
    def cursor(self):
        """
        Present if there are additional shared folder members that have not been
        returned yet. Pass the cursor into list_folder_members/continue to list
        additional members.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            return None

    @cursor.setter
    def cursor(self, val):
        if val is None:
            del self.cursor
            return
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'SharedFolderMembers(users={!r}, groups={!r}, invitees={!r}, cursor={!r})'.format(
            self._users_value,
            self._groups_value,
            self._invitees_value,
            self._cursor_value,
        )

class ListFolderMembersContinueArg(object):
    """
    :ivar cursor: The cursor returned by your last call to list_folder_members
        or list_folder_members/continue.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor returned by your last call to list_folder_members or
        list_folder_members/continue.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFolderMembersContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

class ListFolderMembersContinueError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_cursor: ``ListFolderMembersContinueArg.cursor`` is invalid.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_cursor = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: ListFolderMembersContinueError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_invalid_cursor(self):
        """
        Check if the union tag is ``invalid_cursor``.

        :rtype: bool
        """
        return self._tag == 'invalid_cursor'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'ListFolderMembersContinueError(%r, %r)' % (self._tag, self._value)

class ShareFolderArg(object):
    """
    :ivar path: The path to the folder to share. If it does not exist, then a
        new one is created.
    :ivar member_policy: Who can be a member of this shared folder.
    :ivar acl_update_policy: Who can add and remove members of this shared
        folder.
    :ivar shared_link_policy: The policy to apply to shared links created for
        content inside this shared folder.
    :ivar force_async: Whether to force the share to happen asynchronously.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_member_policy_value',
        '_member_policy_present',
        '_acl_update_policy_value',
        '_acl_update_policy_present',
        '_shared_link_policy_value',
        '_shared_link_policy_present',
        '_force_async_value',
        '_force_async_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 member_policy=None,
                 acl_update_policy=None,
                 shared_link_policy=None,
                 force_async=None):
        self._path_value = None
        self._path_present = False
        self._member_policy_value = None
        self._member_policy_present = False
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False
        self._force_async_value = None
        self._force_async_present = False
        if path is not None:
            self.path = path
        if member_policy is not None:
            self.member_policy = member_policy
        if acl_update_policy is not None:
            self.acl_update_policy = acl_update_policy
        if shared_link_policy is not None:
            self.shared_link_policy = shared_link_policy
        if force_async is not None:
            self.force_async = force_async

    @property
    def path(self):
        """
        The path to the folder to share. If it does not exist, then a new one is
        created.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def member_policy(self):
        """
        Who can be a member of this shared folder.

        :rtype: MemberPolicy
        """
        if self._member_policy_present:
            return self._member_policy_value
        else:
            return MemberPolicy.anyone

    @member_policy.setter
    def member_policy(self, val):
        self._member_policy_validator.validate_type_only(val)
        self._member_policy_value = val
        self._member_policy_present = True

    @member_policy.deleter
    def member_policy(self):
        self._member_policy_value = None
        self._member_policy_present = False

    @property
    def acl_update_policy(self):
        """
        Who can add and remove members of this shared folder.

        :rtype: AclUpdatePolicy
        """
        if self._acl_update_policy_present:
            return self._acl_update_policy_value
        else:
            return AclUpdatePolicy.owner

    @acl_update_policy.setter
    def acl_update_policy(self, val):
        self._acl_update_policy_validator.validate_type_only(val)
        self._acl_update_policy_value = val
        self._acl_update_policy_present = True

    @acl_update_policy.deleter
    def acl_update_policy(self):
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False

    @property
    def shared_link_policy(self):
        """
        The policy to apply to shared links created for content inside this
        shared folder.

        :rtype: SharedLinkPolicy
        """
        if self._shared_link_policy_present:
            return self._shared_link_policy_value
        else:
            return SharedLinkPolicy.anyone

    @shared_link_policy.setter
    def shared_link_policy(self, val):
        self._shared_link_policy_validator.validate_type_only(val)
        self._shared_link_policy_value = val
        self._shared_link_policy_present = True

    @shared_link_policy.deleter
    def shared_link_policy(self):
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False

    @property
    def force_async(self):
        """
        Whether to force the share to happen asynchronously.

        :rtype: bool
        """
        if self._force_async_present:
            return self._force_async_value
        else:
            return False

    @force_async.setter
    def force_async(self, val):
        val = self._force_async_validator.validate(val)
        self._force_async_value = val
        self._force_async_present = True

    @force_async.deleter
    def force_async(self):
        self._force_async_value = None
        self._force_async_present = False

    def __repr__(self):
        return 'ShareFolderArg(path={!r}, member_policy={!r}, acl_update_policy={!r}, shared_link_policy={!r}, force_async={!r})'.format(
            self._path_value,
            self._member_policy_value,
            self._acl_update_policy_value,
            self._shared_link_policy_value,
            self._force_async_value,
        )

class ShareFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar email_unverified: The current account's e-mail address is unverified.
    :ivar SharePathError bad_path: ``ShareFolderArg.path`` is invalid.
    :ivar team_policy_disallows_member_policy: Team policy is more restrictive
        than ``ShareFolderArg.member_policy``.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    email_unverified = None
    # Attribute is overwritten below the class definition
    team_policy_disallows_member_policy = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def bad_path(cls, val):
        """
        Create an instance of this class set to the ``bad_path`` tag with value
        ``val``.

        :param SharePathError val:
        :rtype: ShareFolderError
        """
        return cls('bad_path', val)

    def is_email_unverified(self):
        """
        Check if the union tag is ``email_unverified``.

        :rtype: bool
        """
        return self._tag == 'email_unverified'

    def is_bad_path(self):
        """
        Check if the union tag is ``bad_path``.

        :rtype: bool
        """
        return self._tag == 'bad_path'

    def is_team_policy_disallows_member_policy(self):
        """
        Check if the union tag is ``team_policy_disallows_member_policy``.

        :rtype: bool
        """
        return self._tag == 'team_policy_disallows_member_policy'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_bad_path(self):
        """
        ``ShareFolderArg.path`` is invalid.

        Only call this if :meth:`is_bad_path` is true.

        :rtype: SharePathError
        """
        if not self.is_bad_path():
            raise AttributeError("tag 'bad_path' not set")
        return self._value

    def __repr__(self):
        return 'ShareFolderError(%r, %r)' % (self._tag, self._value)

class SharePathError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar is_file: A file is at the specified path.
    :ivar inside_shared_folder: We do not support sharing a folder inside a
        shared folder.
    :ivar contains_shared_folder: We do not support shared folders that contain
        shared folders.
    :ivar is_app_folder: We do not support sharing an app folder.
    :ivar inside_app_folder: We do not support sharing a folder inside an app
        folder.
    :ivar already_shared: Folder is already shared.
    :ivar invalid_path: Path is not valid.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    is_file = None
    # Attribute is overwritten below the class definition
    inside_shared_folder = None
    # Attribute is overwritten below the class definition
    contains_shared_folder = None
    # Attribute is overwritten below the class definition
    is_app_folder = None
    # Attribute is overwritten below the class definition
    inside_app_folder = None
    # Attribute is overwritten below the class definition
    already_shared = None
    # Attribute is overwritten below the class definition
    invalid_path = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_is_file(self):
        """
        Check if the union tag is ``is_file``.

        :rtype: bool
        """
        return self._tag == 'is_file'

    def is_inside_shared_folder(self):
        """
        Check if the union tag is ``inside_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'inside_shared_folder'

    def is_contains_shared_folder(self):
        """
        Check if the union tag is ``contains_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'contains_shared_folder'

    def is_is_app_folder(self):
        """
        Check if the union tag is ``is_app_folder``.

        :rtype: bool
        """
        return self._tag == 'is_app_folder'

    def is_inside_app_folder(self):
        """
        Check if the union tag is ``inside_app_folder``.

        :rtype: bool
        """
        return self._tag == 'inside_app_folder'

    def is_already_shared(self):
        """
        Check if the union tag is ``already_shared``.

        :rtype: bool
        """
        return self._tag == 'already_shared'

    def is_invalid_path(self):
        """
        Check if the union tag is ``invalid_path``.

        :rtype: bool
        """
        return self._tag == 'invalid_path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharePathError(%r, %r)' % (self._tag, self._value)

class ShareFolderJobStatus(async.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar SharedFolderMetadata complete: The share job has finished. The value
        is the metadata for the folder.
    """

    __slots__ = ['_tag', '_value']

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param SharedFolderMetadata val:
        :rtype: ShareFolderJobStatus
        """
        return cls('complete', val)

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param ShareFolderError val:
        :rtype: ShareFolderJobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def get_complete(self):
        """
        The share job has finished. The value is the metadata for the folder.

        Only call this if :meth:`is_complete` is true.

        :rtype: SharedFolderMetadata
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def get_failed(self):
        """
        Only call this if :meth:`is_failed` is true.

        :rtype: ShareFolderError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'ShareFolderJobStatus(%r, %r)' % (self._tag, self._value)

class ShareFolderLaunch(async.LaunchResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param SharedFolderMetadata val:
        :rtype: ShareFolderLaunch
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def get_complete(self):
        """
        Only call this if :meth:`is_complete` is true.

        :rtype: SharedFolderMetadata
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'ShareFolderLaunch(%r, %r)' % (self._tag, self._value)

class JobStatus(async.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar complete: The asynchronous job has finished.
    :ivar JobError failed: The asynchronous job returned an error.
    """

    __slots__ = ['_tag', '_value']

    # Attribute is overwritten below the class definition
    complete = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param JobError val:
        :rtype: JobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def get_failed(self):
        """
        The asynchronous job returned an error.

        Only call this if :meth:`is_failed` is true.

        :rtype: JobError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'JobStatus(%r, %r)' % (self._tag, self._value)

class SharedFolderMemberError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_dropbox_id: The target dropbox_id is invalid.
    :ivar not_a_member: The target dropbox_id is not a member of the shared
        folder.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_dropbox_id = None
    # Attribute is overwritten below the class definition
    not_a_member = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    def is_invalid_dropbox_id(self):
        """
        Check if the union tag is ``invalid_dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_dropbox_id'

    def is_not_a_member(self):
        """
        Check if the union tag is ``not_a_member``.

        :rtype: bool
        """
        return self._tag == 'not_a_member'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedFolderMemberError(%r, %r)' % (self._tag, self._value)

class JobError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: JobError
        """
        return cls('access_error', val)

    @classmethod
    def member_error(cls, val):
        """
        Create an instance of this class set to the ``member_error`` tag with
        value ``val``.

        :param SharedFolderMemberError val:
        :rtype: JobError
        """
        return cls('member_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_member_error(self):
        """
        Check if the union tag is ``member_error``.

        :rtype: bool
        """
        return self._tag == 'member_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def get_member_error(self):
        """
        Only call this if :meth:`is_member_error` is true.

        :rtype: SharedFolderMemberError
        """
        if not self.is_member_error():
            raise AttributeError("tag 'member_error' not set")
        return self._value

    def __repr__(self):
        return 'JobError(%r, %r)' % (self._tag, self._value)

class UnshareFolderArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar leave_a_copy: If true, members of this shared folder will get a copy
        of this folder after it's unshared. Otherwise, it will be removed from
        their Dropbox. The current user, who is an owner, will always retain
        their copy.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_leave_a_copy_value',
        '_leave_a_copy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 leave_a_copy=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._leave_a_copy_value = None
        self._leave_a_copy_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if leave_a_copy is not None:
            self.leave_a_copy = leave_a_copy

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def leave_a_copy(self):
        """
        If true, members of this shared folder will get a copy of this folder
        after it's unshared. Otherwise, it will be removed from their Dropbox.
        The current user, who is an owner, will always retain their copy.

        :rtype: bool
        """
        if self._leave_a_copy_present:
            return self._leave_a_copy_value
        else:
            raise AttributeError("missing required field 'leave_a_copy'")

    @leave_a_copy.setter
    def leave_a_copy(self, val):
        val = self._leave_a_copy_validator.validate(val)
        self._leave_a_copy_value = val
        self._leave_a_copy_present = True

    @leave_a_copy.deleter
    def leave_a_copy(self):
        self._leave_a_copy_value = None
        self._leave_a_copy_present = False

    def __repr__(self):
        return 'UnshareFolderArg(shared_folder_id={!r}, leave_a_copy={!r})'.format(
            self._shared_folder_id_value,
            self._leave_a_copy_value,
        )

class UnshareFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: UnshareFolderError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'UnshareFolderError(%r, %r)' % (self._tag, self._value)

class TransferFolderArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar to_dropbox_id: A account or team member ID to transfer ownership to.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_to_dropbox_id_value',
        '_to_dropbox_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 to_dropbox_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._to_dropbox_id_value = None
        self._to_dropbox_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if to_dropbox_id is not None:
            self.to_dropbox_id = to_dropbox_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def to_dropbox_id(self):
        """
        A account or team member ID to transfer ownership to.

        :rtype: str
        """
        if self._to_dropbox_id_present:
            return self._to_dropbox_id_value
        else:
            raise AttributeError("missing required field 'to_dropbox_id'")

    @to_dropbox_id.setter
    def to_dropbox_id(self, val):
        val = self._to_dropbox_id_validator.validate(val)
        self._to_dropbox_id_value = val
        self._to_dropbox_id_present = True

    @to_dropbox_id.deleter
    def to_dropbox_id(self):
        self._to_dropbox_id_value = None
        self._to_dropbox_id_present = False

    def __repr__(self):
        return 'TransferFolderArg(shared_folder_id={!r}, to_dropbox_id={!r})'.format(
            self._shared_folder_id_value,
            self._to_dropbox_id_value,
        )

class TransferFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar no_permission: The current account does not have permission to perform
        this action.
    :ivar invalid_dropbox_id: ``TransferFolderArg.to_dropbox_id`` is invalid.
    :ivar new_owner_not_a_member: The new designated owner is not currently a
        member of the shared folder.
    :ivar new_owner_unmounted: The new desginated owner does not have the shared
        folder mounted.
    :ivar new_owner_email_unverified: The new designated owner's e-mail address
        is unverified.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    invalid_dropbox_id = None
    # Attribute is overwritten below the class definition
    new_owner_not_a_member = None
    # Attribute is overwritten below the class definition
    new_owner_unmounted = None
    # Attribute is overwritten below the class definition
    new_owner_email_unverified = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: TransferFolderError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_invalid_dropbox_id(self):
        """
        Check if the union tag is ``invalid_dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_dropbox_id'

    def is_new_owner_not_a_member(self):
        """
        Check if the union tag is ``new_owner_not_a_member``.

        :rtype: bool
        """
        return self._tag == 'new_owner_not_a_member'

    def is_new_owner_unmounted(self):
        """
        Check if the union tag is ``new_owner_unmounted``.

        :rtype: bool
        """
        return self._tag == 'new_owner_unmounted'

    def is_new_owner_email_unverified(self):
        """
        Check if the union tag is ``new_owner_email_unverified``.

        :rtype: bool
        """
        return self._tag == 'new_owner_email_unverified'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'TransferFolderError(%r, %r)' % (self._tag, self._value)

class UpdateFolderPolicyArg(object):
    """
    If any of the policy's are unset, then they retain their current setting.

    :ivar shared_folder_id: The ID for the shared folder.
    :ivar member_policy: Who can be a member of this shared folder. Only set
        this if the current user is on a team.
    :ivar acl_update_policy: Who can add and remove members of this shared
        folder.
    :ivar shared_link_policy: The policy to apply to shared links created for
        content inside this shared folder.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_member_policy_value',
        '_member_policy_present',
        '_acl_update_policy_value',
        '_acl_update_policy_present',
        '_shared_link_policy_value',
        '_shared_link_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 member_policy=None,
                 acl_update_policy=None,
                 shared_link_policy=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._member_policy_value = None
        self._member_policy_present = False
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if member_policy is not None:
            self.member_policy = member_policy
        if acl_update_policy is not None:
            self.acl_update_policy = acl_update_policy
        if shared_link_policy is not None:
            self.shared_link_policy = shared_link_policy

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def member_policy(self):
        """
        Who can be a member of this shared folder. Only set this if the current
        user is on a team.

        :rtype: MemberPolicy
        """
        if self._member_policy_present:
            return self._member_policy_value
        else:
            return None

    @member_policy.setter
    def member_policy(self, val):
        if val is None:
            del self.member_policy
            return
        self._member_policy_validator.validate_type_only(val)
        self._member_policy_value = val
        self._member_policy_present = True

    @member_policy.deleter
    def member_policy(self):
        self._member_policy_value = None
        self._member_policy_present = False

    @property
    def acl_update_policy(self):
        """
        Who can add and remove members of this shared folder.

        :rtype: AclUpdatePolicy
        """
        if self._acl_update_policy_present:
            return self._acl_update_policy_value
        else:
            return None

    @acl_update_policy.setter
    def acl_update_policy(self, val):
        if val is None:
            del self.acl_update_policy
            return
        self._acl_update_policy_validator.validate_type_only(val)
        self._acl_update_policy_value = val
        self._acl_update_policy_present = True

    @acl_update_policy.deleter
    def acl_update_policy(self):
        self._acl_update_policy_value = None
        self._acl_update_policy_present = False

    @property
    def shared_link_policy(self):
        """
        The policy to apply to shared links created for content inside this
        shared folder.

        :rtype: SharedLinkPolicy
        """
        if self._shared_link_policy_present:
            return self._shared_link_policy_value
        else:
            return None

    @shared_link_policy.setter
    def shared_link_policy(self, val):
        if val is None:
            del self.shared_link_policy
            return
        self._shared_link_policy_validator.validate_type_only(val)
        self._shared_link_policy_value = val
        self._shared_link_policy_present = True

    @shared_link_policy.deleter
    def shared_link_policy(self):
        self._shared_link_policy_value = None
        self._shared_link_policy_present = False

    def __repr__(self):
        return 'UpdateFolderPolicyArg(shared_folder_id={!r}, member_policy={!r}, acl_update_policy={!r}, shared_link_policy={!r})'.format(
            self._shared_folder_id_value,
            self._member_policy_value,
            self._acl_update_policy_value,
            self._shared_link_policy_value,
        )

class UpdateFolderPolicyError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar not_on_team: ``UpdateFolderPolicyArg.member_policy`` was set even
        though user is not on a team.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    not_on_team = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: UpdateFolderPolicyError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_not_on_team(self):
        """
        Check if the union tag is ``not_on_team``.

        :rtype: bool
        """
        return self._tag == 'not_on_team'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'UpdateFolderPolicyError(%r, %r)' % (self._tag, self._value)

class AddFolderMemberArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar members: The intended list of members to add.  Added members will
        receive invites to join the shared folder.
    :ivar quiet: Whether added members should be notified via email and device
        notifications of their invite.
    :ivar custom_message: Optional message to display to added members in their
        invitation.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_members_value',
        '_members_present',
        '_quiet_value',
        '_quiet_present',
        '_custom_message_value',
        '_custom_message_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 members=None,
                 quiet=None,
                 custom_message=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._members_value = None
        self._members_present = False
        self._quiet_value = None
        self._quiet_present = False
        self._custom_message_value = None
        self._custom_message_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if members is not None:
            self.members = members
        if quiet is not None:
            self.quiet = quiet
        if custom_message is not None:
            self.custom_message = custom_message

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def members(self):
        """
        The intended list of members to add.  Added members will receive invites
        to join the shared folder.

        :rtype: list of [AddMember]
        """
        if self._members_present:
            return self._members_value
        else:
            raise AttributeError("missing required field 'members'")

    @members.setter
    def members(self, val):
        val = self._members_validator.validate(val)
        self._members_value = val
        self._members_present = True

    @members.deleter
    def members(self):
        self._members_value = None
        self._members_present = False

    @property
    def quiet(self):
        """
        Whether added members should be notified via email and device
        notifications of their invite.

        :rtype: bool
        """
        if self._quiet_present:
            return self._quiet_value
        else:
            return False

    @quiet.setter
    def quiet(self, val):
        val = self._quiet_validator.validate(val)
        self._quiet_value = val
        self._quiet_present = True

    @quiet.deleter
    def quiet(self):
        self._quiet_value = None
        self._quiet_present = False

    @property
    def custom_message(self):
        """
        Optional message to display to added members in their invitation.

        :rtype: str
        """
        if self._custom_message_present:
            return self._custom_message_value
        else:
            return None

    @custom_message.setter
    def custom_message(self, val):
        if val is None:
            del self.custom_message
            return
        val = self._custom_message_validator.validate(val)
        self._custom_message_value = val
        self._custom_message_present = True

    @custom_message.deleter
    def custom_message(self):
        self._custom_message_value = None
        self._custom_message_present = False

    def __repr__(self):
        return 'AddFolderMemberArg(shared_folder_id={!r}, members={!r}, quiet={!r}, custom_message={!r})'.format(
            self._shared_folder_id_value,
            self._members_value,
            self._quiet_value,
            self._custom_message_value,
        )

class AddMember(object):
    """
    The member and type of access the member should have when added to a shared
    folder.

    :ivar member: The member to add to the shared folder.
    :ivar access_level: The access level to grant ``member`` to the shared
        folder.  ``AccessLevel.owner`` is disallowed.
    """

    __slots__ = [
        '_member_value',
        '_member_present',
        '_access_level_value',
        '_access_level_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 member=None,
                 access_level=None):
        self._member_value = None
        self._member_present = False
        self._access_level_value = None
        self._access_level_present = False
        if member is not None:
            self.member = member
        if access_level is not None:
            self.access_level = access_level

    @property
    def member(self):
        """
        The member to add to the shared folder.

        :rtype: MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    @property
    def access_level(self):
        """
        The access level to grant ``member`` to the shared folder.
        ``AccessLevel.owner`` is disallowed.

        :rtype: AccessLevel
        """
        if self._access_level_present:
            return self._access_level_value
        else:
            return AccessLevel.viewer

    @access_level.setter
    def access_level(self, val):
        self._access_level_validator.validate_type_only(val)
        self._access_level_value = val
        self._access_level_present = True

    @access_level.deleter
    def access_level(self):
        self._access_level_value = None
        self._access_level_present = False

    def __repr__(self):
        return 'AddMember(member={!r}, access_level={!r})'.format(
            self._member_value,
            self._access_level_value,
        )

class MemberSelector(object):
    """
    Includes different ways to identify a member of a shared folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str dropbox_id: Dropbox account, team member, or group ID of member.
    :ivar str email: E-mail address of member.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def dropbox_id(cls, val):
        """
        Create an instance of this class set to the ``dropbox_id`` tag with
        value ``val``.

        :param str val:
        :rtype: MemberSelector
        """
        return cls('dropbox_id', val)

    @classmethod
    def email(cls, val):
        """
        Create an instance of this class set to the ``email`` tag with value
        ``val``.

        :param str val:
        :rtype: MemberSelector
        """
        return cls('email', val)

    def is_dropbox_id(self):
        """
        Check if the union tag is ``dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'dropbox_id'

    def is_email(self):
        """
        Check if the union tag is ``email``.

        :rtype: bool
        """
        return self._tag == 'email'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_dropbox_id(self):
        """
        Dropbox account, team member, or group ID of member.

        Only call this if :meth:`is_dropbox_id` is true.

        :rtype: str
        """
        if not self.is_dropbox_id():
            raise AttributeError("tag 'dropbox_id' not set")
        return self._value

    def get_email(self):
        """
        E-mail address of member.

        Only call this if :meth:`is_email` is true.

        :rtype: str
        """
        if not self.is_email():
            raise AttributeError("tag 'email' not set")
        return self._value

    def __repr__(self):
        return 'MemberSelector(%r, %r)' % (self._tag, self._value)

class AddFolderMemberError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar SharedFolderAccessError access_error: Unable to access shared folder.
    :ivar email_unverified: The current account's e-mail address is unverified.
    :ivar AddMemberSelectorError bad_member: ``AddFolderMemberArg.members``
        contains a bad invitation recipient.
    :ivar no_permission: The current account does not have permission to perform
        this action.
    :ivar cant_share_outside_team: Your team policy does not allow sharing
        outside of the team.
    :ivar long too_many_members: The value is the member limit that was reached.
    :ivar long too_many_pending_invites: The value is the pending invite limit
        that was reached.
    :ivar rate_limit: The user has reached the rate limit for invitations.
    :ivar insufficient_plan: The current user's account doesn't support this
        action. An example of this is when adding a read-only member. This
        action can only be performed by users that have upgraded to a Pro or
        Business plan.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    email_unverified = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    cant_share_outside_team = None
    # Attribute is overwritten below the class definition
    rate_limit = None
    # Attribute is overwritten below the class definition
    insufficient_plan = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: AddFolderMemberError
        """
        return cls('access_error', val)

    @classmethod
    def bad_member(cls, val):
        """
        Create an instance of this class set to the ``bad_member`` tag with
        value ``val``.

        :param AddMemberSelectorError val:
        :rtype: AddFolderMemberError
        """
        return cls('bad_member', val)

    @classmethod
    def too_many_members(cls, val):
        """
        Create an instance of this class set to the ``too_many_members`` tag
        with value ``val``.

        :param long val:
        :rtype: AddFolderMemberError
        """
        return cls('too_many_members', val)

    @classmethod
    def too_many_pending_invites(cls, val):
        """
        Create an instance of this class set to the ``too_many_pending_invites``
        tag with value ``val``.

        :param long val:
        :rtype: AddFolderMemberError
        """
        return cls('too_many_pending_invites', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_email_unverified(self):
        """
        Check if the union tag is ``email_unverified``.

        :rtype: bool
        """
        return self._tag == 'email_unverified'

    def is_bad_member(self):
        """
        Check if the union tag is ``bad_member``.

        :rtype: bool
        """
        return self._tag == 'bad_member'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_cant_share_outside_team(self):
        """
        Check if the union tag is ``cant_share_outside_team``.

        :rtype: bool
        """
        return self._tag == 'cant_share_outside_team'

    def is_too_many_members(self):
        """
        Check if the union tag is ``too_many_members``.

        :rtype: bool
        """
        return self._tag == 'too_many_members'

    def is_too_many_pending_invites(self):
        """
        Check if the union tag is ``too_many_pending_invites``.

        :rtype: bool
        """
        return self._tag == 'too_many_pending_invites'

    def is_rate_limit(self):
        """
        Check if the union tag is ``rate_limit``.

        :rtype: bool
        """
        return self._tag == 'rate_limit'

    def is_insufficient_plan(self):
        """
        Check if the union tag is ``insufficient_plan``.

        :rtype: bool
        """
        return self._tag == 'insufficient_plan'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Unable to access shared folder.

        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def get_bad_member(self):
        """
        ``AddFolderMemberArg.members`` contains a bad invitation recipient.

        Only call this if :meth:`is_bad_member` is true.

        :rtype: AddMemberSelectorError
        """
        if not self.is_bad_member():
            raise AttributeError("tag 'bad_member' not set")
        return self._value

    def get_too_many_members(self):
        """
        The value is the member limit that was reached.

        Only call this if :meth:`is_too_many_members` is true.

        :rtype: long
        """
        if not self.is_too_many_members():
            raise AttributeError("tag 'too_many_members' not set")
        return self._value

    def get_too_many_pending_invites(self):
        """
        The value is the pending invite limit that was reached.

        Only call this if :meth:`is_too_many_pending_invites` is true.

        :rtype: long
        """
        if not self.is_too_many_pending_invites():
            raise AttributeError("tag 'too_many_pending_invites' not set")
        return self._value

    def __repr__(self):
        return 'AddFolderMemberError(%r, %r)' % (self._tag, self._value)

class AddMemberSelectorError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str invalid_dropbox_id: The value is the ID that could not be
        identified.
    :ivar str invalid_email: The value is the e-email address that is malformed.
    :ivar str unverified_dropbox_id: The value is the ID of the Dropbox user
        with an unverified e-mail address.  Invite unverified users by e-mail
        address instead of by their Dropbox ID.
    :ivar group_deleted: At least one of the specified groups in
        ``AddFolderMemberArg.members`` is deleted.
    :ivar group_not_on_team: Sharing to a group that is not on the current
        account's team.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    group_deleted = None
    # Attribute is overwritten below the class definition
    group_not_on_team = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def invalid_dropbox_id(cls, val):
        """
        Create an instance of this class set to the ``invalid_dropbox_id`` tag
        with value ``val``.

        :param str val:
        :rtype: AddMemberSelectorError
        """
        return cls('invalid_dropbox_id', val)

    @classmethod
    def invalid_email(cls, val):
        """
        Create an instance of this class set to the ``invalid_email`` tag with
        value ``val``.

        :param str val:
        :rtype: AddMemberSelectorError
        """
        return cls('invalid_email', val)

    @classmethod
    def unverified_dropbox_id(cls, val):
        """
        Create an instance of this class set to the ``unverified_dropbox_id``
        tag with value ``val``.

        :param str val:
        :rtype: AddMemberSelectorError
        """
        return cls('unverified_dropbox_id', val)

    def is_invalid_dropbox_id(self):
        """
        Check if the union tag is ``invalid_dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_dropbox_id'

    def is_invalid_email(self):
        """
        Check if the union tag is ``invalid_email``.

        :rtype: bool
        """
        return self._tag == 'invalid_email'

    def is_unverified_dropbox_id(self):
        """
        Check if the union tag is ``unverified_dropbox_id``.

        :rtype: bool
        """
        return self._tag == 'unverified_dropbox_id'

    def is_group_deleted(self):
        """
        Check if the union tag is ``group_deleted``.

        :rtype: bool
        """
        return self._tag == 'group_deleted'

    def is_group_not_on_team(self):
        """
        Check if the union tag is ``group_not_on_team``.

        :rtype: bool
        """
        return self._tag == 'group_not_on_team'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_invalid_dropbox_id(self):
        """
        The value is the ID that could not be identified.

        Only call this if :meth:`is_invalid_dropbox_id` is true.

        :rtype: str
        """
        if not self.is_invalid_dropbox_id():
            raise AttributeError("tag 'invalid_dropbox_id' not set")
        return self._value

    def get_invalid_email(self):
        """
        The value is the e-email address that is malformed.

        Only call this if :meth:`is_invalid_email` is true.

        :rtype: str
        """
        if not self.is_invalid_email():
            raise AttributeError("tag 'invalid_email' not set")
        return self._value

    def get_unverified_dropbox_id(self):
        """
        The value is the ID of the Dropbox user with an unverified e-mail
        address.  Invite unverified users by e-mail address instead of by their
        Dropbox ID.

        Only call this if :meth:`is_unverified_dropbox_id` is true.

        :rtype: str
        """
        if not self.is_unverified_dropbox_id():
            raise AttributeError("tag 'unverified_dropbox_id' not set")
        return self._value

    def __repr__(self):
        return 'AddMemberSelectorError(%r, %r)' % (self._tag, self._value)

class RemoveFolderMemberArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar member: The member to remove from the folder.
    :ivar leave_a_copy: If true, the removed user will keep their copy of the
        folder after it's unshared, assuming it was mounted. Otherwise, it will
        be removed from their Dropbox. Also, this must be set to false when
        kicking a group.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_member_value',
        '_member_present',
        '_leave_a_copy_value',
        '_leave_a_copy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 member=None,
                 leave_a_copy=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._member_value = None
        self._member_present = False
        self._leave_a_copy_value = None
        self._leave_a_copy_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if member is not None:
            self.member = member
        if leave_a_copy is not None:
            self.leave_a_copy = leave_a_copy

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def member(self):
        """
        The member to remove from the folder.

        :rtype: MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    @property
    def leave_a_copy(self):
        """
        If true, the removed user will keep their copy of the folder after it's
        unshared, assuming it was mounted. Otherwise, it will be removed from
        their Dropbox. Also, this must be set to false when kicking a group.

        :rtype: bool
        """
        if self._leave_a_copy_present:
            return self._leave_a_copy_value
        else:
            raise AttributeError("missing required field 'leave_a_copy'")

    @leave_a_copy.setter
    def leave_a_copy(self, val):
        val = self._leave_a_copy_validator.validate(val)
        self._leave_a_copy_value = val
        self._leave_a_copy_present = True

    @leave_a_copy.deleter
    def leave_a_copy(self):
        self._leave_a_copy_value = None
        self._leave_a_copy_present = False

    def __repr__(self):
        return 'RemoveFolderMemberArg(shared_folder_id={!r}, member={!r}, leave_a_copy={!r})'.format(
            self._shared_folder_id_value,
            self._member_value,
            self._leave_a_copy_value,
        )

class RemoveFolderMemberError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: RemoveFolderMemberError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'RemoveFolderMemberError(%r, %r)' % (self._tag, self._value)

class UpdateFolderMemberArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    :ivar member: The member of the shared folder to update.  Only the
        ``MemberSelector.dropbox_id`` may be set at this time.
    :ivar access_level: The new access level for ``member``.
        ``AccessLevel.owner`` is disallowed.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_member_value',
        '_member_present',
        '_access_level_value',
        '_access_level_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None,
                 member=None,
                 access_level=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._member_value = None
        self._member_present = False
        self._access_level_value = None
        self._access_level_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if member is not None:
            self.member = member
        if access_level is not None:
            self.access_level = access_level

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def member(self):
        """
        The member of the shared folder to update.  Only the
        ``MemberSelector.dropbox_id`` may be set at this time.

        :rtype: MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    @property
    def access_level(self):
        """
        The new access level for ``member``. ``AccessLevel.owner`` is
        disallowed.

        :rtype: AccessLevel
        """
        if self._access_level_present:
            return self._access_level_value
        else:
            raise AttributeError("missing required field 'access_level'")

    @access_level.setter
    def access_level(self, val):
        self._access_level_validator.validate_type_only(val)
        self._access_level_value = val
        self._access_level_present = True

    @access_level.deleter
    def access_level(self):
        self._access_level_value = None
        self._access_level_present = False

    def __repr__(self):
        return 'UpdateFolderMemberArg(shared_folder_id={!r}, member={!r}, access_level={!r})'.format(
            self._shared_folder_id_value,
            self._member_value,
            self._access_level_value,
        )

class UpdateFolderMemberError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar insufficient_plan: The current user's account doesn't support this
        action. An example of this is when downgrading a member from editor to
        viewer. This action can only be performed by users that have upgraded to
        a Pro or Business plan.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    insufficient_plan = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: UpdateFolderMemberError
        """
        return cls('access_error', val)

    @classmethod
    def member_error(cls, val):
        """
        Create an instance of this class set to the ``member_error`` tag with
        value ``val``.

        :param SharedFolderMemberError val:
        :rtype: UpdateFolderMemberError
        """
        return cls('member_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_member_error(self):
        """
        Check if the union tag is ``member_error``.

        :rtype: bool
        """
        return self._tag == 'member_error'

    def is_insufficient_plan(self):
        """
        Check if the union tag is ``insufficient_plan``.

        :rtype: bool
        """
        return self._tag == 'insufficient_plan'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def get_member_error(self):
        """
        Only call this if :meth:`is_member_error` is true.

        :rtype: SharedFolderMemberError
        """
        if not self.is_member_error():
            raise AttributeError("tag 'member_error' not set")
        return self._value

    def __repr__(self):
        return 'UpdateFolderMemberError(%r, %r)' % (self._tag, self._value)

class MountFolderArg(object):
    """
    :ivar shared_folder_id: The ID of the shared folder to mount.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID of the shared folder to mount.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'MountFolderArg(shared_folder_id={!r})'.format(
            self._shared_folder_id_value,
        )

class MountFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar inside_shared_folder: Mounting would cause a shared folder to be
        inside another, which is disallowed.
    :ivar insufficient_quota: The current user does not have enough space to
        mount the shared folder.
    :ivar already_mounted: The shared folder is already mounted.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    inside_shared_folder = None
    # Attribute is overwritten below the class definition
    insufficient_quota = None
    # Attribute is overwritten below the class definition
    already_mounted = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: MountFolderError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_inside_shared_folder(self):
        """
        Check if the union tag is ``inside_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'inside_shared_folder'

    def is_insufficient_quota(self):
        """
        Check if the union tag is ``insufficient_quota``.

        :rtype: bool
        """
        return self._tag == 'insufficient_quota'

    def is_already_mounted(self):
        """
        Check if the union tag is ``already_mounted``.

        :rtype: bool
        """
        return self._tag == 'already_mounted'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'MountFolderError(%r, %r)' % (self._tag, self._value)

class UnmountFolderArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'UnmountFolderArg(shared_folder_id={!r})'.format(
            self._shared_folder_id_value,
        )

class UnmountFolderError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: UnmountFolderError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'UnmountFolderError(%r, %r)' % (self._tag, self._value)

class RelinquishFolderMembershipArg(object):
    """
    :ivar shared_folder_id: The ID for the shared folder.
    """

    __slots__ = [
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_folder_id=None):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def shared_folder_id(self):
        """
        The ID for the shared folder.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            raise AttributeError("missing required field 'shared_folder_id'")

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'RelinquishFolderMembershipArg(shared_folder_id={!r})'.format(
            self._shared_folder_id_value,
        )

class RelinquishFolderMembershipError(object):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar folder_owner: The current user is the owner of the shared folder.
        Owners cannot relinquish membership to their own folders. Try unsharing
        or transfering ownership first.
    :ivar mounted: The shared folder is currently mounted.  Unmount the shared
        folder before relinquishing membership.
    :ivar group_access: The current user has access to the shared folder via a
        group.  You can't relinquish membership to folders shared via groups.
    """

    __slots__ = ['_tag', '_value']

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    folder_owner = None
    # Attribute is overwritten below the class definition
    mounted = None
    # Attribute is overwritten below the class definition
    group_access = None
    # Attribute is overwritten below the class definition
    other = None

    def __init__(self, tag, value=None):
        assert tag in self._tagmap, 'Invalid tag %r.' % tag
        validator = self._tagmap[tag]
        if isinstance(validator, bv.Void):
            assert value is None, 'Void type union member must have None value.'
        elif isinstance(validator, (bv.Struct, bv.Union)):
            validator.validate_type_only(value)
        else:
            validator.validate(value)
        self._tag = tag
        self._value = value

    @classmethod
    def access_error(cls, val):
        """
        Create an instance of this class set to the ``access_error`` tag with
        value ``val``.

        :param SharedFolderAccessError val:
        :rtype: RelinquishFolderMembershipError
        """
        return cls('access_error', val)

    def is_access_error(self):
        """
        Check if the union tag is ``access_error``.

        :rtype: bool
        """
        return self._tag == 'access_error'

    def is_folder_owner(self):
        """
        Check if the union tag is ``folder_owner``.

        :rtype: bool
        """
        return self._tag == 'folder_owner'

    def is_mounted(self):
        """
        Check if the union tag is ``mounted``.

        :rtype: bool
        """
        return self._tag == 'mounted'

    def is_group_access(self):
        """
        Check if the union tag is ``group_access``.

        :rtype: bool
        """
        return self._tag == 'group_access'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_access_error(self):
        """
        Only call this if :meth:`is_access_error` is true.

        :rtype: SharedFolderAccessError
        """
        if not self.is_access_error():
            raise AttributeError("tag 'access_error' not set")
        return self._value

    def __repr__(self):
        return 'RelinquishFolderMembershipError(%r, %r)' % (self._tag, self._value)

Visibility._public_validator = bv.Void()
Visibility._team_only_validator = bv.Void()
Visibility._password_validator = bv.Void()
Visibility._team_and_password_validator = bv.Void()
Visibility._shared_folder_only_validator = bv.Void()
Visibility._other_validator = bv.Void()
Visibility._tagmap = {
    'public': Visibility._public_validator,
    'team_only': Visibility._team_only_validator,
    'password': Visibility._password_validator,
    'team_and_password': Visibility._team_and_password_validator,
    'shared_folder_only': Visibility._shared_folder_only_validator,
    'other': Visibility._other_validator,
}

Visibility.public = Visibility('public')
Visibility.team_only = Visibility('team_only')
Visibility.password = Visibility('password')
Visibility.team_and_password = Visibility('team_and_password')
Visibility.shared_folder_only = Visibility('shared_folder_only')
Visibility.other = Visibility('other')

LinkMetadata._url_validator = bv.String()
LinkMetadata._visibility_validator = bv.Union(Visibility)
LinkMetadata._expires_validator = bv.Nullable(bv.Timestamp(u'%Y-%m-%dT%H:%M:%SZ'))
LinkMetadata._field_names_ = set([
    'url',
    'visibility',
    'expires',
])
LinkMetadata._all_field_names_ = LinkMetadata._field_names_
LinkMetadata._fields_ = [
    ('url', LinkMetadata._url_validator),
    ('visibility', LinkMetadata._visibility_validator),
    ('expires', LinkMetadata._expires_validator),
]
LinkMetadata._all_fields_ = LinkMetadata._fields_

LinkMetadata._tag_to_subtype_ = {
    (u'path',): bv.Struct(PathLinkMetadata),
    (u'collection',): bv.Struct(CollectionLinkMetadata),
}
LinkMetadata._pytype_to_tag_and_subtype_ = {
    PathLinkMetadata: ((u'path',), bv.Struct(PathLinkMetadata)),
    CollectionLinkMetadata: ((u'collection',), bv.Struct(CollectionLinkMetadata)),
}
LinkMetadata._is_catch_all_ = True

PathLinkMetadata._path_validator = bv.String()
PathLinkMetadata._field_names_ = set(['path'])
PathLinkMetadata._all_field_names_ = LinkMetadata._all_field_names_.union(PathLinkMetadata._field_names_)
PathLinkMetadata._fields_ = [('path', PathLinkMetadata._path_validator)]
PathLinkMetadata._all_fields_ = LinkMetadata._all_fields_ + PathLinkMetadata._fields_

CollectionLinkMetadata._field_names_ = set([])
CollectionLinkMetadata._all_field_names_ = LinkMetadata._all_field_names_.union(CollectionLinkMetadata._field_names_)
CollectionLinkMetadata._fields_ = []
CollectionLinkMetadata._all_fields_ = LinkMetadata._all_fields_ + CollectionLinkMetadata._fields_

GetSharedLinksArg._path_validator = bv.Nullable(bv.String())
GetSharedLinksArg._all_field_names_ = set(['path'])
GetSharedLinksArg._all_fields_ = [('path', GetSharedLinksArg._path_validator)]

GetSharedLinksResult._links_validator = bv.List(bv.StructTree(LinkMetadata))
GetSharedLinksResult._all_field_names_ = set(['links'])
GetSharedLinksResult._all_fields_ = [('links', GetSharedLinksResult._links_validator)]

GetSharedLinksError._path_validator = bv.Nullable(bv.String())
GetSharedLinksError._other_validator = bv.Void()
GetSharedLinksError._tagmap = {
    'path': GetSharedLinksError._path_validator,
    'other': GetSharedLinksError._other_validator,
}

GetSharedLinksError.other = GetSharedLinksError('other')

PendingUploadMode._file_validator = bv.Void()
PendingUploadMode._folder_validator = bv.Void()
PendingUploadMode._tagmap = {
    'file': PendingUploadMode._file_validator,
    'folder': PendingUploadMode._folder_validator,
}

PendingUploadMode.file = PendingUploadMode('file')
PendingUploadMode.folder = PendingUploadMode('folder')

CreateSharedLinkArg._path_validator = bv.String()
CreateSharedLinkArg._short_url_validator = bv.Boolean()
CreateSharedLinkArg._pending_upload_validator = bv.Nullable(bv.Union(PendingUploadMode))
CreateSharedLinkArg._all_field_names_ = set([
    'path',
    'short_url',
    'pending_upload',
])
CreateSharedLinkArg._all_fields_ = [
    ('path', CreateSharedLinkArg._path_validator),
    ('short_url', CreateSharedLinkArg._short_url_validator),
    ('pending_upload', CreateSharedLinkArg._pending_upload_validator),
]

CreateSharedLinkError._path_validator = bv.Union(files.LookupError)
CreateSharedLinkError._other_validator = bv.Void()
CreateSharedLinkError._tagmap = {
    'path': CreateSharedLinkError._path_validator,
    'other': CreateSharedLinkError._other_validator,
}

CreateSharedLinkError.other = CreateSharedLinkError('other')

RevokeSharedLinkArg._url_validator = bv.String()
RevokeSharedLinkArg._all_field_names_ = set(['url'])
RevokeSharedLinkArg._all_fields_ = [('url', RevokeSharedLinkArg._url_validator)]

RevokeSharedLinkError._shared_link_malformed_validator = bv.Void()
RevokeSharedLinkError._shared_link_not_found_validator = bv.Void()
RevokeSharedLinkError._shared_link_access_denied_validator = bv.Void()
RevokeSharedLinkError._other_validator = bv.Void()
RevokeSharedLinkError._tagmap = {
    'shared_link_malformed': RevokeSharedLinkError._shared_link_malformed_validator,
    'shared_link_not_found': RevokeSharedLinkError._shared_link_not_found_validator,
    'shared_link_access_denied': RevokeSharedLinkError._shared_link_access_denied_validator,
    'other': RevokeSharedLinkError._other_validator,
}

RevokeSharedLinkError.shared_link_malformed = RevokeSharedLinkError('shared_link_malformed')
RevokeSharedLinkError.shared_link_not_found = RevokeSharedLinkError('shared_link_not_found')
RevokeSharedLinkError.shared_link_access_denied = RevokeSharedLinkError('shared_link_access_denied')
RevokeSharedLinkError.other = RevokeSharedLinkError('other')

AccessLevel._owner_validator = bv.Void()
AccessLevel._editor_validator = bv.Void()
AccessLevel._viewer_validator = bv.Void()
AccessLevel._other_validator = bv.Void()
AccessLevel._tagmap = {
    'owner': AccessLevel._owner_validator,
    'editor': AccessLevel._editor_validator,
    'viewer': AccessLevel._viewer_validator,
    'other': AccessLevel._other_validator,
}

AccessLevel.owner = AccessLevel('owner')
AccessLevel.editor = AccessLevel('editor')
AccessLevel.viewer = AccessLevel('viewer')
AccessLevel.other = AccessLevel('other')

FolderPolicy._member_policy_validator = bv.Nullable(bv.Union(MemberPolicy))
FolderPolicy._acl_update_policy_validator = bv.Union(AclUpdatePolicy)
FolderPolicy._shared_link_policy_validator = bv.Union(SharedLinkPolicy)
FolderPolicy._all_field_names_ = set([
    'member_policy',
    'acl_update_policy',
    'shared_link_policy',
])
FolderPolicy._all_fields_ = [
    ('member_policy', FolderPolicy._member_policy_validator),
    ('acl_update_policy', FolderPolicy._acl_update_policy_validator),
    ('shared_link_policy', FolderPolicy._shared_link_policy_validator),
]

MemberPolicy._team_validator = bv.Void()
MemberPolicy._anyone_validator = bv.Void()
MemberPolicy._other_validator = bv.Void()
MemberPolicy._tagmap = {
    'team': MemberPolicy._team_validator,
    'anyone': MemberPolicy._anyone_validator,
    'other': MemberPolicy._other_validator,
}

MemberPolicy.team = MemberPolicy('team')
MemberPolicy.anyone = MemberPolicy('anyone')
MemberPolicy.other = MemberPolicy('other')

AclUpdatePolicy._owner_validator = bv.Void()
AclUpdatePolicy._editors_validator = bv.Void()
AclUpdatePolicy._other_validator = bv.Void()
AclUpdatePolicy._tagmap = {
    'owner': AclUpdatePolicy._owner_validator,
    'editors': AclUpdatePolicy._editors_validator,
    'other': AclUpdatePolicy._other_validator,
}

AclUpdatePolicy.owner = AclUpdatePolicy('owner')
AclUpdatePolicy.editors = AclUpdatePolicy('editors')
AclUpdatePolicy.other = AclUpdatePolicy('other')

SharedLinkPolicy._anyone_validator = bv.Void()
SharedLinkPolicy._members_validator = bv.Void()
SharedLinkPolicy._other_validator = bv.Void()
SharedLinkPolicy._tagmap = {
    'anyone': SharedLinkPolicy._anyone_validator,
    'members': SharedLinkPolicy._members_validator,
    'other': SharedLinkPolicy._other_validator,
}

SharedLinkPolicy.anyone = SharedLinkPolicy('anyone')
SharedLinkPolicy.members = SharedLinkPolicy('members')
SharedLinkPolicy.other = SharedLinkPolicy('other')

MembershipInfo._access_type_validator = bv.Union(AccessLevel)
MembershipInfo._all_field_names_ = set(['access_type'])
MembershipInfo._all_fields_ = [('access_type', MembershipInfo._access_type_validator)]

UserInfo._account_id_validator = bv.String(min_length=40, max_length=40)
UserInfo._same_team_validator = bv.Boolean()
UserInfo._team_member_id_validator = bv.Nullable(bv.String())
UserInfo._all_field_names_ = set([
    'account_id',
    'same_team',
    'team_member_id',
])
UserInfo._all_fields_ = [
    ('account_id', UserInfo._account_id_validator),
    ('same_team', UserInfo._same_team_validator),
    ('team_member_id', UserInfo._team_member_id_validator),
]

UserMembershipInfo._user_validator = bv.Struct(UserInfo)
UserMembershipInfo._all_field_names_ = MembershipInfo._all_field_names_.union(set(['user']))
UserMembershipInfo._all_fields_ = MembershipInfo._all_fields_ + [('user', UserMembershipInfo._user_validator)]

InviteeInfo._email_validator = bv.String(pattern=u"^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$")
InviteeInfo._other_validator = bv.Void()
InviteeInfo._tagmap = {
    'email': InviteeInfo._email_validator,
    'other': InviteeInfo._other_validator,
}

InviteeInfo.other = InviteeInfo('other')

InviteeMembershipInfo._invitee_validator = bv.Union(InviteeInfo)
InviteeMembershipInfo._all_field_names_ = MembershipInfo._all_field_names_.union(set(['invitee']))
InviteeMembershipInfo._all_fields_ = MembershipInfo._all_fields_ + [('invitee', InviteeMembershipInfo._invitee_validator)]

GroupInfo._same_team_validator = bv.Boolean()
GroupInfo._all_field_names_ = team.GroupSummary._all_field_names_.union(set(['same_team']))
GroupInfo._all_fields_ = team.GroupSummary._all_fields_ + [('same_team', GroupInfo._same_team_validator)]

GroupMembershipInfo._group_validator = bv.Struct(GroupInfo)
GroupMembershipInfo._all_field_names_ = MembershipInfo._all_field_names_.union(set(['group']))
GroupMembershipInfo._all_fields_ = MembershipInfo._all_fields_ + [('group', GroupMembershipInfo._group_validator)]

SharedFolderMetadata._path_lower_validator = bv.Nullable(bv.String())
SharedFolderMetadata._name_validator = bv.String()
SharedFolderMetadata._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
SharedFolderMetadata._access_type_validator = bv.Union(AccessLevel)
SharedFolderMetadata._is_team_folder_validator = bv.Boolean()
SharedFolderMetadata._policy_validator = bv.Struct(FolderPolicy)
SharedFolderMetadata._all_field_names_ = set([
    'path_lower',
    'name',
    'shared_folder_id',
    'access_type',
    'is_team_folder',
    'policy',
])
SharedFolderMetadata._all_fields_ = [
    ('path_lower', SharedFolderMetadata._path_lower_validator),
    ('name', SharedFolderMetadata._name_validator),
    ('shared_folder_id', SharedFolderMetadata._shared_folder_id_validator),
    ('access_type', SharedFolderMetadata._access_type_validator),
    ('is_team_folder', SharedFolderMetadata._is_team_folder_validator),
    ('policy', SharedFolderMetadata._policy_validator),
]

SharedFolderAccessError._invalid_id_validator = bv.Void()
SharedFolderAccessError._not_a_member_validator = bv.Void()
SharedFolderAccessError._no_permission_validator = bv.Void()
SharedFolderAccessError._email_unverified_validator = bv.Void()
SharedFolderAccessError._team_folder_validator = bv.Void()
SharedFolderAccessError._unmounted_validator = bv.Void()
SharedFolderAccessError._other_validator = bv.Void()
SharedFolderAccessError._tagmap = {
    'invalid_id': SharedFolderAccessError._invalid_id_validator,
    'not_a_member': SharedFolderAccessError._not_a_member_validator,
    'no_permission': SharedFolderAccessError._no_permission_validator,
    'email_unverified': SharedFolderAccessError._email_unverified_validator,
    'team_folder': SharedFolderAccessError._team_folder_validator,
    'unmounted': SharedFolderAccessError._unmounted_validator,
    'other': SharedFolderAccessError._other_validator,
}

SharedFolderAccessError.invalid_id = SharedFolderAccessError('invalid_id')
SharedFolderAccessError.not_a_member = SharedFolderAccessError('not_a_member')
SharedFolderAccessError.no_permission = SharedFolderAccessError('no_permission')
SharedFolderAccessError.email_unverified = SharedFolderAccessError('email_unverified')
SharedFolderAccessError.team_folder = SharedFolderAccessError('team_folder')
SharedFolderAccessError.unmounted = SharedFolderAccessError('unmounted')
SharedFolderAccessError.other = SharedFolderAccessError('other')

ListFoldersResult._entries_validator = bv.List(bv.Struct(SharedFolderMetadata))
ListFoldersResult._cursor_validator = bv.Nullable(bv.String())
ListFoldersResult._all_field_names_ = set([
    'entries',
    'cursor',
])
ListFoldersResult._all_fields_ = [
    ('entries', ListFoldersResult._entries_validator),
    ('cursor', ListFoldersResult._cursor_validator),
]

ListFoldersContinueArg._cursor_validator = bv.String()
ListFoldersContinueArg._all_field_names_ = set(['cursor'])
ListFoldersContinueArg._all_fields_ = [('cursor', ListFoldersContinueArg._cursor_validator)]

ListFoldersContinueError._invalid_cursor_validator = bv.Void()
ListFoldersContinueError._other_validator = bv.Void()
ListFoldersContinueError._tagmap = {
    'invalid_cursor': ListFoldersContinueError._invalid_cursor_validator,
    'other': ListFoldersContinueError._other_validator,
}

ListFoldersContinueError.invalid_cursor = ListFoldersContinueError('invalid_cursor')
ListFoldersContinueError.other = ListFoldersContinueError('other')

GetMetadataArgs._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
GetMetadataArgs._all_field_names_ = set(['shared_folder_id'])
GetMetadataArgs._all_fields_ = [('shared_folder_id', GetMetadataArgs._shared_folder_id_validator)]

ListFolderMembersArgs._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
ListFolderMembersArgs._all_field_names_ = set(['shared_folder_id'])
ListFolderMembersArgs._all_fields_ = [('shared_folder_id', ListFolderMembersArgs._shared_folder_id_validator)]

SharedFolderMembers._users_validator = bv.List(bv.Struct(UserMembershipInfo))
SharedFolderMembers._groups_validator = bv.List(bv.Struct(GroupMembershipInfo))
SharedFolderMembers._invitees_validator = bv.List(bv.Struct(InviteeMembershipInfo))
SharedFolderMembers._cursor_validator = bv.Nullable(bv.String())
SharedFolderMembers._all_field_names_ = set([
    'users',
    'groups',
    'invitees',
    'cursor',
])
SharedFolderMembers._all_fields_ = [
    ('users', SharedFolderMembers._users_validator),
    ('groups', SharedFolderMembers._groups_validator),
    ('invitees', SharedFolderMembers._invitees_validator),
    ('cursor', SharedFolderMembers._cursor_validator),
]

ListFolderMembersContinueArg._cursor_validator = bv.String()
ListFolderMembersContinueArg._all_field_names_ = set(['cursor'])
ListFolderMembersContinueArg._all_fields_ = [('cursor', ListFolderMembersContinueArg._cursor_validator)]

ListFolderMembersContinueError._access_error_validator = bv.Union(SharedFolderAccessError)
ListFolderMembersContinueError._invalid_cursor_validator = bv.Void()
ListFolderMembersContinueError._other_validator = bv.Void()
ListFolderMembersContinueError._tagmap = {
    'access_error': ListFolderMembersContinueError._access_error_validator,
    'invalid_cursor': ListFolderMembersContinueError._invalid_cursor_validator,
    'other': ListFolderMembersContinueError._other_validator,
}

ListFolderMembersContinueError.invalid_cursor = ListFolderMembersContinueError('invalid_cursor')
ListFolderMembersContinueError.other = ListFolderMembersContinueError('other')

ShareFolderArg._path_validator = bv.String(pattern=u'/.*')
ShareFolderArg._member_policy_validator = bv.Union(MemberPolicy)
ShareFolderArg._acl_update_policy_validator = bv.Union(AclUpdatePolicy)
ShareFolderArg._shared_link_policy_validator = bv.Union(SharedLinkPolicy)
ShareFolderArg._force_async_validator = bv.Boolean()
ShareFolderArg._all_field_names_ = set([
    'path',
    'member_policy',
    'acl_update_policy',
    'shared_link_policy',
    'force_async',
])
ShareFolderArg._all_fields_ = [
    ('path', ShareFolderArg._path_validator),
    ('member_policy', ShareFolderArg._member_policy_validator),
    ('acl_update_policy', ShareFolderArg._acl_update_policy_validator),
    ('shared_link_policy', ShareFolderArg._shared_link_policy_validator),
    ('force_async', ShareFolderArg._force_async_validator),
]

ShareFolderError._email_unverified_validator = bv.Void()
ShareFolderError._bad_path_validator = bv.Union(SharePathError)
ShareFolderError._team_policy_disallows_member_policy_validator = bv.Void()
ShareFolderError._other_validator = bv.Void()
ShareFolderError._tagmap = {
    'email_unverified': ShareFolderError._email_unverified_validator,
    'bad_path': ShareFolderError._bad_path_validator,
    'team_policy_disallows_member_policy': ShareFolderError._team_policy_disallows_member_policy_validator,
    'other': ShareFolderError._other_validator,
}

ShareFolderError.email_unverified = ShareFolderError('email_unverified')
ShareFolderError.team_policy_disallows_member_policy = ShareFolderError('team_policy_disallows_member_policy')
ShareFolderError.other = ShareFolderError('other')

SharePathError._is_file_validator = bv.Void()
SharePathError._inside_shared_folder_validator = bv.Void()
SharePathError._contains_shared_folder_validator = bv.Void()
SharePathError._is_app_folder_validator = bv.Void()
SharePathError._inside_app_folder_validator = bv.Void()
SharePathError._already_shared_validator = bv.Void()
SharePathError._invalid_path_validator = bv.Void()
SharePathError._other_validator = bv.Void()
SharePathError._tagmap = {
    'is_file': SharePathError._is_file_validator,
    'inside_shared_folder': SharePathError._inside_shared_folder_validator,
    'contains_shared_folder': SharePathError._contains_shared_folder_validator,
    'is_app_folder': SharePathError._is_app_folder_validator,
    'inside_app_folder': SharePathError._inside_app_folder_validator,
    'already_shared': SharePathError._already_shared_validator,
    'invalid_path': SharePathError._invalid_path_validator,
    'other': SharePathError._other_validator,
}

SharePathError.is_file = SharePathError('is_file')
SharePathError.inside_shared_folder = SharePathError('inside_shared_folder')
SharePathError.contains_shared_folder = SharePathError('contains_shared_folder')
SharePathError.is_app_folder = SharePathError('is_app_folder')
SharePathError.inside_app_folder = SharePathError('inside_app_folder')
SharePathError.already_shared = SharePathError('already_shared')
SharePathError.invalid_path = SharePathError('invalid_path')
SharePathError.other = SharePathError('other')

ShareFolderJobStatus._complete_validator = bv.Struct(SharedFolderMetadata)
ShareFolderJobStatus._failed_validator = bv.Union(ShareFolderError)
ShareFolderJobStatus._tagmap = {
    'complete': ShareFolderJobStatus._complete_validator,
    'failed': ShareFolderJobStatus._failed_validator,
}
ShareFolderJobStatus._tagmap.update(async.PollResultBase._tagmap)

ShareFolderLaunch._complete_validator = bv.Struct(SharedFolderMetadata)
ShareFolderLaunch._tagmap = {
    'complete': ShareFolderLaunch._complete_validator,
}
ShareFolderLaunch._tagmap.update(async.LaunchResultBase._tagmap)

JobStatus._complete_validator = bv.Void()
JobStatus._failed_validator = bv.Union(JobError)
JobStatus._tagmap = {
    'complete': JobStatus._complete_validator,
    'failed': JobStatus._failed_validator,
}
JobStatus._tagmap.update(async.PollResultBase._tagmap)

JobStatus.complete = JobStatus('complete')

SharedFolderMemberError._invalid_dropbox_id_validator = bv.Void()
SharedFolderMemberError._not_a_member_validator = bv.Void()
SharedFolderMemberError._other_validator = bv.Void()
SharedFolderMemberError._tagmap = {
    'invalid_dropbox_id': SharedFolderMemberError._invalid_dropbox_id_validator,
    'not_a_member': SharedFolderMemberError._not_a_member_validator,
    'other': SharedFolderMemberError._other_validator,
}

SharedFolderMemberError.invalid_dropbox_id = SharedFolderMemberError('invalid_dropbox_id')
SharedFolderMemberError.not_a_member = SharedFolderMemberError('not_a_member')
SharedFolderMemberError.other = SharedFolderMemberError('other')

JobError._access_error_validator = bv.Union(SharedFolderAccessError)
JobError._member_error_validator = bv.Union(SharedFolderMemberError)
JobError._other_validator = bv.Void()
JobError._tagmap = {
    'access_error': JobError._access_error_validator,
    'member_error': JobError._member_error_validator,
    'other': JobError._other_validator,
}

JobError.other = JobError('other')

UnshareFolderArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
UnshareFolderArg._leave_a_copy_validator = bv.Boolean()
UnshareFolderArg._all_field_names_ = set([
    'shared_folder_id',
    'leave_a_copy',
])
UnshareFolderArg._all_fields_ = [
    ('shared_folder_id', UnshareFolderArg._shared_folder_id_validator),
    ('leave_a_copy', UnshareFolderArg._leave_a_copy_validator),
]

UnshareFolderError._access_error_validator = bv.Union(SharedFolderAccessError)
UnshareFolderError._other_validator = bv.Void()
UnshareFolderError._tagmap = {
    'access_error': UnshareFolderError._access_error_validator,
    'other': UnshareFolderError._other_validator,
}

UnshareFolderError.other = UnshareFolderError('other')

TransferFolderArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
TransferFolderArg._to_dropbox_id_validator = bv.String(min_length=1)
TransferFolderArg._all_field_names_ = set([
    'shared_folder_id',
    'to_dropbox_id',
])
TransferFolderArg._all_fields_ = [
    ('shared_folder_id', TransferFolderArg._shared_folder_id_validator),
    ('to_dropbox_id', TransferFolderArg._to_dropbox_id_validator),
]

TransferFolderError._access_error_validator = bv.Union(SharedFolderAccessError)
TransferFolderError._no_permission_validator = bv.Void()
TransferFolderError._invalid_dropbox_id_validator = bv.Void()
TransferFolderError._new_owner_not_a_member_validator = bv.Void()
TransferFolderError._new_owner_unmounted_validator = bv.Void()
TransferFolderError._new_owner_email_unverified_validator = bv.Void()
TransferFolderError._other_validator = bv.Void()
TransferFolderError._tagmap = {
    'access_error': TransferFolderError._access_error_validator,
    'no_permission': TransferFolderError._no_permission_validator,
    'invalid_dropbox_id': TransferFolderError._invalid_dropbox_id_validator,
    'new_owner_not_a_member': TransferFolderError._new_owner_not_a_member_validator,
    'new_owner_unmounted': TransferFolderError._new_owner_unmounted_validator,
    'new_owner_email_unverified': TransferFolderError._new_owner_email_unverified_validator,
    'other': TransferFolderError._other_validator,
}

TransferFolderError.no_permission = TransferFolderError('no_permission')
TransferFolderError.invalid_dropbox_id = TransferFolderError('invalid_dropbox_id')
TransferFolderError.new_owner_not_a_member = TransferFolderError('new_owner_not_a_member')
TransferFolderError.new_owner_unmounted = TransferFolderError('new_owner_unmounted')
TransferFolderError.new_owner_email_unverified = TransferFolderError('new_owner_email_unverified')
TransferFolderError.other = TransferFolderError('other')

UpdateFolderPolicyArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
UpdateFolderPolicyArg._member_policy_validator = bv.Nullable(bv.Union(MemberPolicy))
UpdateFolderPolicyArg._acl_update_policy_validator = bv.Nullable(bv.Union(AclUpdatePolicy))
UpdateFolderPolicyArg._shared_link_policy_validator = bv.Nullable(bv.Union(SharedLinkPolicy))
UpdateFolderPolicyArg._all_field_names_ = set([
    'shared_folder_id',
    'member_policy',
    'acl_update_policy',
    'shared_link_policy',
])
UpdateFolderPolicyArg._all_fields_ = [
    ('shared_folder_id', UpdateFolderPolicyArg._shared_folder_id_validator),
    ('member_policy', UpdateFolderPolicyArg._member_policy_validator),
    ('acl_update_policy', UpdateFolderPolicyArg._acl_update_policy_validator),
    ('shared_link_policy', UpdateFolderPolicyArg._shared_link_policy_validator),
]

UpdateFolderPolicyError._access_error_validator = bv.Union(SharedFolderAccessError)
UpdateFolderPolicyError._not_on_team_validator = bv.Void()
UpdateFolderPolicyError._other_validator = bv.Void()
UpdateFolderPolicyError._tagmap = {
    'access_error': UpdateFolderPolicyError._access_error_validator,
    'not_on_team': UpdateFolderPolicyError._not_on_team_validator,
    'other': UpdateFolderPolicyError._other_validator,
}

UpdateFolderPolicyError.not_on_team = UpdateFolderPolicyError('not_on_team')
UpdateFolderPolicyError.other = UpdateFolderPolicyError('other')

AddFolderMemberArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
AddFolderMemberArg._members_validator = bv.List(bv.Struct(AddMember))
AddFolderMemberArg._quiet_validator = bv.Boolean()
AddFolderMemberArg._custom_message_validator = bv.Nullable(bv.String(min_length=1))
AddFolderMemberArg._all_field_names_ = set([
    'shared_folder_id',
    'members',
    'quiet',
    'custom_message',
])
AddFolderMemberArg._all_fields_ = [
    ('shared_folder_id', AddFolderMemberArg._shared_folder_id_validator),
    ('members', AddFolderMemberArg._members_validator),
    ('quiet', AddFolderMemberArg._quiet_validator),
    ('custom_message', AddFolderMemberArg._custom_message_validator),
]

AddMember._member_validator = bv.Union(MemberSelector)
AddMember._access_level_validator = bv.Union(AccessLevel)
AddMember._all_field_names_ = set([
    'member',
    'access_level',
])
AddMember._all_fields_ = [
    ('member', AddMember._member_validator),
    ('access_level', AddMember._access_level_validator),
]

MemberSelector._dropbox_id_validator = bv.String(min_length=1)
MemberSelector._email_validator = bv.String(pattern=u"^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$")
MemberSelector._other_validator = bv.Void()
MemberSelector._tagmap = {
    'dropbox_id': MemberSelector._dropbox_id_validator,
    'email': MemberSelector._email_validator,
    'other': MemberSelector._other_validator,
}

MemberSelector.other = MemberSelector('other')

AddFolderMemberError._access_error_validator = bv.Union(SharedFolderAccessError)
AddFolderMemberError._email_unverified_validator = bv.Void()
AddFolderMemberError._bad_member_validator = bv.Union(AddMemberSelectorError)
AddFolderMemberError._no_permission_validator = bv.Void()
AddFolderMemberError._cant_share_outside_team_validator = bv.Void()
AddFolderMemberError._too_many_members_validator = bv.UInt64()
AddFolderMemberError._too_many_pending_invites_validator = bv.UInt64()
AddFolderMemberError._rate_limit_validator = bv.Void()
AddFolderMemberError._insufficient_plan_validator = bv.Void()
AddFolderMemberError._other_validator = bv.Void()
AddFolderMemberError._tagmap = {
    'access_error': AddFolderMemberError._access_error_validator,
    'email_unverified': AddFolderMemberError._email_unverified_validator,
    'bad_member': AddFolderMemberError._bad_member_validator,
    'no_permission': AddFolderMemberError._no_permission_validator,
    'cant_share_outside_team': AddFolderMemberError._cant_share_outside_team_validator,
    'too_many_members': AddFolderMemberError._too_many_members_validator,
    'too_many_pending_invites': AddFolderMemberError._too_many_pending_invites_validator,
    'rate_limit': AddFolderMemberError._rate_limit_validator,
    'insufficient_plan': AddFolderMemberError._insufficient_plan_validator,
    'other': AddFolderMemberError._other_validator,
}

AddFolderMemberError.email_unverified = AddFolderMemberError('email_unverified')
AddFolderMemberError.no_permission = AddFolderMemberError('no_permission')
AddFolderMemberError.cant_share_outside_team = AddFolderMemberError('cant_share_outside_team')
AddFolderMemberError.rate_limit = AddFolderMemberError('rate_limit')
AddFolderMemberError.insufficient_plan = AddFolderMemberError('insufficient_plan')
AddFolderMemberError.other = AddFolderMemberError('other')

AddMemberSelectorError._invalid_dropbox_id_validator = bv.String(min_length=1)
AddMemberSelectorError._invalid_email_validator = bv.String(pattern=u"^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$")
AddMemberSelectorError._unverified_dropbox_id_validator = bv.String(min_length=1)
AddMemberSelectorError._group_deleted_validator = bv.Void()
AddMemberSelectorError._group_not_on_team_validator = bv.Void()
AddMemberSelectorError._other_validator = bv.Void()
AddMemberSelectorError._tagmap = {
    'invalid_dropbox_id': AddMemberSelectorError._invalid_dropbox_id_validator,
    'invalid_email': AddMemberSelectorError._invalid_email_validator,
    'unverified_dropbox_id': AddMemberSelectorError._unverified_dropbox_id_validator,
    'group_deleted': AddMemberSelectorError._group_deleted_validator,
    'group_not_on_team': AddMemberSelectorError._group_not_on_team_validator,
    'other': AddMemberSelectorError._other_validator,
}

AddMemberSelectorError.group_deleted = AddMemberSelectorError('group_deleted')
AddMemberSelectorError.group_not_on_team = AddMemberSelectorError('group_not_on_team')
AddMemberSelectorError.other = AddMemberSelectorError('other')

RemoveFolderMemberArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
RemoveFolderMemberArg._member_validator = bv.Union(MemberSelector)
RemoveFolderMemberArg._leave_a_copy_validator = bv.Boolean()
RemoveFolderMemberArg._all_field_names_ = set([
    'shared_folder_id',
    'member',
    'leave_a_copy',
])
RemoveFolderMemberArg._all_fields_ = [
    ('shared_folder_id', RemoveFolderMemberArg._shared_folder_id_validator),
    ('member', RemoveFolderMemberArg._member_validator),
    ('leave_a_copy', RemoveFolderMemberArg._leave_a_copy_validator),
]

RemoveFolderMemberError._access_error_validator = bv.Union(SharedFolderAccessError)
RemoveFolderMemberError._other_validator = bv.Void()
RemoveFolderMemberError._tagmap = {
    'access_error': RemoveFolderMemberError._access_error_validator,
    'other': RemoveFolderMemberError._other_validator,
}

RemoveFolderMemberError.other = RemoveFolderMemberError('other')

UpdateFolderMemberArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
UpdateFolderMemberArg._member_validator = bv.Union(MemberSelector)
UpdateFolderMemberArg._access_level_validator = bv.Union(AccessLevel)
UpdateFolderMemberArg._all_field_names_ = set([
    'shared_folder_id',
    'member',
    'access_level',
])
UpdateFolderMemberArg._all_fields_ = [
    ('shared_folder_id', UpdateFolderMemberArg._shared_folder_id_validator),
    ('member', UpdateFolderMemberArg._member_validator),
    ('access_level', UpdateFolderMemberArg._access_level_validator),
]

UpdateFolderMemberError._access_error_validator = bv.Union(SharedFolderAccessError)
UpdateFolderMemberError._member_error_validator = bv.Union(SharedFolderMemberError)
UpdateFolderMemberError._insufficient_plan_validator = bv.Void()
UpdateFolderMemberError._other_validator = bv.Void()
UpdateFolderMemberError._tagmap = {
    'access_error': UpdateFolderMemberError._access_error_validator,
    'member_error': UpdateFolderMemberError._member_error_validator,
    'insufficient_plan': UpdateFolderMemberError._insufficient_plan_validator,
    'other': UpdateFolderMemberError._other_validator,
}

UpdateFolderMemberError.insufficient_plan = UpdateFolderMemberError('insufficient_plan')
UpdateFolderMemberError.other = UpdateFolderMemberError('other')

MountFolderArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
MountFolderArg._all_field_names_ = set(['shared_folder_id'])
MountFolderArg._all_fields_ = [('shared_folder_id', MountFolderArg._shared_folder_id_validator)]

MountFolderError._access_error_validator = bv.Union(SharedFolderAccessError)
MountFolderError._inside_shared_folder_validator = bv.Void()
MountFolderError._insufficient_quota_validator = bv.Void()
MountFolderError._already_mounted_validator = bv.Void()
MountFolderError._other_validator = bv.Void()
MountFolderError._tagmap = {
    'access_error': MountFolderError._access_error_validator,
    'inside_shared_folder': MountFolderError._inside_shared_folder_validator,
    'insufficient_quota': MountFolderError._insufficient_quota_validator,
    'already_mounted': MountFolderError._already_mounted_validator,
    'other': MountFolderError._other_validator,
}

MountFolderError.inside_shared_folder = MountFolderError('inside_shared_folder')
MountFolderError.insufficient_quota = MountFolderError('insufficient_quota')
MountFolderError.already_mounted = MountFolderError('already_mounted')
MountFolderError.other = MountFolderError('other')

UnmountFolderArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
UnmountFolderArg._all_field_names_ = set(['shared_folder_id'])
UnmountFolderArg._all_fields_ = [('shared_folder_id', UnmountFolderArg._shared_folder_id_validator)]

UnmountFolderError._access_error_validator = bv.Union(SharedFolderAccessError)
UnmountFolderError._other_validator = bv.Void()
UnmountFolderError._tagmap = {
    'access_error': UnmountFolderError._access_error_validator,
    'other': UnmountFolderError._other_validator,
}

UnmountFolderError.other = UnmountFolderError('other')

RelinquishFolderMembershipArg._shared_folder_id_validator = bv.String(pattern=u'[-_0-9a-zA-Z:]+')
RelinquishFolderMembershipArg._all_field_names_ = set(['shared_folder_id'])
RelinquishFolderMembershipArg._all_fields_ = [('shared_folder_id', RelinquishFolderMembershipArg._shared_folder_id_validator)]

RelinquishFolderMembershipError._access_error_validator = bv.Union(SharedFolderAccessError)
RelinquishFolderMembershipError._folder_owner_validator = bv.Void()
RelinquishFolderMembershipError._mounted_validator = bv.Void()
RelinquishFolderMembershipError._group_access_validator = bv.Void()
RelinquishFolderMembershipError._other_validator = bv.Void()
RelinquishFolderMembershipError._tagmap = {
    'access_error': RelinquishFolderMembershipError._access_error_validator,
    'folder_owner': RelinquishFolderMembershipError._folder_owner_validator,
    'mounted': RelinquishFolderMembershipError._mounted_validator,
    'group_access': RelinquishFolderMembershipError._group_access_validator,
    'other': RelinquishFolderMembershipError._other_validator,
}

RelinquishFolderMembershipError.folder_owner = RelinquishFolderMembershipError('folder_owner')
RelinquishFolderMembershipError.mounted = RelinquishFolderMembershipError('mounted')
RelinquishFolderMembershipError.group_access = RelinquishFolderMembershipError('group_access')
RelinquishFolderMembershipError.other = RelinquishFolderMembershipError('other')

