/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.Layoutable;
import CH.ifa.draw.contrib.Layouter;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class StandardLayouter
implements Layouter {
    private Layoutable myLayoutable;
    private Insets myInsets;
    static final long serialVersionUID = 2928651014089117493L;

    public StandardLayouter() {
    }

    public StandardLayouter(Layoutable newLayoutable) {
        this.setInsets(new Insets(0, 0, 0, 0));
        this.setLayoutable(newLayoutable);
    }

    public Layoutable getLayoutable() {
        return this.myLayoutable;
    }

    public void setLayoutable(Layoutable newLayoutable) {
        this.myLayoutable = newLayoutable;
    }

    public Rectangle calculateLayout(Point origin, Point corner) {
        int maxWidth = Math.abs(corner.x - origin.x);
        int maxHeight = 0;
        FigureEnumeration figureEnumeration = this.getLayoutable().figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure currentFigure = figureEnumeration.nextFigure();
            Rectangle r = null;
            if (currentFigure instanceof Layoutable) {
                Layouter layoutStrategy = ((Layoutable)currentFigure).getLayouter();
                r = layoutStrategy.calculateLayout(new Point(0, 0), new Point(0, 0));
                r.grow(layoutStrategy.getInsets().left + layoutStrategy.getInsets().right, layoutStrategy.getInsets().top + layoutStrategy.getInsets().bottom);
            } else {
                r = new Rectangle(currentFigure.displayBox().getBounds());
            }
            maxWidth = Math.max(maxWidth, r.width);
            maxHeight += r.height;
        }
        return new Rectangle(origin.x, origin.y, maxWidth, maxHeight);
    }

    public Rectangle layout(Point origin, Point corner) {
        Rectangle r = this.calculateLayout(origin, corner);
        int maxHeight = this.getInsets().top;
        FigureEnumeration figureEnumeration = this.getLayoutable().figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure currentFigure = figureEnumeration.nextFigure();
            Point partOrigin = new Point(r.x + this.getInsets().left, r.y + maxHeight);
            Point partCorner = new Point(r.x + this.getInsets().left + r.width, r.y + currentFigure.displayBox().height);
            currentFigure.displayBox(partOrigin, partCorner);
            maxHeight += currentFigure.displayBox().height;
        }
        return new Rectangle(r.x, r.y, r.x + r.width, r.y + maxHeight + this.getInsets().bottom);
    }

    public void read(StorableInput dr) throws IOException {
        this.setLayoutable((Layoutable)dr.readStorable());
    }

    public void write(StorableOutput dw) {
        dw.writeStorable(this.getLayoutable());
    }

    public void setInsets(Insets newInsets) {
        this.myInsets = newInsets;
    }

    public Insets getInsets() {
        return this.myInsets;
    }
}

