/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.utils.HirshbergMatcher;

public class HirshbergMatcherUnitTest {
    private static final String EMPTY_STRING = "";
    private static final String NON_EMPTY_STRING = "Non Empty String";

    @Test(expected=NullPointerException.class)
    public void shouldFailToGetLCSIfStringAIsNull() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        hirshbergMatcher.getLCS(null, NON_EMPTY_STRING);
    }

    @Test(expected=NullPointerException.class)
    public void shouldFailToGetLCSIfStringBIsNull() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        hirshbergMatcher.getLCS(NON_EMPTY_STRING, null);
    }

    @Test
    public void shouldReturnEmptyStringWhenGettingLCSIfStringAIsEmpty() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        String string = hirshbergMatcher.getLCS(EMPTY_STRING, NON_EMPTY_STRING);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)EMPTY_STRING)));
    }

    @Test
    public void shouldReturnEmptyStringWhenGettingLCSIfStringBIsEmpty() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        String string = hirshbergMatcher.getLCS(NON_EMPTY_STRING, EMPTY_STRING);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)EMPTY_STRING)));
    }

    @Test
    public void shouldReturnEmptyStringWhenGettingLCSOfEmptyStrings() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        String string = hirshbergMatcher.getLCS(EMPTY_STRING, EMPTY_STRING);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)EMPTY_STRING)));
    }

    @Test
    public void shouldReturnLCSWhenGettingLCSOfCommonStrings() {
        String string = "GTCGTTCGGAATGCCGTTGCTCTGTAAA";
        String string2 = "ACCGGTCGAGTGCGCGGAAGCCGGCCGAA";
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        String string3 = hirshbergMatcher.getLCS(string, string2);
        Assert.assertThat((Object)string3, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"GTCGTCGGAAGCCGGCCGAA")));
    }

    @Test
    public void shouldReturnSameLCSWhenSwitchingPositionsOfCommonStrings() {
        String string = "human";
        String string2 = "chimpanzee";
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        String string3 = hirshbergMatcher.getLCS(string, string2);
        String string4 = hirshbergMatcher.getLCS(string2, string);
        Assert.assertThat((Object)string3, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string4)));
        Assert.assertThat((Object)string4, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"hman")));
    }

    @Test
    public void shouldReturnLCSEqualToStringsIfStringsAreEqual() {
        String string;
        String string2 = string = "ABC";
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        String string3 = hirshbergMatcher.getLCS(string, string2);
        Assert.assertThat((Object)string3, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string2)));
    }

    @Test
    public void shouldReturnEmptyStringWhenGettingLCSOfUncommonStrings() {
        String string = "man";
        String string2 = "pig";
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        String string3 = hirshbergMatcher.getLCS(string, string2);
        Assert.assertThat((Object)string3, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)EMPTY_STRING)));
    }

    @Test
    public void shouldReturnMinMatchRatioIfStringAIsNull() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(null, NON_EMPTY_STRING);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
    }

    @Test
    public void shouldReturnMinMatchRatioIfStringBIsNull() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(NON_EMPTY_STRING, null);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
    }

    @Test
    public void shouldReturnMaxMatchRatioIfBothStringsAreNull() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(null, null);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0)));
    }

    @Test
    public void shouldReturnMinMatchRatioIfStringAIsEmpty() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(EMPTY_STRING, NON_EMPTY_STRING);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
    }

    @Test
    public void shouldReturnMinMatchRatioIfStringBIsEmpty() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(NON_EMPTY_STRING, EMPTY_STRING);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
    }

    @Test
    public void shouldReturnMaxMatchRatioIfBothStringsAreEmpty() {
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(EMPTY_STRING, EMPTY_STRING);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0)));
    }

    @Test
    public void shouldReturnCorrectMatchRatioForCommonStrings() {
        String string = "capital";
        String string2 = "apple";
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(string, string2);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)0.4285, (double)0.001)));
    }

    @Test
    public void shouldReturnMaxMatchRatioForEqualStrings() {
        String string;
        String string2 = string = "ca";
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(string, string2);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1.0)));
    }

    @Test
    public void shouldReturnZeroMatchRatioForUncommonStrings() {
        String string = "ABC";
        String string2 = "XYZ";
        HirshbergMatcher hirshbergMatcher = new HirshbergMatcher();
        double d = hirshbergMatcher.getMatchRatio(string, string2);
        Assert.assertThat((Object)d, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0.0)));
    }
}

