/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Mustache;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.mustache.JsonEscapingMustacheFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public class MustacheScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "mustache";
    private static ThreadLocal<SoftReference<UTF8StreamWriter>> utf8StreamWriter = new ThreadLocal();

    private static UTF8StreamWriter utf8StreamWriter() {
        UTF8StreamWriter writer;
        SoftReference<UTF8StreamWriter> ref = utf8StreamWriter.get();
        UTF8StreamWriter uTF8StreamWriter = writer = ref == null ? null : ref.get();
        if (writer == null) {
            writer = new UTF8StreamWriter(4096);
            utf8StreamWriter.set(new SoftReference<UTF8StreamWriter>(writer));
        }
        writer.reset();
        return writer;
    }

    @Inject
    public MustacheScriptEngineService(Settings settings) {
        super(settings);
    }

    @Override
    public Object compile(String template) {
        return new JsonEscapingMustacheFactory().compile(new FastStringReader(template), "query-template");
    }

    @Override
    public String[] types() {
        return new String[]{NAME};
    }

    @Override
    public String[] extensions() {
        return new String[]{NAME};
    }

    @Override
    public boolean sandboxed() {
        return true;
    }

    @Override
    public ExecutableScript executable(CompiledScript compiledScript, @Nullable Map<String, Object> vars) {
        return new MustacheExecutableScript(compiledScript, vars);
    }

    @Override
    public SearchScript search(CompiledScript compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    @Override
    public void scriptRemoved(CompiledScript script) {
    }

    private class MustacheExecutableScript
    implements ExecutableScript {
        private CompiledScript template;
        private Map<String, Object> vars;

        public MustacheExecutableScript(CompiledScript template, Map<String, Object> vars) {
            this.template = template;
            this.vars = vars == null ? Collections.emptyMap() : vars;
        }

        @Override
        public void setNextVar(String name, Object value) {
            this.vars.put(name, value);
        }

        @Override
        public Object run() {
            BytesStreamOutput result = new BytesStreamOutput();
            try (UTF8StreamWriter writer = MustacheScriptEngineService.utf8StreamWriter().setOutput(result);){
                ((Mustache)this.template.compiled()).execute((Writer)writer, this.vars);
            }
            catch (Exception e) {
                MustacheScriptEngineService.this.logger.error("Error running " + this.template, e, new Object[0]);
                throw new ScriptException("Error running " + this.template, e);
            }
            return result.bytes();
        }

        @Override
        public Object unwrap(Object value) {
            return value;
        }
    }
}

