/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class NativeCallSite
extends IdScriptableObject {
    private static final String CALLSITE_TAG = "CallSite";
    private ScriptStackElement element;
    private static final int Id_constructor = 1;
    private static final int Id_getThis = 2;
    private static final int Id_getTypeName = 3;
    private static final int Id_getFunction = 4;
    private static final int Id_getFunctionName = 5;
    private static final int Id_getMethodName = 6;
    private static final int Id_getFileName = 7;
    private static final int Id_getLineNumber = 8;
    private static final int Id_getColumnNumber = 9;
    private static final int Id_getEvalOrigin = 10;
    private static final int Id_isToplevel = 11;
    private static final int Id_isEval = 12;
    private static final int Id_isNative = 13;
    private static final int Id_isConstructor = 14;
    private static final int Id_toString = 15;
    private static final int MAX_PROTOTYPE_ID = 15;

    static void init(Scriptable scriptable, boolean bl) {
        NativeCallSite nativeCallSite = new NativeCallSite();
        nativeCallSite.exportAsJSClass(15, scriptable, bl);
    }

    static NativeCallSite make(Scriptable scriptable, Scriptable scriptable2) {
        NativeCallSite nativeCallSite = new NativeCallSite();
        Scriptable scriptable3 = (Scriptable)scriptable2.get("prototype", scriptable2);
        nativeCallSite.setParentScope(scriptable);
        nativeCallSite.setPrototype(scriptable3);
        return nativeCallSite;
    }

    private NativeCallSite() {
    }

    void setElement(ScriptStackElement scriptStackElement) {
        this.element = scriptStackElement;
    }

    @Override
    public String getClassName() {
        return CALLSITE_TAG;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "getThis";
                break;
            }
            case 3: {
                n2 = 0;
                string = "getTypeName";
                break;
            }
            case 4: {
                n2 = 0;
                string = "getFunction";
                break;
            }
            case 5: {
                n2 = 0;
                string = "getFunctionName";
                break;
            }
            case 6: {
                n2 = 0;
                string = "getMethodName";
                break;
            }
            case 7: {
                n2 = 0;
                string = "getFileName";
                break;
            }
            case 8: {
                n2 = 0;
                string = "getLineNumber";
                break;
            }
            case 9: {
                n2 = 0;
                string = "getColumnNumber";
                break;
            }
            case 10: {
                n2 = 0;
                string = "getEvalOrigin";
                break;
            }
            case 11: {
                n2 = 0;
                string = "isToplevel";
                break;
            }
            case 12: {
                n2 = 0;
                string = "isEval";
                break;
            }
            case 13: {
                n2 = 0;
                string = "isNative";
                break;
            }
            case 14: {
                n2 = 0;
                string = "isConstructor";
                break;
            }
            case 15: {
                n2 = 0;
                string = "toString";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(CALLSITE_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CALLSITE_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return NativeCallSite.make(scriptable, idFunctionObject);
            }
            case 5: {
                return this.getFunctionName(scriptable2);
            }
            case 7: {
                return this.getFileName(scriptable2);
            }
            case 8: {
                return this.getLineNumber(scriptable2);
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return this.getUndefined();
            }
            case 6: {
                return this.getNull();
            }
            case 10: 
            case 12: 
            case 14: {
                return this.getFalse();
            }
            case 15: {
                return this.js_toString(scriptable2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public String toString() {
        if (this.element == null) {
            return "";
        }
        return this.element.toString();
    }

    private Object js_toString(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)scriptable;
        StringBuilder stringBuilder = new StringBuilder();
        nativeCallSite.element.renderJavaStyle(stringBuilder);
        return stringBuilder.toString();
    }

    private Object getUndefined() {
        return Undefined.instance;
    }

    private Object getNull() {
        return null;
    }

    private Object getFalse() {
        return Boolean.FALSE;
    }

    private Object getFunctionName(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)scriptable;
        return nativeCallSite.element == null ? null : nativeCallSite.element.functionName;
    }

    private Object getFileName(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)scriptable;
        return nativeCallSite.element == null ? null : nativeCallSite.element.fileName;
    }

    private Object getLineNumber(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)scriptable;
        if (nativeCallSite.element == null || nativeCallSite.element.lineNumber < 0) {
            return Undefined.instance;
        }
        return nativeCallSite.element.lineNumber;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block23: {
            n = 0;
            String string2 = null;
            block0 : switch (string.length()) {
                case 6: {
                    string2 = "isEval";
                    n = 12;
                    break;
                }
                case 7: {
                    string2 = "getThis";
                    n = 2;
                    break;
                }
                case 8: {
                    char c = string.charAt(0);
                    if (c == 'i') {
                        string2 = "isNative";
                        n = 13;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toString";
                    n = 15;
                    break;
                }
                case 10: {
                    string2 = "isToplevel";
                    n = 11;
                    break;
                }
                case 11: {
                    switch (string.charAt(4)) {
                        case 'i': {
                            string2 = "getFileName";
                            n = 7;
                            break block0;
                        }
                        case 't': {
                            string2 = "constructor";
                            n = 1;
                            break block0;
                        }
                        case 'u': {
                            string2 = "getFunction";
                            n = 4;
                            break block0;
                        }
                        case 'y': {
                            string2 = "getTypeName";
                            n = 3;
                            break block0;
                        }
                    }
                    break;
                }
                case 13: {
                    switch (string.charAt(3)) {
                        case 'E': {
                            string2 = "getEvalOrigin";
                            n = 10;
                            break block0;
                        }
                        case 'L': {
                            string2 = "getLineNumber";
                            n = 8;
                            break block0;
                        }
                        case 'M': {
                            string2 = "getMethodName";
                            n = 6;
                            break block0;
                        }
                        case 'o': {
                            string2 = "isConstructor";
                            n = 14;
                            break block0;
                        }
                    }
                    break;
                }
                case 15: {
                    char c = string.charAt(3);
                    if (c == 'C') {
                        string2 = "getColumnNumber";
                        n = 9;
                        break;
                    }
                    if (c != 'F') break;
                    string2 = "getFunctionName";
                    n = 5;
                    break;
                }
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block23;
            n = 0;
        }
        return n;
    }
}

