/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class CreateMultipolygonAction
extends JosmAction {
    private final boolean update;
    private static final List<String> DEFAULT_LINEAR_TAGS = Arrays.asList("barrier", "fence_type", "source");

    public CreateMultipolygonAction(boolean bl) {
        super(CreateMultipolygonAction.getName(bl), "multipoly_create", CreateMultipolygonAction.getName(bl), bl ? Shortcut.registerShortcut("tools:multipoly_update", I18n.tr("Tool: {0}", CreateMultipolygonAction.getName(true)), 66, 5009) : Shortcut.registerShortcut("tools:multipoly_create", I18n.tr("Tool: {0}", CreateMultipolygonAction.getName(false)), 66, 5006), true, bl ? "multipoly_update" : "multipoly_create", true);
        this.update = bl;
    }

    private static String getName(boolean bl) {
        return bl ? I18n.tr("Update multipolygon", new Object[0]) : I18n.tr("Create multipolygon", new Object[0]);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Relation relation;
        if (!Main.main.hasEditLayer()) {
            new Notification(I18n.tr("No data loaded.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Collection<Way> collection = Main.main.getCurrentDataSet().getSelectedWays();
        if (collection.isEmpty()) {
            new Notification(I18n.tr("You must select at least one way.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Collection<Relation> collection2 = Main.main.getCurrentDataSet().getSelectedRelations();
        Relation relation2 = relation = this.update ? CreateMultipolygonAction.getSelectedMultipolygonRelation(collection, collection2) : null;
        if (relation != null) {
            if (!relation.isNew() && relation.isIncomplete()) {
                Main.worker.submit(new DownloadRelationTask(Collections.singleton(relation), Main.main.getEditLayer()));
            } else if (relation.hasIncompleteMembers()) {
                Main.worker.submit(new DownloadRelationMemberTask(relation, DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(Collections.singleton(relation)), Main.main.getEditLayer()));
            }
        }
        Main.worker.submit(new CreateUpdateMultipolygonTask(collection, relation));
    }

    private static Relation getSelectedMultipolygonRelation() {
        return CreateMultipolygonAction.getSelectedMultipolygonRelation(CreateMultipolygonAction.getCurrentDataSet().getSelectedWays(), CreateMultipolygonAction.getCurrentDataSet().getSelectedRelations());
    }

    private static Relation getSelectedMultipolygonRelation(Collection<Way> collection, Collection<Relation> collection2) {
        if (collection2.size() == 1 && "multipolygon".equals(collection2.iterator().next().get("type"))) {
            return collection2.iterator().next();
        }
        HashSet hashSet = new HashSet();
        for (Way way : collection) {
            hashSet.addAll(Utils.filteredCollection(way.getReferrers(), Relation.class));
        }
        return hashSet.size() == 1 ? (Relation)hashSet.iterator().next() : null;
    }

    public static Pair<Relation, Relation> updateMultipolygonRelation(Collection<Way> collection, Relation relation) {
        HashSet<Way> hashSet = new HashSet<Way>(collection);
        hashSet.addAll(relation.getMemberPrimitives(Way.class));
        MultipolygonBuilder multipolygonBuilder = CreateMultipolygonAction.analyzeWays(hashSet, true);
        if (multipolygonBuilder == null) {
            return null;
        }
        return Pair.create(relation, CreateMultipolygonAction.createRelation(multipolygonBuilder, relation));
    }

    public static Pair<Relation, Relation> createMultipolygonRelation(Collection<Way> collection, boolean bl) {
        MultipolygonBuilder multipolygonBuilder = CreateMultipolygonAction.analyzeWays(collection, bl);
        if (multipolygonBuilder == null) {
            return null;
        }
        return Pair.create(null, CreateMultipolygonAction.createRelation(multipolygonBuilder, null));
    }

    public static Pair<SequenceCommand, Relation> createMultipolygonCommand(Collection<Way> collection, Relation relation) {
        String string;
        Pair<Relation, Relation> pair;
        Pair<Relation, Relation> pair2 = pair = relation == null ? CreateMultipolygonAction.createMultipolygonRelation(collection, true) : CreateMultipolygonAction.updateMultipolygonRelation(collection, relation);
        if (pair == null) {
            return null;
        }
        Relation relation2 = (Relation)pair.a;
        Relation relation3 = (Relation)pair.b;
        List<Command> list = CreateMultipolygonAction.removeTagsFromWaysIfNeeded(relation3);
        if (relation2 == null) {
            list.add(new AddCommand(relation3));
            string = CreateMultipolygonAction.getName(false);
        } else {
            list.add(new ChangeCommand(relation2, relation3));
            string = CreateMultipolygonAction.getName(true);
        }
        return Pair.create(new SequenceCommand(string, list), relation3);
    }

    @Override
    protected void updateEnabledState() {
        if (CreateMultipolygonAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateMultipolygonAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (CreateMultipolygonAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else if (this.update) {
            this.setEnabled(CreateMultipolygonAction.getSelectedMultipolygonRelation() != null);
        } else {
            this.setEnabled(!CreateMultipolygonAction.getCurrentDataSet().getSelectedWays().isEmpty());
        }
    }

    private static MultipolygonBuilder analyzeWays(Collection<Way> collection, boolean bl) {
        MultipolygonBuilder multipolygonBuilder = new MultipolygonBuilder();
        final String string = multipolygonBuilder.makeFromWays(collection);
        if (string != null) {
            if (bl) {
                GuiHelper.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        new Notification(string).setIcon(1).show();
                    }
                });
            }
            return null;
        }
        return multipolygonBuilder;
    }

    private static Relation createRelation(MultipolygonBuilder multipolygonBuilder, Relation relation) {
        Relation relation2 = relation != null ? new Relation(relation) : new Relation();
        relation2.put("type", "multipolygon");
        for (MultipolygonBuilder.JoinedPolygon joinedPolygon : multipolygonBuilder.outerWays) {
            CreateMultipolygonAction.addMembers(joinedPolygon, relation2, "outer");
        }
        for (MultipolygonBuilder.JoinedPolygon joinedPolygon : multipolygonBuilder.innerWays) {
            CreateMultipolygonAction.addMembers(joinedPolygon, relation2, "inner");
        }
        return relation2;
    }

    private static void addMembers(MultipolygonBuilder.JoinedPolygon joinedPolygon, Relation relation, String string) {
        int n = relation.getMembersCount();
        HashSet<Way> hashSet = new HashSet<Way>(joinedPolygon.ways);
        for (int i = 0; i < n; ++i) {
            RelationMember primitiveId = relation.getMember(i);
            if (!hashSet.contains(primitiveId.getMember()) || string.equals(primitiveId.getRole())) continue;
            relation.setMember(i, new RelationMember(string, primitiveId.getMember()));
        }
        hashSet.removeAll(relation.getMemberPrimitives());
        for (Way way : hashSet) {
            relation.addMember(new RelationMember(string, way));
        }
    }

    public static List<Command> removeTagsFromWaysIfNeeded(Relation relation) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>(relation.getKeys());
        ArrayList<Way> arrayList = new ArrayList<Way>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (RelationMember object : relation.getMembers()) {
            if (object.hasRole() && "inner".equals(object.getRole()) && object.isWay() && object.getWay().hasKeys()) {
                arrayList.add(object.getWay());
            }
            if (!object.hasRole() || !"outer".equals(object.getRole()) || !object.isWay() || !object.getWay().hasKeys()) continue;
            Iterator iterator = object.getWay();
            arrayList2.add((Way)((Object)iterator));
            for (String string2 : ((AbstractPrimitive)((Object)iterator)).keySet()) {
                if (!hashMap.containsKey(string2)) {
                    hashMap.put(string2, ((AbstractPrimitive)((Object)iterator)).get(string2));
                    continue;
                }
                if (relation.hasKey(string2) || ((String)hashMap.get(string2)).equals(((AbstractPrimitive)((Object)iterator)).get(string2))) continue;
                treeSet.add(string2);
            }
        }
        if (!Main.pref.getBoolean("multipoly.alltags", false)) {
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.hasRole() || !"outer".equals(relationMember.getRole()) || !relationMember.isWay()) continue;
                for (String string3 : hashMap.keySet()) {
                    if (relationMember.getWay().hasKey(string3) || relation.hasKey(string3)) continue;
                    treeSet.add(string3);
                }
            }
        }
        for (String string4 : treeSet) {
            hashMap.remove(string4);
        }
        for (String string5 : Main.pref.getCollection("multipoly.lineartagstokeep", DEFAULT_LINEAR_TAGS)) {
            hashMap.remove(string5);
        }
        if ("coastline".equals(hashMap.get("natural"))) {
            hashMap.remove("natural");
        }
        hashMap.put("area", "yes");
        ArrayList arrayList3 = new ArrayList();
        boolean bl = Main.pref.getBoolean("multipoly.movetags", true);
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList<Way> arrayList4 = new ArrayList<Way>();
            Map.Entry entry2 = (String)entry.getKey();
            string = (String)entry.getValue();
            for (Way way : arrayList) {
                if (!string.equals(way.get((String)((Object)entry2)))) continue;
                arrayList4.add(way);
            }
            if (bl) {
                for (Way way : arrayList2) {
                    if (!way.hasKey((String)((Object)entry2))) continue;
                    arrayList4.add(way);
                }
            }
            if (arrayList4.isEmpty()) continue;
            arrayList3.add(new ChangePropertyCommand(arrayList4, (String)((Object)entry2), null));
        }
        if (bl) {
            boolean bl2 = false;
            Relation relation2 = new Relation(relation);
            for (Map.Entry entry2 : hashMap.entrySet()) {
                string = (String)entry2.getKey();
                if (relation2.hasKey(string) || "area".equals(string)) continue;
                if (relation.isNew()) {
                    relation.put(string, (String)entry2.getValue());
                } else {
                    relation2.put(string, (String)entry2.getValue());
                }
                bl2 = true;
            }
            if (bl2 && !relation.isNew()) {
                arrayList3.add(new ChangeCommand(relation, relation2));
            }
        }
        return arrayList3;
    }

    private static final class CreateUpdateMultipolygonTask
    implements Runnable {
        private final Collection<Way> selectedWays;
        private final Relation multipolygonRelation;

        private CreateUpdateMultipolygonTask(Collection<Way> collection, Relation relation) {
            this.selectedWays = collection;
            this.multipolygonRelation = relation;
        }

        @Override
        public void run() {
            Pair<SequenceCommand, Relation> pair = CreateMultipolygonAction.createMultipolygonCommand(this.selectedWays, this.multipolygonRelation);
            if (pair == null) {
                return;
            }
            final Command command = (Command)pair.a;
            final Relation relation = (Relation)pair.b;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Main.main.undoRedo.add(command);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Main.map.relationListDialog.selectRelation(relation);
                            if (Main.pref.getBoolean("multipoly.show-relation-editor", false)) {
                                RelationEditor relationEditor = RelationEditor.getEditor(Main.main.getEditLayer(), relation, null);
                                relationEditor.setModal(true);
                                relationEditor.setVisible(true);
                            } else {
                                Main.main.getEditLayer().setRecentRelation(relation);
                            }
                        }
                    });
                }
            });
        }
    }
}

