/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.tools.I18n;

public class PublicTransportRouteTest
extends Test {
    private final WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();

    public PublicTransportRouteTest() {
        super(I18n.tr("Public Transport Route", new Object[0]));
    }

    @Override
    public void visit(Relation relation) {
        boolean bl;
        boolean bl2 = bl = relation.hasIncompleteMembers() || !relation.hasTag("type", "route") || !relation.hasKey("route") || !relation.hasTag("public_transport:version", "2");
        if (bl) {
            return;
        }
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.hasRole("forward", "backward")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Route relation contains a ''{0}'' role", "forward/backward"), 3601, relation));
                return;
            }
            if (!relationMember.hasRole("")) continue;
            arrayList.add(relationMember);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        List<WayConnectionType> list = this.connectionTypeCalculator.updateLinks(arrayList);
        for (int i = 0; i < list.size(); ++i) {
            boolean bl3;
            WayConnectionType wayConnectionType = (WayConnectionType)list.get(i);
            boolean bl4 = bl3 = i != 0 && !wayConnectionType.linkPrev || i != list.size() - 1 && !wayConnectionType.linkNext || wayConnectionType.direction == null || WayConnectionType.Direction.NONE.equals((Object)wayConnectionType.direction);
            if (!bl3) continue;
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Route relation contains a gap", new Object[0]), 3602, relation));
            return;
        }
    }
}

