/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.I18n;

public class MapScaler
extends JComponent
implements Helpful,
Accessible {
    private final NavigatableComponent mv;
    private static final int PADDING_RIGHT = 100;

    public MapScaler(NavigatableComponent navigatableComponent) {
        this.mv = navigatableComponent;
        this.setSize(200, 30);
        this.setOpaque(false);
    }

    @Override
    public void paint(Graphics graphics) {
        String string = this.mv.getDist100PixelText();
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
        graphics.setColor(MapScaler.getColor());
        graphics.drawLine(0, 5, 99, 5);
        graphics.drawLine(0, 0, 0, 10);
        graphics.drawLine(99, 0, 99, 10);
        graphics.drawLine(49, 3, 49, 7);
        graphics.drawLine(24, 3, 24, 7);
        graphics.drawLine(74, 3, 74, 7);
        graphics.drawString(string, (int)(100.0 - rectangle2D.getWidth() / 2.0), 23);
        graphics.drawString("0", 0, 23);
    }

    public static Color getColor() {
        return Main.pref.getColor(I18n.marktr("scale"), Color.white);
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/MapView/Scaler");
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMapScaler();
        }
        return this.accessibleContext;
    }

    class AccessibleMapScaler
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        AccessibleMapScaler() {
            super(MapScaler.this);
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return MapScaler.this.mv.getDist100Pixel();
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return null;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

