/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.util.GuiHelper;

public abstract class MemberTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_IN_JOSM_SELECTION = new Color(235, 255, 177);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_DOUBLE_ENTRY = new Color(254, 226, 214);

    public MemberTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
    }

    protected void reset() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackgroundForeground(MemberTableModel memberTableModel, OsmPrimitive osmPrimitive, boolean bl) {
        Color color = UIManager.getColor("Table.background");
        if (bl) {
            color = UIManager.getColor("Table.selectionBackground");
        } else if (osmPrimitive != null && memberTableModel.isInJosmSelection(osmPrimitive)) {
            color = BGCOLOR_IN_JOSM_SELECTION;
        } else if (osmPrimitive != null && memberTableModel.getNumMembersWithPrimitive(osmPrimitive) > 1) {
            color = BGCOLOR_DOUBLE_ENTRY;
        }
        GuiHelper.setBackgroundReadable(this, color);
    }

    @Override
    public abstract Component getTableCellRendererComponent(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);

    protected MemberTableModel getModel(JTable jTable) {
        return (MemberTableModel)jTable.getModel();
    }
}

