/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public final class TaggingPresets {
    private static final Collection<TaggingPreset> taggingPresets = new ArrayList<TaggingPreset>();
    private static final Collection<TaggingPresetListener> listeners = new ArrayList<TaggingPresetListener>();

    private TaggingPresets() {
    }

    public static void readFromPreferences() {
        taggingPresets.clear();
        taggingPresets.addAll(TaggingPresetReader.readFromPreferences(false, false));
    }

    public static void initialize() {
        TaggingPresets.readFromPreferences();
        for (TaggingPreset object : taggingPresets) {
            if (object instanceof TaggingPresetSeparator) continue;
            Main.toolbar.register(object);
        }
        if (taggingPresets.isEmpty()) {
            Main.main.menu.presetsMenu.setVisible(false);
        } else {
            AutoCompletionManager.cachePresets(taggingPresets);
            HashMap hashMap = new HashMap();
            for (TaggingPreset taggingPreset : taggingPresets) {
                JMenuItem jMenuItem;
                JMenu jMenu;
                JMenu jMenu2 = jMenu = taggingPreset.group != null ? (JMenu)hashMap.get(taggingPreset.group) : Main.main.menu.presetsMenu;
                if (jMenu == null && taggingPreset.group != null) {
                    Main.error("No tagging preset submenu for " + taggingPreset.group);
                    continue;
                }
                if (jMenu == null) {
                    Main.error("No tagging preset menu. Tagging preset " + taggingPreset + " won't be available there");
                    continue;
                }
                if (taggingPreset instanceof TaggingPresetSeparator) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                if (taggingPreset instanceof TaggingPresetMenu) {
                    jMenuItem = new JMenu(taggingPreset);
                    jMenuItem.setText(taggingPreset.getLocaleName());
                    ((TaggingPresetMenu)taggingPreset).menu = jMenuItem;
                    hashMap.put((TaggingPresetMenu)taggingPreset, jMenuItem);
                    jMenu.add(jMenuItem);
                    continue;
                }
                jMenuItem = new JMenuItem(taggingPreset);
                jMenuItem.setText(taggingPreset.getLocaleName());
                jMenu.add(jMenuItem);
            }
            for (JMenu jMenu : hashMap.values()) {
                if (jMenu.getItemCount() < Main.pref.getInteger("taggingpreset.min-elements-for-scroller", 15)) continue;
                MenuScroller.setScrollerFor(jMenu);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(Main.main.menu.presetsMenu);
        }
    }

    public static Collection<TaggingPreset> getTaggingPresets() {
        return new ArrayList<TaggingPreset>(taggingPresets);
    }

    public static Collection<TaggingPreset> getMatchingPresets(final Collection<TaggingPresetType> collection, final Map<String, String> map, final boolean bl) {
        return Utils.filter(TaggingPresets.getTaggingPresets(), new Predicate<TaggingPreset>(){

            @Override
            public boolean evaluate(TaggingPreset taggingPreset) {
                return taggingPreset.matches(collection, map, bl);
            }
        });
    }

    public static Collection<TaggingPreset> getMatchingPresets(final OsmPrimitive osmPrimitive) {
        return Utils.filter(TaggingPresets.getTaggingPresets(), new Predicate<TaggingPreset>(){

            @Override
            public boolean evaluate(TaggingPreset taggingPreset) {
                return taggingPreset.evaluate(osmPrimitive);
            }
        });
    }

    public static void addTaggingPresets(Collection<TaggingPreset> collection) {
        if (collection != null && taggingPresets.addAll(collection)) {
            for (TaggingPresetListener taggingPresetListener : listeners) {
                taggingPresetListener.taggingPresetsModified();
            }
        }
    }

    public static void addListener(TaggingPresetListener taggingPresetListener) {
        if (taggingPresetListener != null) {
            listeners.add(taggingPresetListener);
        }
    }

    public static void removeListener(TaggingPresetListener taggingPresetListener) {
        if (taggingPresetListener != null) {
            listeners.remove(taggingPresetListener);
        }
    }
}

