/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.NativeFileChooser;
import org.openstreetmap.josm.gui.widgets.SwingFileChooser;

public class FileChooserManager {
    public static final BooleanProperty PROP_USE_NATIVE_FILE_DIALOG = new BooleanProperty("use.native.file.dialog", Main.isPlatformOsx());
    private final boolean open;
    private final String lastDirProperty;
    private final String curDir;
    private boolean multiple = false;
    private String title = null;
    private Collection<? extends FileFilter> filters;
    private FileFilter defaultFilter;
    private int selectionMode = 0;
    private String extension = null;
    private boolean allTypes = false;
    private File file = null;
    private AbstractFileChooser fc;

    public FileChooserManager() {
        this(false, null, null);
    }

    public FileChooserManager(boolean bl) {
        this(bl, null);
    }

    public FileChooserManager(boolean bl, String string) {
        this(bl, string, null);
    }

    public FileChooserManager(boolean bl, String string, String string2) {
        this.open = bl;
        String string3 = this.lastDirProperty = string == null || string.isEmpty() ? "lastDirectory" : string;
        this.curDir = Main.pref.get(this.lastDirProperty).isEmpty() ? (string2 == null || string2.isEmpty() ? "." : string2) : Main.pref.get(this.lastDirProperty);
    }

    public final AbstractFileChooser getFileChooser() {
        return this.fc;
    }

    public final String getInitialDirectory() {
        return this.curDir;
    }

    public final FileChooserManager createFileChooser() {
        return this.doCreateFileChooser();
    }

    public final FileChooserManager createFileChooser(boolean bl, String string, FileFilter fileFilter, int n) {
        this.multiple(bl);
        this.title(string);
        this.filters(Collections.singleton(fileFilter));
        this.defaultFilter(fileFilter);
        this.selectionMode(n);
        this.doCreateFileChooser();
        this.fc.setAcceptAllFileFilterUsed(false);
        return this;
    }

    public final FileChooserManager createFileChooser(boolean bl, String string, Collection<? extends FileFilter> collection, FileFilter fileFilter, int n) {
        this.multiple(bl);
        this.title(string);
        this.filters(collection);
        this.defaultFilter(fileFilter);
        this.selectionMode(n);
        return this.doCreateFileChooser();
    }

    public final FileChooserManager createFileChooser(boolean bl, String string, String string2, boolean bl2, int n) {
        this.multiple(bl);
        this.title(string);
        this.extension(string2);
        this.allTypes(bl2);
        this.selectionMode(n);
        return this.doCreateFileChooser();
    }

    public FileChooserManager multiple(boolean bl) {
        this.multiple = bl;
        return this;
    }

    public FileChooserManager title(String string) {
        this.title = string;
        return this;
    }

    public FileChooserManager filters(Collection<? extends FileFilter> collection) {
        this.filters = collection;
        return this;
    }

    public FileChooserManager defaultFilter(FileFilter fileFilter) {
        this.defaultFilter = fileFilter;
        return this;
    }

    public FileChooserManager selectionMode(int n) {
        this.selectionMode = n;
        return this;
    }

    public FileChooserManager extension(String string) {
        this.extension = string;
        return this;
    }

    public FileChooserManager allTypes(boolean bl) {
        this.allTypes = bl;
        return this;
    }

    public FileChooserManager file(File file) {
        this.file = file;
        return this;
    }

    public FileChooserManager doCreateFileChooser() {
        File file = new File(this.curDir);
        this.fc = PROP_USE_NATIVE_FILE_DIALOG.get() != false && NativeFileChooser.supportsSelectionMode(this.selectionMode) ? new NativeFileChooser(file) : new SwingFileChooser(file);
        if (this.title != null) {
            this.fc.setDialogTitle(this.title);
        }
        this.fc.setFileSelectionMode(this.selectionMode);
        this.fc.setMultiSelectionEnabled(this.multiple);
        this.fc.setAcceptAllFileFilterUsed(false);
        this.fc.setSelectedFile(this.file);
        if (this.filters != null) {
            for (FileFilter fileFilter : this.filters) {
                this.fc.addChoosableFileFilter(fileFilter);
            }
            if (this.defaultFilter != null) {
                this.fc.setFileFilter(this.defaultFilter);
            }
        } else if (this.open) {
            ExtensionFileFilter.applyChoosableImportFileFilters(this.fc, this.extension, this.allTypes);
        } else {
            ExtensionFileFilter.applyChoosableExportFileFilters(this.fc, this.extension, this.allTypes);
        }
        return this;
    }

    public final AbstractFileChooser openFileChooser() {
        return this.openFileChooser(null);
    }

    public AbstractFileChooser openFileChooser(Component component) {
        int n;
        if (this.fc == null) {
            this.doCreateFileChooser();
        }
        if (component == null) {
            component = Main.parent;
        }
        int n2 = n = this.open ? this.fc.showOpenDialog(component) : this.fc.showSaveDialog(component);
        if (n != 0) {
            return null;
        }
        if (!this.fc.getCurrentDirectory().getAbsolutePath().equals(this.curDir)) {
            Main.pref.put(this.lastDirProperty, this.fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!(this.open || PROP_USE_NATIVE_FILE_DIALOG.get().booleanValue() || SaveActionBase.confirmOverwrite(this.fc.getSelectedFile()))) {
            return null;
        }
        return this.fc;
    }

    public File getFileForSave() {
        return SaveActionBase.checkFileAndConfirmOverWrite(this.openFileChooser(), this.extension);
    }
}

