/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetDiscussionComment;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.InvalidXmlCharacterFilter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class OsmChangesetParser {
    private final List<Changeset> changesets = new LinkedList<Changeset>();

    private OsmChangesetParser() {
    }

    public List<Changeset> getChangesets() {
        return this.changesets;
    }

    public static List<Changeset> parse(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        OsmChangesetParser osmChangesetParser = new OsmChangesetParser();
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing list of changesets...", new Object[0]));
            InputSource inputSource = new InputSource(new InvalidXmlCharacterFilter(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
            OsmChangesetParser osmChangesetParser2 = osmChangesetParser;
            osmChangesetParser2.getClass();
            Utils.parseSafeSAX(inputSource, osmChangesetParser2.new Parser());
            List<Changeset> list = osmChangesetParser.getChangesets();
            return list;
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new IllegalDataException(exception.getMessage(), exception);
        }
        catch (Exception exception) {
            throw new IllegalDataException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;
        private Changeset current;
        private ChangesetDiscussionComment comment;
        private StringBuilder text;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String string) throws XmlParsingException {
            throw new XmlParsingException(string).rememberLocation(this.locator);
        }

        protected void parseChangesetAttributes(Attributes attributes) throws XmlParsingException {
            String string;
            String string2 = attributes.getValue("id");
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "id"));
            }
            this.current.setId(this.parseNumericAttribute(string2, 1));
            this.current.setUser(this.createUser(attributes));
            string2 = attributes.getValue("created_at");
            if (string2 == null) {
                this.current.setCreatedAt(null);
            } else {
                this.current.setCreatedAt(DateUtils.fromString(string2));
            }
            string2 = attributes.getValue("closed_at");
            if (string2 == null) {
                this.current.setClosedAt(null);
            } else {
                this.current.setClosedAt(DateUtils.fromString(string2));
            }
            string2 = attributes.getValue("open");
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "open"));
            } else if ("true".equals(string2)) {
                this.current.setOpen(true);
            } else if ("false".equals(string2)) {
                this.current.setOpen(false);
            } else {
                this.throwException(I18n.tr("Illegal boolean value for attribute ''{0}''. Got ''{1}''.", "open", string2));
            }
            String string3 = attributes.getValue("min_lon");
            String string4 = attributes.getValue("min_lat");
            String string5 = attributes.getValue("max_lon");
            String string6 = attributes.getValue("max_lat");
            if (string3 != null && string4 != null && string5 != null && string6 != null) {
                double d = 0.0;
                try {
                    d = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "min_lon", string3));
                }
                double d2 = 0.0;
                try {
                    d2 = Double.parseDouble(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "min_lat", string4));
                }
                this.current.setMin(new LatLon(d2, d));
                double d3 = 0.0;
                try {
                    d3 = Double.parseDouble(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "max_lon", string5));
                }
                double d4 = 0.0;
                try {
                    d4 = Double.parseDouble(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "max_lat", string6));
                }
                this.current.setMax(new LatLon(d3, d4));
            }
            if ((string = attributes.getValue("comments_count")) != null) {
                this.current.setCommentsCount(this.parseNumericAttribute(string, 0));
            }
        }

        private void parseCommentAttributes(Attributes attributes) throws XmlParsingException {
            String string = attributes.getValue("date");
            Date date = null;
            if (string != null) {
                date = DateUtils.fromString(string);
            }
            this.comment = new ChangesetDiscussionComment(date, this.createUser(attributes));
        }

        private int parseNumericAttribute(String string, int n) throws XmlParsingException {
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "id", string));
            }
            if (n2 < n) {
                this.throwException(I18n.tr("Illegal numeric value for attribute ''{0}''. Got ''{1}''.", "id", n2));
            }
            return n2;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (string3) {
                case "osm": {
                    if (attributes == null) {
                        this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' of XML element {1}.", "version", "osm"));
                        return;
                    }
                    String string4 = attributes.getValue("version");
                    if (string4 == null) {
                        this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
                    }
                    if ("0.6".equals(string4)) break;
                    this.throwException(I18n.tr("Unsupported version: {0}", string4));
                    break;
                }
                case "changeset": {
                    this.current = new Changeset();
                    this.parseChangesetAttributes(attributes);
                    break;
                }
                case "tag": {
                    String string5 = attributes.getValue("k");
                    String string6 = attributes.getValue("v");
                    this.current.put(string5, string6);
                    break;
                }
                case "discussion": {
                    break;
                }
                case "comment": {
                    this.parseCommentAttributes(attributes);
                    break;
                }
                case "text": {
                    this.text = new StringBuilder();
                    break;
                }
                default: {
                    this.throwException(I18n.tr("Undefined element ''{0}'' found in input stream. Aborting.", string3));
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("changeset".equals(string3)) {
                OsmChangesetParser.this.changesets.add(this.current);
                this.current = null;
            } else if ("comment".equals(string3)) {
                this.current.addDiscussionComment(this.comment);
                this.comment = null;
            } else if ("text".equals(string3)) {
                this.comment.setText(this.text.toString());
                this.text = null;
            }
        }

        protected User createUser(Attributes attributes) throws XmlParsingException {
            String string = attributes.getValue("user");
            String string2 = attributes.getValue("uid");
            if (string2 == null) {
                if (string == null) {
                    return null;
                }
                return User.createLocalUser(string);
            }
            try {
                long l = Long.parseLong(string2);
                return User.createOsmUser(l, string);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", string2));
                return null;
            }
        }
    }
}

