/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.codegen;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.util.BasicObjectStubGenerator;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.CodegenUtils;

public abstract class RealClassGenerator {
    private static final boolean DEBUG = false;
    private static final int V_BC = 50;

    public static Map<String, List<Method>> buildSimpleToAllMap(Class[] interfaces2, String[] superTypeNames) throws SecurityException {
        LinkedHashMap<String, List<Method>> simpleToAll = new LinkedHashMap<String, List<Method>>();
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            superTypeNames[i2] = CodegenUtils.p(interfaces2[i2]);
            for (Method method : interfaces2[i2].getMethods()) {
                String name2 = method.getName();
                ArrayList<Method> methods2 = (ArrayList<Method>)simpleToAll.get(name2);
                if (methods2 == null) {
                    String getName;
                    List getMethods;
                    methods2 = new ArrayList<Method>(6);
                    simpleToAll.put(name2, methods2);
                    if (name2.startsWith("is") && name2.length() > 2 && (getMethods = (List)simpleToAll.get(getName = "get" + name2.substring(2))) != null) {
                        simpleToAll.remove(getName);
                        simpleToAll.put(getName, getMethods);
                    }
                }
                methods2.add(method);
            }
        }
        return simpleToAll;
    }

    public static Class createOldStyleImplClass(Class[] superTypes, RubyClass rubyClass, Ruby ruby2, String name2, ClassDefiningClassLoader classLoader) {
        String[] superTypeNames = new String[superTypes.length];
        Map<String, List<Method>> simpleToAll = RealClassGenerator.buildSimpleToAllMap(superTypes, superTypeNames);
        Class newClass = RealClassGenerator.defineOldStyleImplClass(ruby2, name2, superTypeNames, simpleToAll, classLoader);
        return newClass;
    }

    public static Class createRealImplClass(Class superClass, Class[] interfaces2, RubyClass rubyClass, Ruby ruby2, String name2) {
        String[] superTypeNames = new String[interfaces2.length];
        Map<String, List<Method>> simpleToAll = RealClassGenerator.buildSimpleToAllMap(interfaces2, superTypeNames);
        Class newClass = RealClassGenerator.defineRealImplClass(ruby2, name2, superClass, superTypeNames, simpleToAll);
        return newClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class defineOldStyleImplClass(Ruby ruby2, String name2, String[] superTypeNames, Map<String, List<Method>> simpleToAll, ClassDefiningClassLoader classLoader) {
        Class<?> newClass;
        ClassDefiningClassLoader classDefiningClassLoader = classLoader;
        synchronized (classDefiningClassLoader) {
            try {
                newClass = classLoader.loadClass(name2);
            }
            catch (ClassNotFoundException ex) {
                ClassWriter cw = new ClassWriter(1);
                String pathName = name2.replace('.', '/');
                cw.visit(50, 33, pathName, null, CodegenUtils.p(Object.class), superTypeNames);
                cw.visitSource(pathName + ".gen", null);
                cw.visitField(26, "$runtimeCache", CodegenUtils.ci(RuntimeCache.class), null, null).visitEnd();
                cw.visitField(18, "$self", CodegenUtils.ci(IRubyObject.class), null, null).visitEnd();
                SkinnyMethodAdapter clinitMethod = new SkinnyMethodAdapter(cw, 9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
                SkinnyMethodAdapter initMethod = new SkinnyMethodAdapter(cw, 1, "<init>", CodegenUtils.sig(Void.TYPE, IRubyObject.class), null, null);
                initMethod.aload(0);
                initMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
                initMethod.aload(0);
                initMethod.aload(1);
                initMethod.putfield(pathName, "$self", CodegenUtils.ci(IRubyObject.class));
                initMethod.voidreturn();
                initMethod.end();
                int cacheSize = 0;
                HashSet<String> implementedNames = new HashSet<String>();
                for (Map.Entry<String, List<Method>> entry : simpleToAll.entrySet()) {
                    String simpleName = entry.getKey();
                    List<Method> methods2 = entry.getValue();
                    Set<String> nameSet = JavaUtil.getRubyNamesForJavaName(simpleName, methods2);
                    implementedNames.clear();
                    for (int i2 = 0; i2 < methods2.size(); ++i2) {
                        Method method = methods2.get(i2);
                        Class[] paramTypes = method.getParameterTypes();
                        Class<?> returnType = method.getReturnType();
                        String fullName = simpleName + CodegenUtils.prettyParams(paramTypes);
                        if (implementedNames.contains(fullName)) continue;
                        implementedNames.add(fullName);
                        int baseIndex = 1;
                        for (Class paramType : paramTypes) {
                            if (paramType == Double.TYPE || paramType == Long.TYPE) {
                                baseIndex += 2;
                                continue;
                            }
                            ++baseIndex;
                        }
                        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw, 1, simpleName, CodegenUtils.sig(returnType, paramTypes), null, null);
                        mv.start();
                        mv.line(1);
                        switch (simpleName) {
                            case "equals": {
                                if (RealClassGenerator.defineDefaultEquals(2, mv, paramTypes, returnType)) break;
                                RealClassGenerator.defineOldStyleBody(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                                break;
                            }
                            case "hashCode": {
                                if (RealClassGenerator.defineDefaultHashCode(3, mv, paramTypes, returnType)) break;
                                RealClassGenerator.defineOldStyleBody(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                                break;
                            }
                            case "toString": {
                                if (RealClassGenerator.defineDefaultToString(4, mv, paramTypes, returnType)) break;
                                RealClassGenerator.defineOldStyleBody(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                                break;
                            }
                            case "__ruby_object": {
                                if (paramTypes.length == 0 && returnType == IRubyObject.class) {
                                    mv.aload(0);
                                    mv.getfield(pathName, "$self", CodegenUtils.ci(IRubyObject.class));
                                    mv.areturn();
                                    break;
                                }
                            }
                            default: {
                                RealClassGenerator.defineOldStyleBody(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                            }
                        }
                        mv.end();
                    }
                }
                clinitMethod.newobj(CodegenUtils.p(RuntimeCache.class));
                clinitMethod.dup();
                clinitMethod.invokespecial(CodegenUtils.p(RuntimeCache.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
                clinitMethod.dup();
                clinitMethod.ldc(cacheSize);
                clinitMethod.invokevirtual(CodegenUtils.p(RuntimeCache.class), "initMethodCache", CodegenUtils.sig(Void.TYPE, Integer.TYPE));
                clinitMethod.putstatic(pathName, "$runtimeCache", CodegenUtils.ci(RuntimeCache.class));
                clinitMethod.voidreturn();
                clinitMethod.end();
                cw.visitEnd();
                byte[] bytecode = cw.toByteArray();
                newClass = classLoader.defineClass(name2, bytecode);
            }
        }
        return newClass;
    }

    private static void defineOldStyleBody(SkinnyMethodAdapter mv, String pathName, String simpleName, Class[] paramTypes, Class returnType, int baseIndex, int cacheIndex, Set<String> nameSet) {
        int selfIndex = baseIndex;
        int rubyIndex = selfIndex + 1;
        mv.line(5);
        mv.aload(0);
        mv.getfield(pathName, "$self", CodegenUtils.ci(IRubyObject.class));
        mv.astore(selfIndex);
        mv.aload(selfIndex);
        mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        mv.astore(rubyIndex);
        mv.getstatic(pathName, "$runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        mv.aload(selfIndex);
        mv.ldc(cacheIndex);
        for (String eachName : nameSet) {
            mv.ldc(eachName);
        }
        mv.invokevirtual(CodegenUtils.p(RuntimeCache.class), "searchWithCache", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(IRubyObject.class, Integer.TYPE, String.class, nameSet.size())));
        mv.aload(rubyIndex);
        mv.invokevirtual(CodegenUtils.p(Ruby.class), "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
        mv.aloadMany(selfIndex, selfIndex);
        mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        mv.ldc(simpleName);
        RealClassGenerator.coerceArgumentsToRuby(mv, paramTypes, rubyIndex);
        mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        mv.line(13);
        mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
        RealClassGenerator.coerceResultAndReturn(mv, returnType);
    }

    public static Class defineRealImplClass(Ruby runtime, String name2, Class superClass, String[] superTypeNames, Map<String, List<Method>> simpleToAll) {
        Class<?> newClass;
        ClassWriter cw = new ClassWriter(1);
        String pathName = name2.replace('.', '/');
        boolean isRubyHierarchy = RubyBasicObject.class.isAssignableFrom(superClass);
        if (isRubyHierarchy) {
            cw.visit(50, 33, pathName, null, CodegenUtils.p(superClass), superTypeNames);
        } else {
            String[] plusIRubyObject = new String[superTypeNames.length + 1];
            plusIRubyObject[0] = CodegenUtils.p(IRubyObject.class);
            System.arraycopy(superTypeNames, 0, plusIRubyObject, 1, superTypeNames.length);
            cw.visit(50, 33, pathName, null, CodegenUtils.p(superClass), plusIRubyObject);
        }
        cw.visitSource(pathName + ".gen", null);
        cw.visitField(26, "$runtimeCache", CodegenUtils.ci(RuntimeCache.class), null, null).visitEnd();
        SkinnyMethodAdapter clinitMethod = new SkinnyMethodAdapter(cw, 9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
        SkinnyMethodAdapter initMethod = new SkinnyMethodAdapter(cw, 1, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), null, null);
        if (isRubyHierarchy) {
            initMethod.aloadMany(0, 1, 2);
            initMethod.invokespecial(CodegenUtils.p(superClass), "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
        } else {
            cw.visitField(18, "$ruby", CodegenUtils.ci(Ruby.class), null, null).visitEnd();
            cw.visitField(18, "$rubyClass", CodegenUtils.ci(RubyClass.class), null, null).visitEnd();
            initMethod.aloadMany(0, 1);
            initMethod.putfield(pathName, "$ruby", CodegenUtils.ci(Ruby.class));
            initMethod.aloadMany(0, 2);
            initMethod.putfield(pathName, "$rubyClass", CodegenUtils.ci(RubyClass.class));
            initMethod.aload(0);
            initMethod.invokespecial(CodegenUtils.p(superClass), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        }
        initMethod.voidreturn();
        initMethod.end();
        if (isRubyHierarchy) {
            SkinnyMethodAdapter toJavaMethod = new SkinnyMethodAdapter(cw, 1, "toJava", CodegenUtils.sig(Object.class, Class.class), null, null);
            toJavaMethod.aload(0);
            toJavaMethod.areturn();
            toJavaMethod.end();
        } else {
            BasicObjectStubGenerator.addBasicObjectStubsToClass(cw);
            SkinnyMethodAdapter getRuntimeMethod = new SkinnyMethodAdapter(cw, 1, "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]), null, null);
            getRuntimeMethod.aload(0);
            getRuntimeMethod.getfield(pathName, "$ruby", CodegenUtils.ci(Ruby.class));
            getRuntimeMethod.areturn();
            getRuntimeMethod.end();
            SkinnyMethodAdapter getMetaClassMethod = new SkinnyMethodAdapter(cw, 1, "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]), null, null);
            getMetaClassMethod.aload(0);
            getMetaClassMethod.getfield(pathName, "$rubyClass", CodegenUtils.ci(RubyClass.class));
            getMetaClassMethod.areturn();
            getMetaClassMethod.end();
        }
        int cacheSize = 0;
        HashSet<String> implementedNames = new HashSet<String>();
        for (Map.Entry<String, List<Method>> entry : simpleToAll.entrySet()) {
            String simpleName = entry.getKey();
            List<Method> methods2 = entry.getValue();
            Set<String> nameSet = JavaUtil.getRubyNamesForJavaName(simpleName, methods2);
            implementedNames.clear();
            for (int i2 = 0; i2 < methods2.size(); ++i2) {
                Method method = methods2.get(i2);
                Class[] paramTypes = method.getParameterTypes();
                Class<?> returnType = method.getReturnType();
                String fullName = simpleName + CodegenUtils.prettyParams(paramTypes);
                if (implementedNames.contains(fullName)) continue;
                implementedNames.add(fullName);
                int baseIndex = 1;
                for (Class paramType : paramTypes) {
                    if (paramType == Double.TYPE || paramType == Long.TYPE) {
                        baseIndex += 2;
                        continue;
                    }
                    ++baseIndex;
                }
                SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw, 1, simpleName, CodegenUtils.sig(returnType, paramTypes), null, null);
                mv.start();
                mv.line(1);
                switch (simpleName) {
                    case "equals": {
                        if (paramTypes.length == 1 && paramTypes[0] == Object.class && returnType == Boolean.TYPE) {
                            RealClassGenerator.defineRealEqualsWithFallback(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                            break;
                        }
                        RealClassGenerator.defineRealBody(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                        break;
                    }
                    case "hashCode": {
                        if (paramTypes.length == 0 && returnType == Integer.TYPE) {
                            RealClassGenerator.defineRealHashCodeWithFallback(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                            break;
                        }
                        RealClassGenerator.defineRealBody(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                        break;
                    }
                    case "toString": {
                        if (paramTypes.length == 0 && returnType == String.class) {
                            RealClassGenerator.defineRealToStringWithFallback(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                            break;
                        }
                        RealClassGenerator.defineRealBody(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                        break;
                    }
                    default: {
                        RealClassGenerator.defineRealBody(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheSize++, nameSet);
                    }
                }
                mv.end();
            }
        }
        clinitMethod.newobj(CodegenUtils.p(RuntimeCache.class));
        clinitMethod.dup();
        clinitMethod.invokespecial(CodegenUtils.p(RuntimeCache.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        clinitMethod.dup();
        clinitMethod.ldc(cacheSize);
        clinitMethod.invokevirtual(CodegenUtils.p(RuntimeCache.class), "initMethodCache", CodegenUtils.sig(Void.TYPE, Integer.TYPE));
        clinitMethod.putstatic(pathName, "$runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        clinitMethod.voidreturn();
        clinitMethod.end();
        cw.visitEnd();
        ClassDefiningJRubyClassLoader loader = superClass.getClassLoader() instanceof ClassDefiningJRubyClassLoader ? new ClassDefiningJRubyClassLoader(superClass.getClassLoader()) : new ClassDefiningJRubyClassLoader(runtime.getJRubyClassLoader());
        try {
            newClass = loader.loadClass(name2);
        }
        catch (ClassNotFoundException ex) {
            byte[] bytecode = cw.toByteArray();
            newClass = loader.defineClass(name2, bytecode);
        }
        return newClass;
    }

    private static void defineRealBody(SkinnyMethodAdapter mv, String pathName, String simpleName, Class[] paramTypes, Class returnType, int baseIndex, int cacheIndex, Set<String> nameSet) {
        int rubyIndex = baseIndex + 1;
        mv.line(5);
        mv.aload(0);
        mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        mv.astore(rubyIndex);
        mv.getstatic(pathName, "$runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        mv.aload(0);
        mv.ldc(cacheIndex);
        for (String eachName : nameSet) {
            mv.ldc(eachName);
        }
        mv.invokevirtual(CodegenUtils.p(RuntimeCache.class), "searchWithCache", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(IRubyObject.class, Integer.TYPE, String.class, nameSet.size())));
        mv.aload(rubyIndex);
        mv.invokevirtual(CodegenUtils.p(Ruby.class), "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
        mv.aloadMany(0, 0);
        mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        mv.ldc(simpleName);
        RealClassGenerator.coerceArgumentsToRuby(mv, paramTypes, rubyIndex);
        mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        mv.line(13);
        mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
        RealClassGenerator.coerceResultAndReturn(mv, returnType);
    }

    private static void defineRealBodyWithFallback(SkinnyMethodAdapter mv, String pathName, String simpleName, Class[] paramTypes, Class returnType, int baseIndex, int cacheIndex, Set<String> nameSet) {
        int rubyIndex = baseIndex + 1;
        mv.aload(0);
        mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        mv.astore(rubyIndex);
        mv.getstatic(pathName, "$runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        mv.aload(0);
        mv.ldc(cacheIndex);
        for (String eachName : nameSet) {
            mv.ldc(eachName);
        }
        mv.invokevirtual(CodegenUtils.p(RuntimeCache.class), "searchWithCacheNoMethodMissing", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(IRubyObject.class, Integer.TYPE, String.class, nameSet.size())));
        int methodIndex = baseIndex + 2;
        mv.astore(methodIndex);
        Label fallback = new Label();
        mv.aload(methodIndex);
        mv.ifnull(fallback);
        mv.aload(methodIndex);
        mv.aload(rubyIndex);
        mv.invokevirtual(CodegenUtils.p(Ruby.class), "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
        mv.aloadMany(0, 0);
        mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        mv.ldc(simpleName);
        RealClassGenerator.coerceArgumentsToRuby(mv, paramTypes, rubyIndex);
        mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
        RealClassGenerator.coerceResultAndReturn(mv, returnType);
        mv.label(fallback);
        switch (simpleName) {
            case "equals": {
                RealClassGenerator.objectEquals(-1, mv);
                break;
            }
            case "hashCode": {
                RealClassGenerator.objectHashCode(-1, mv);
                break;
            }
            case "toString": {
                RealClassGenerator.objectToString(-1, mv);
                break;
            }
            default: {
                throw new UnsupportedOperationException(simpleName);
            }
        }
    }

    private static void defineRealEqualsWithFallback(SkinnyMethodAdapter mv, String pathName, String simpleName, Class[] paramTypes, Class returnType, int baseIndex, int cacheIndex, Set<String> nameSet) {
        RealClassGenerator.defineRealBodyWithFallback(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheIndex, nameSet);
    }

    private static void defineRealHashCodeWithFallback(SkinnyMethodAdapter mv, String pathName, String simpleName, Class[] paramTypes, Class returnType, int baseIndex, int cacheIndex, Set<String> nameSet) {
        RealClassGenerator.defineRealBodyWithFallback(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheIndex, nameSet);
    }

    private static void defineRealToStringWithFallback(SkinnyMethodAdapter mv, String pathName, String simpleName, Class[] paramTypes, Class returnType, int baseIndex, int cacheIndex, Set<String> nameSet) {
        RealClassGenerator.defineRealBodyWithFallback(mv, pathName, simpleName, paramTypes, returnType, baseIndex, cacheIndex, nameSet);
    }

    private static boolean defineDefaultEquals(int line, SkinnyMethodAdapter mv, Class[] paramTypes, Class returnType) {
        if (paramTypes.length == 1 && paramTypes[0] == Object.class && returnType == Boolean.TYPE) {
            RealClassGenerator.objectEquals(line, mv);
            return true;
        }
        return false;
    }

    private static void objectEquals(int line, SkinnyMethodAdapter mv) {
        if (line > 0) {
            mv.line(line);
        }
        mv.aload(0);
        mv.aload(1);
        mv.invokespecial(CodegenUtils.p(Object.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
        mv.ireturn();
    }

    private static boolean defineDefaultHashCode(int line, SkinnyMethodAdapter mv, Class[] paramTypes, Class returnType) {
        if (paramTypes.length == 0 && returnType == Integer.TYPE) {
            RealClassGenerator.objectHashCode(line, mv);
            return true;
        }
        return false;
    }

    private static void objectHashCode(int line, SkinnyMethodAdapter mv) {
        if (line > 0) {
            mv.line(line);
        }
        mv.aload(0);
        mv.invokespecial(CodegenUtils.p(Object.class), "hashCode", CodegenUtils.sig(Integer.TYPE, new Class[0]));
        mv.ireturn();
    }

    private static boolean defineDefaultToString(int line, SkinnyMethodAdapter mv, Class[] paramTypes, Class returnType) {
        if (paramTypes.length == 0 && returnType == String.class) {
            RealClassGenerator.objectToString(line, mv);
            return true;
        }
        return false;
    }

    private static void objectToString(int line, SkinnyMethodAdapter mv) {
        if (line > 0) {
            mv.line(line);
        }
        mv.aload(0);
        mv.invokespecial(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        mv.areturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeClassFile(String name2, byte[] bytecode) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(name2 + ".class");
            fos.write(bytecode);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception2) {}
        }
    }

    public static void coerceArgumentsToRuby(SkinnyMethodAdapter mv, Class[] paramTypes, int rubyIndex) {
        if (paramTypes.length != 0) {
            mv.pushInt(paramTypes.length);
            mv.anewarray(CodegenUtils.p(IRubyObject.class));
            int argIndex = 1;
            for (int i2 = 0; i2 < paramTypes.length; ++i2) {
                Class paramType = paramTypes[i2];
                mv.dup();
                mv.pushInt(i2);
                mv.aload(rubyIndex);
                if (paramTypes[i2].isPrimitive()) {
                    if (paramType == Byte.TYPE || paramType == Short.TYPE || paramType == Character.TYPE || paramType == Integer.TYPE) {
                        mv.iload(argIndex++);
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Integer.TYPE));
                    } else if (paramType == Long.TYPE) {
                        mv.lload(argIndex);
                        argIndex += 2;
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Long.TYPE));
                    } else if (paramType == Float.TYPE) {
                        mv.fload(argIndex++);
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Float.TYPE));
                    } else if (paramType == Double.TYPE) {
                        mv.dload(argIndex);
                        argIndex += 2;
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Double.TYPE));
                    } else if (paramType == Boolean.TYPE) {
                        mv.iload(argIndex++);
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Boolean.TYPE));
                    }
                } else {
                    mv.aload(argIndex++);
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToUsableRubyObject", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
                }
                mv.aastore();
            }
        } else {
            mv.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        }
    }

    public static void coerceResultAndReturn(SkinnyMethodAdapter mv, Class returnType) {
        if (returnType != Void.TYPE) {
            if (returnType.isPrimitive()) {
                if (returnType == Boolean.TYPE) {
                    mv.getstatic(CodegenUtils.p(Boolean.class), "TYPE", CodegenUtils.ci(Class.class));
                    mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "toJava", CodegenUtils.sig(Object.class, Class.class));
                    mv.checkcast(CodegenUtils.p(Boolean.class));
                    mv.invokevirtual(CodegenUtils.p(Boolean.class), "booleanValue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
                    mv.ireturn();
                } else {
                    mv.getstatic(CodegenUtils.p(CodegenUtils.getBoxType(returnType)), "TYPE", CodegenUtils.ci(Class.class));
                    mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "toJava", CodegenUtils.sig(Object.class, Class.class));
                    if (returnType == Byte.TYPE) {
                        mv.checkcast(CodegenUtils.p(Number.class));
                        mv.invokevirtual(CodegenUtils.p(Number.class), "byteValue", CodegenUtils.sig(Byte.TYPE, new Class[0]));
                        mv.ireturn();
                    } else if (returnType == Short.TYPE) {
                        mv.checkcast(CodegenUtils.p(Number.class));
                        mv.invokevirtual(CodegenUtils.p(Number.class), "shortValue", CodegenUtils.sig(Short.TYPE, new Class[0]));
                        mv.ireturn();
                    } else if (returnType == Character.TYPE) {
                        mv.checkcast(CodegenUtils.p(Character.class));
                        mv.invokevirtual(CodegenUtils.p(Character.class), "charValue", CodegenUtils.sig(Character.TYPE, new Class[0]));
                        mv.ireturn();
                    } else if (returnType == Integer.TYPE) {
                        mv.checkcast(CodegenUtils.p(Number.class));
                        mv.invokevirtual(CodegenUtils.p(Number.class), "intValue", CodegenUtils.sig(Integer.TYPE, new Class[0]));
                        mv.ireturn();
                    } else if (returnType == Long.TYPE) {
                        mv.checkcast(CodegenUtils.p(Number.class));
                        mv.invokevirtual(CodegenUtils.p(Number.class), "longValue", CodegenUtils.sig(Long.TYPE, new Class[0]));
                        mv.lreturn();
                    } else if (returnType == Float.TYPE) {
                        mv.checkcast(CodegenUtils.p(Number.class));
                        mv.invokevirtual(CodegenUtils.p(Number.class), "floatValue", CodegenUtils.sig(Float.TYPE, new Class[0]));
                        mv.freturn();
                    } else if (returnType == Double.TYPE) {
                        mv.checkcast(CodegenUtils.p(Number.class));
                        mv.invokevirtual(CodegenUtils.p(Number.class), "doubleValue", CodegenUtils.sig(Double.TYPE, new Class[0]));
                        mv.dreturn();
                    }
                }
            } else {
                mv.ldc(Type.getType(returnType));
                mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "toJava", CodegenUtils.sig(Object.class, Class.class));
                mv.checkcast(CodegenUtils.p(returnType));
                mv.areturn();
            }
        } else {
            mv.voidreturn();
        }
    }

    public static boolean isCacheOk(CacheEntry entry, IRubyObject self2) {
        return CacheEntry.typeOk(entry, self2.getMetaClass()) && entry.method != UndefinedMethod.INSTANCE;
    }
}

