/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.FindContextNode;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.KillException;
import com.oracle.truffle.api.instrument.QuitException;
import com.oracle.truffle.api.instrument.Visualizer;
import com.oracle.truffle.api.instrument.WrapperNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Objects;

public abstract class TruffleLanguage<C> {
    private static final AccessAPI API = new AccessAPI();

    protected TruffleLanguage() {
    }

    protected abstract C createContext(Env var1);

    protected void disposeContext(C context) {
    }

    protected abstract CallTarget parse(Source var1, Node var2, String ... var3) throws IOException;

    protected abstract Object findExportedSymbol(C var1, String var2, boolean var3);

    protected abstract Object getLanguageGlobal(C var1);

    protected abstract boolean isObjectOfLanguage(Object var1);

    protected abstract Visualizer getVisualizer();

    protected abstract boolean isInstrumentable(Node var1);

    protected abstract WrapperNode createWrapperNode(Node var1);

    protected abstract Object evalInContext(Source var1, Node var2, MaterializedFrame var3) throws IOException;

    protected String toString(C context, Object value) {
        return Objects.toString(value);
    }

    protected final Node createFindContextNode() {
        Class<?> c = this.getClass();
        return new FindContextNode(c);
    }

    protected final C findContext(Node n) {
        FindContextNode fcn = (FindContextNode)n;
        if (fcn.getLanguageClass() != this.getClass()) {
            throw new ClassCastException();
        }
        return fcn.executeFindContext();
    }

    private static final class AccessAPI
    extends Accessor {
        private AccessAPI() {
        }

        @Override
        protected Env attachEnv(Object vm, TruffleLanguage<?> language, OutputStream stdOut, OutputStream stdErr, InputStream stdIn, Instrumenter instrumenter) {
            Env env = new Env(vm, language, stdOut, stdErr, stdIn, instrumenter);
            return env;
        }

        @Override
        protected Object importSymbol(Object vm, TruffleLanguage<?> queryingLang, String globalName) {
            return super.importSymbol(vm, queryingLang, globalName);
        }

        @Override
        protected CallTarget parse(TruffleLanguage<?> truffleLanguage, Source code, Node context, String ... argumentNames) throws IOException {
            return truffleLanguage.parse(code, context, argumentNames);
        }

        @Override
        protected Object eval(TruffleLanguage<?> language, Source source, Map<Source, CallTarget> cache) throws IOException {
            CallTarget target = cache.get(source);
            if (target == null) {
                target = language.parse(source, null, new String[0]);
                if (target == null) {
                    throw new IOException("Parsing has not produced a CallTarget for " + source);
                }
                cache.put(source, target);
            }
            try {
                return target.call(new Object[0]);
            }
            catch (KillException | QuitException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IOException(ex);
            }
        }

        @Override
        protected Object evalInContext(Object vm, SuspendedEvent ev, String code, Node node, MaterializedFrame frame) throws IOException {
            RootNode rootNode = node.getRootNode();
            Class<? extends TruffleLanguage> languageType = this.findLanguage(rootNode);
            Env env = this.findLanguage(vm, languageType);
            TruffleLanguage<?> lang = this.findLanguage(env);
            Source source = Source.fromText(code, "eval in context");
            return lang.evalInContext(source, node, frame);
        }

        @Override
        protected Object findExportedSymbol(Env env, String globalName, boolean onlyExplicit) {
            return env.langCtx.findExportedSymbol(globalName, onlyExplicit);
        }

        @Override
        protected Env findLanguage(Object vm, Class<? extends TruffleLanguage> languageClass) {
            return super.findLanguage(vm, languageClass);
        }

        @Override
        protected TruffleLanguage<?> findLanguage(Env env) {
            return env.lang;
        }

        @Override
        protected TruffleLanguage<?> findLanguageImpl(Object known, Class<? extends TruffleLanguage> languageClass, String mimeType) {
            return super.findLanguageImpl(known, languageClass, mimeType);
        }

        @Override
        protected Object languageGlobal(Env env) {
            return env.langCtx.getLanguageGlobal();
        }

        @Override
        protected Object findContext(Env env) {
            return ((Env)env).langCtx.ctx;
        }

        protected boolean isInstrumentable(Node node, TruffleLanguage language) {
            return language.isInstrumentable(node);
        }

        protected WrapperNode createWrapperNode(Node node, TruffleLanguage language) {
            return language.createWrapperNode(node);
        }

        @Override
        protected void dispose(TruffleLanguage<?> impl, Env env) {
            assert (impl == ((Env)env).langCtx.lang);
            env.langCtx.dispose();
        }

        @Override
        protected String toString(TruffleLanguage<?> language, Env env, Object obj) {
            return env.langCtx.toString(language, obj);
        }
    }

    public static final class Env {
        private final Object vm;
        private final TruffleLanguage<?> lang;
        private final LangCtx<?> langCtx;
        private final InputStream in;
        private final OutputStream err;
        private final OutputStream out;
        private final Instrumenter instrumenter;

        Env(Object vm, TruffleLanguage<?> lang, OutputStream out, OutputStream err, InputStream in, Instrumenter instrumenter) {
            this.vm = vm;
            this.in = in;
            this.err = err;
            this.out = out;
            this.lang = lang;
            this.instrumenter = instrumenter;
            this.langCtx = new LangCtx(lang, this);
        }

        public Object importSymbol(String globalName) {
            return API.importSymbol(this.vm, this.lang, globalName);
        }

        public CallTarget parse(Source source, String ... argumentNames) throws IOException {
            TruffleLanguage<?> language = API.findLanguageImpl(this.vm, null, source.getMimeType());
            return language.parse(source, null, argumentNames);
        }

        public InputStream in() {
            return this.in;
        }

        public OutputStream out() {
            return this.out;
        }

        public OutputStream err() {
            return this.err;
        }

        public Instrumenter instrumenter() {
            return this.instrumenter;
        }
    }

    private static final class LangCtx<C> {
        final TruffleLanguage<C> lang;
        final C ctx;

        public LangCtx(TruffleLanguage<C> lang, Env env) {
            this.lang = lang;
            assert (API.findLanguage(null, null) == null);
            this.ctx = lang.createContext(env);
        }

        Object findExportedSymbol(String globalName, boolean onlyExplicit) {
            return this.lang.findExportedSymbol(this.ctx, globalName, onlyExplicit);
        }

        Object getLanguageGlobal() {
            return this.lang.getLanguageGlobal(this.ctx);
        }

        void dispose() {
            this.lang.disposeContext(this.ctx);
        }

        String toString(TruffleLanguage<?> language, Object obj) {
            assert (this.lang == language);
            return this.lang.toString(this.ctx, obj);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String name();

        public String version();

        public String[] mimeType();
    }
}

