/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.NodeCloneable;

public abstract class Profile
extends NodeCloneable {
    private static final boolean ENABLED;

    static boolean isProfilingEnabled() {
        return ENABLED;
    }

    Profile() {
    }

    String toStringDisabled(Class<?> profileClass) {
        return String.format("%s(DISABLED)", profileClass.getSimpleName());
    }

    String toString(Class<?> profileClass, boolean uninitialized, boolean generic, String specialization) {
        String s = uninitialized ? "UNINITIALIZED" : (generic ? "GENERIC" : (specialization == null ? "" : specialization));
        return String.format("%s(%s)@%s", profileClass.getSimpleName(), s, Integer.toHexString(this.hashCode()));
    }

    static {
        boolean enabled;
        try {
            enabled = Truffle.getRuntime().isProfilingEnabled();
        }
        catch (NoSuchMethodError ex) {
            enabled = true;
        }
        ENABLED = enabled;
    }
}

