/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class ModuleBodyDefinitionNode
extends RubyNode {
    private final String name;
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTarget;
    private final boolean captureBlock;

    public ModuleBodyDefinitionNode(RubyContext context, SourceSection sourceSection, String name, SharedMethodInfo sharedMethodInfo, CallTarget callTarget, boolean captureBlock) {
        super(context, sourceSection);
        this.name = name;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTarget = callTarget;
        this.captureBlock = captureBlock;
    }

    public InternalMethod executeMethod(VirtualFrame frame) {
        DynamicObject dummyModule = this.getContext().getCoreLibrary().getObjectClass();
        Visibility dummyVisibility = Visibility.PUBLIC;
        DynamicObject capturedBlock = this.captureBlock ? RubyArguments.getBlock(frame.getArguments()) : null;
        return new InternalMethod(this.sharedMethodInfo, this.name, dummyModule, dummyVisibility, false, null, this.callTarget, capturedBlock, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeMethod(frame);
    }
}

