/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.validator.metadata.BeanMetaDataImpl;
import org.hibernate.validator.util.Contracts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataCache {
    private final ConcurrentMap<Class<?>, BeanMetaDataImpl<?>> metadataProviders = new ConcurrentHashMap(10);

    public <T> BeanMetaDataImpl<T> getBeanMetaData(Class<T> beanClass) {
        Contracts.assertNotNull(beanClass, "Class cannot be null");
        return (BeanMetaDataImpl)this.metadataProviders.get(beanClass);
    }

    public <T> BeanMetaDataImpl<T> addBeanMetaData(Class<T> beanClass, BeanMetaDataImpl<T> metaData) {
        Contracts.assertNotNull(beanClass, "Class cannot be null");
        Contracts.assertNotNull(metaData, "MetaData cannot be null");
        return this.metadataProviders.putIfAbsent(beanClass, metaData);
    }
}

