/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;

public class CountingWritableByteChannel
implements WritableByteChannel {
    private long written = 0L;
    private WritableByteChannel wrapped;

    public CountingWritableByteChannel(WritableByteChannel wrapped) {
        RequireUtils.requireNotNullArg(wrapped, "Cannot decorate a null instance");
        this.wrapped = wrapped;
    }

    public long count() {
        return this.written;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int count = this.wrapped.write(src);
        this.written += (long)count;
        return count;
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.wrapped);
    }

    public static CountingWritableByteChannel from(WritableByteChannel channel) {
        return new CountingWritableByteChannel(channel);
    }

    public static CountingWritableByteChannel from(OutputStream stream) {
        return new CountingWritableByteChannel(Channels.newChannel(stream));
    }

    public static CountingWritableByteChannel from(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.setLength(0L);
        return new CountingWritableByteChannel(raf.getChannel());
    }

    public static CountingWritableByteChannel from(String file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.setLength(0L);
        return new CountingWritableByteChannel(raf.getChannel());
    }
}

