/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sejda.io.BaseSeekableSource;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSourceView;
import org.sejda.io.ThreadBoundCopiesSupplier;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMappedSeekableSource
extends BaseSeekableSource {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMappedSeekableSource.class);
    private static final long MB_256 = 0x10000000L;
    private final long pageSize = Long.getLong("org.sejda.io.memory.mapped.page.size", 0x10000000L);
    private List<ByteBuffer> pages = new ArrayList<ByteBuffer>();
    private long position;
    private long size;
    private ThreadBoundCopiesSupplier<MemoryMappedSeekableSource> localCopiesSupplier = new ThreadBoundCopiesSupplier<MemoryMappedSeekableSource>(() -> new MemoryMappedSeekableSource(this));

    public MemoryMappedSeekableSource(File file) throws IOException {
        super(Optional.ofNullable(file).map(File::getAbsolutePath).orElseThrow(() -> new IllegalArgumentException("Input file cannot be null")));
        try (FileChannel channel = new RandomAccessFile(file, "r").getChannel();){
            this.size = channel.size();
            int zeroBasedPagesNumber = (int)(channel.size() / this.pageSize);
            for (int i = 0; i <= zeroBasedPagesNumber; ++i) {
                if (i == zeroBasedPagesNumber) {
                    this.pages.add(i, channel.map(FileChannel.MapMode.READ_ONLY, (long)i * this.pageSize, channel.size() - (long)i * this.pageSize));
                    continue;
                }
                this.pages.add(i, channel.map(FileChannel.MapMode.READ_ONLY, (long)i * this.pageSize, this.pageSize));
            }
            LOG.debug("Created MemoryMappedSeekableSource with " + this.pages.size() + " pages");
        }
    }

    private MemoryMappedSeekableSource(MemoryMappedSeekableSource parent) {
        super(parent.id());
        this.size = parent.size;
        for (ByteBuffer page : parent.pages) {
            this.pages.add(page.duplicate());
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SeekableSource position(long position) {
        RequireUtils.requireArg(position >= 0L, "Cannot set position to a negative value");
        this.position = Math.min(position, this.size);
        return this;
    }

    @Override
    public int read(ByteBuffer dst) {
        this.requireOpen();
        int zeroBasedPagesNumber = (int)(this.position() / this.pageSize);
        ByteBuffer page = this.pages.get(zeroBasedPagesNumber);
        int relativePosition = (int)(this.position() - (long)zeroBasedPagesNumber * this.pageSize);
        if (relativePosition < page.limit()) {
            int readBytes;
            int read = this.readPage(dst, zeroBasedPagesNumber, relativePosition);
            while (dst.hasRemaining() && (readBytes = this.readPage(dst, ++zeroBasedPagesNumber, 0)) != 0) {
                read += readBytes;
            }
            this.position += (long)read;
            return read;
        }
        return -1;
    }

    private int readPage(ByteBuffer dst, int pageNumber, int bufferPosition) {
        if (pageNumber < this.pages.size()) {
            ByteBuffer page = this.pages.get(pageNumber);
            page.position(bufferPosition);
            if (page.hasRemaining()) {
                int toRead = Math.min(dst.remaining(), page.remaining());
                byte[] bufToRead = new byte[toRead];
                page.get(bufToRead);
                dst.put(bufToRead);
                return toRead;
            }
        }
        return 0;
    }

    @Override
    public int read() {
        this.requireOpen();
        int zeroBasedPagesNumber = (int)(this.position() / this.pageSize);
        ByteBuffer page = this.pages.get(zeroBasedPagesNumber);
        int relativePosition = (int)(this.position() - (long)zeroBasedPagesNumber * this.pageSize);
        if (relativePosition < page.limit()) {
            ++this.position;
            return page.get(relativePosition);
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.close(this.localCopiesSupplier);
        this.pages.clear();
    }

    @Override
    public SeekableSource view(long startingPosition, long length) throws IOException {
        this.requireOpen();
        return new SeekableSourceView(this.localCopiesSupplier.get(), startingPosition, length);
    }
}

