/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.util.LinkedList;
import org.GNOME.Accessibility.Application;
import org.GNOME.Accessibility.Desktop;
import org.GNOME.Accessibility.DeviceEventController;
import org.GNOME.Accessibility.Event;
import org.GNOME.Accessibility.EventListener;
import org.GNOME.Accessibility.Registry;
import org.GNOME.Accessibility._RegistryStub;
import org.GNOME.Bonobo.Unknown;
import org.omg.CORBA.portable.ObjectImpl;

public class EventQueueRegistry
extends _RegistryStub {
    Registry registry;
    EventProcessor eventProcessor;
    Thread eventProcessorThread;

    public EventQueueRegistry(Registry registry) {
        if (registry == null) {
            System.err.println("Unable to contact registry");
            this.registry = null;
            this.eventProcessor = null;
            this.eventProcessorThread = null;
            return;
        }
        this.registry = registry;
        this.registry.ref();
        this._set_delegate(((ObjectImpl)registry)._get_delegate());
        this.eventProcessor = new EventProcessor();
        this.eventProcessorThread = new Thread(this.eventProcessor);
        this.eventProcessorThread.start();
    }

    @Override
    public void registerApplication(Application application) {
        if (this.registry != null) {
            this.registry.registerApplication(application);
        }
    }

    @Override
    public void deregisterApplication(Application application) {
        if (this.registry != null) {
            this.registry.deregisterApplication(application);
        }
    }

    @Override
    public void registerGlobalEventListener(EventListener eventListener, String string) {
        if (this.registry != null) {
            this.registry.registerGlobalEventListener(eventListener, string);
        }
    }

    @Override
    public void deregisterGlobalEventListenerAll(EventListener eventListener) {
        if (this.registry != null) {
            this.registry.deregisterGlobalEventListenerAll(eventListener);
        }
    }

    @Override
    public void deregisterGlobalEventListener(EventListener eventListener, String string) {
        if (this.registry != null) {
            this.registry.deregisterGlobalEventListener(eventListener, string);
        }
    }

    @Override
    public short getDesktopCount() {
        if (this.registry != null) {
            return this.registry.getDesktopCount();
        }
        return 0;
    }

    @Override
    public Desktop getDesktop(short s) {
        if (this.registry != null) {
            return this.registry.getDesktop(s);
        }
        return null;
    }

    @Override
    public Desktop[] getDesktopList() {
        if (this.registry != null) {
            return this.registry.getDesktopList();
        }
        return null;
    }

    @Override
    public DeviceEventController getDeviceEventController() {
        if (this.registry != null) {
            return this.registry.getDeviceEventController();
        }
        return null;
    }

    @Override
    public void unImplemented() {
        if (this.registry != null) {
            this.registry.unImplemented();
        }
    }

    @Override
    public void unImplemented2() {
        if (this.registry != null) {
            this.registry.unImplemented2();
        }
    }

    @Override
    public void notifyEvent(Event event) {
        if (this.eventProcessor != null) {
            this.eventProcessor.postEvent(event);
        }
    }

    @Override
    public void ref() {
        if (this.registry != null) {
            this.registry.ref();
        }
    }

    @Override
    public void unref() {
        if (this.registry != null) {
            this.registry.unref();
        }
    }

    @Override
    public Unknown queryInterface(String string) {
        if (this.registry != null) {
            return this.registry.queryInterface(string);
        }
        return null;
    }

    class EventProcessor
    implements Runnable {
        LinkedList eventList = new LinkedList();

        EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (this.numEvents() == 0) {
                    try {
                        EventProcessor eventProcessor = this;
                        synchronized (eventProcessor) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.processEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int numEvents() {
            int n;
            LinkedList linkedList = this.eventList;
            synchronized (linkedList) {
                n = this.eventList.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postEvent(Event event) {
            Object object = this.eventList;
            synchronized (object) {
                this.eventList.addLast(event);
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processEvent() {
            try {
                Event event;
                LinkedList linkedList = this.eventList;
                synchronized (linkedList) {
                    event = (Event)this.eventList.removeFirst();
                }
                if (EventQueueRegistry.this.registry != null) {
                    EventQueueRegistry.this.registry.notifyEvent(event);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("processEvent : Exception Caught : " + exception.toString());
            }
        }
    }
}

