/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class LoggingProtocolSocketFactory
extends SSLSocketFactory {
    private SSLContext m_aSSLContext;

    LoggingProtocolSocketFactory() {
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return new LogSocket(((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(address, port));
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new LogSocket(((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(address, port, localAddress, localPort));
    }

    public Socket createSocket(String sHost, int nPort, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return new LogSocket(((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(sHost, nPort, clientHost, clientPort));
    }

    public Socket createSocket(String sHost, int nPort) throws IOException, UnknownHostException {
        return new LogSocket(((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(sHost, nPort));
    }

    public Socket createSocket(Socket aSocket, String sHost, int nPort, boolean bAutoClose) throws IOException {
        return new LogSocket(((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(aSocket, sHost, nPort, bAutoClose));
    }

    public String[] getDefaultCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getSupportedCipherSuites();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(LoggingProtocolSocketFactory.class);
    }

    public int hashCode() {
        return LoggingProtocolSocketFactory.class.hashCode();
    }

    private static class LogSocket
    extends SSLSocket {
        private SSLSocket m_Socket;

        public LogSocket(Socket socket) {
            this.m_Socket = (SSLSocket)socket;
        }

        public OutputStream getOutputStream() throws IOException {
            return new LogStream(this.m_Socket.getOutputStream());
        }

        public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
            this.m_Socket.addHandshakeCompletedListener(listener);
        }

        public String[] getEnabledCipherSuites() {
            return this.m_Socket.getEnabledCipherSuites();
        }

        public String[] getEnabledProtocols() {
            return this.m_Socket.getEnabledProtocols();
        }

        public boolean getEnableSessionCreation() {
            return this.m_Socket.getEnableSessionCreation();
        }

        public boolean getNeedClientAuth() {
            return this.m_Socket.getNeedClientAuth();
        }

        public SSLSession getSession() {
            return this.m_Socket.getSession();
        }

        public SSLParameters getSSLParameters() {
            return this.m_Socket.getSSLParameters();
        }

        public String[] getSupportedCipherSuites() {
            return this.m_Socket.getSupportedCipherSuites();
        }

        public String[] getSupportedProtocols() {
            return this.m_Socket.getSupportedProtocols();
        }

        public boolean getUseClientMode() {
            return this.m_Socket.getUseClientMode();
        }

        public boolean getWantClientAuth() {
            return this.m_Socket.getWantClientAuth();
        }

        public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
            this.m_Socket.removeHandshakeCompletedListener(listener);
        }

        public void setEnabledCipherSuites(String[] suites) {
            this.m_Socket.setEnabledCipherSuites(suites);
        }

        public void setEnabledProtocols(String[] protocols) {
            this.m_Socket.setEnabledProtocols(protocols);
        }

        public void setEnableSessionCreation(boolean flag) {
            this.m_Socket.setEnableSessionCreation(flag);
        }

        public void setNeedClientAuth(boolean need) {
            this.m_Socket.setNeedClientAuth(need);
        }

        public void setSSLParameters(SSLParameters params) {
            this.m_Socket.setSSLParameters(params);
        }

        public void setUseClientMode(boolean mode) {
            this.m_Socket.setUseClientMode(mode);
        }

        public void setWantClientAuth(boolean want) {
            this.m_Socket.setWantClientAuth(want);
        }

        public void startHandshake() throws IOException {
            this.m_Socket.startHandshake();
        }

        public void bind(SocketAddress bindpoint) throws IOException {
            this.m_Socket.bind(bindpoint);
        }

        public void close() throws IOException {
            this.m_Socket.close();
        }

        public void connect(SocketAddress endpoint) throws IOException {
            this.m_Socket.connect(endpoint);
        }

        public void connect(SocketAddress endpoint, int timeout) throws IOException {
            this.m_Socket.connect(endpoint, timeout);
        }

        public SocketChannel getChannel() {
            return this.m_Socket.getChannel();
        }

        public InetAddress getInetAddress() {
            return this.m_Socket.getInetAddress();
        }

        public InputStream getInputStream() throws IOException {
            return this.m_Socket.getInputStream();
        }

        public boolean getKeepAlive() throws SocketException {
            return this.m_Socket.getKeepAlive();
        }

        public InetAddress getLocalAddress() {
            return this.m_Socket.getLocalAddress();
        }

        public int getLocalPort() {
            return this.m_Socket.getLocalPort();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.m_Socket.getLocalSocketAddress();
        }

        public boolean getOOBInline() throws SocketException {
            return this.m_Socket.getOOBInline();
        }

        public int getPort() {
            return this.m_Socket.getPort();
        }

        public int getReceiveBufferSize() throws SocketException {
            return this.m_Socket.getReceiveBufferSize();
        }

        public SocketAddress getRemoteSocketAddress() {
            return this.m_Socket.getRemoteSocketAddress();
        }

        public boolean getReuseAddress() throws SocketException {
            return this.m_Socket.getReuseAddress();
        }

        public int getSendBufferSize() throws SocketException {
            return this.m_Socket.getSendBufferSize();
        }

        public int getSoLinger() throws SocketException {
            return this.m_Socket.getSoLinger();
        }

        public int getSoTimeout() throws SocketException {
            return this.m_Socket.getSoTimeout();
        }

        public boolean getTcpNoDelay() throws SocketException {
            return this.m_Socket.getTcpNoDelay();
        }

        public int getTrafficClass() throws SocketException {
            return this.m_Socket.getTrafficClass();
        }

        public boolean isBound() {
            return this.m_Socket.isBound();
        }

        public boolean isClosed() {
            return this.m_Socket.isClosed();
        }

        public boolean isConnected() {
            return this.m_Socket.isConnected();
        }

        public boolean isInputShutdown() {
            return this.m_Socket.isInputShutdown();
        }

        public boolean isOutputShutdown() {
            return this.m_Socket.isOutputShutdown();
        }

        public void sendUrgentData(int data) throws IOException {
            this.m_Socket.sendUrgentData(data);
        }

        public void setKeepAlive(boolean on) throws SocketException {
            this.m_Socket.setKeepAlive(on);
        }

        public void setOOBInline(boolean on) throws SocketException {
            this.m_Socket.setOOBInline(on);
        }

        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.m_Socket.setPerformancePreferences(connectionTime, latency, bandwidth);
        }

        public void setReceiveBufferSize(int size) throws SocketException {
            this.m_Socket.setReceiveBufferSize(size);
        }

        public void setReuseAddress(boolean on) throws SocketException {
            this.m_Socket.setReuseAddress(on);
        }

        public void setSendBufferSize(int size) throws SocketException {
            this.m_Socket.setSendBufferSize(size);
        }

        public void setSoLinger(boolean on, int linger) throws SocketException {
            this.m_Socket.setSoLinger(on, linger);
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.m_Socket.setSoTimeout(timeout);
        }

        public void setTcpNoDelay(boolean on) throws SocketException {
            this.m_Socket.setTcpNoDelay(on);
        }

        public void setTrafficClass(int tc) throws SocketException {
            this.m_Socket.setTrafficClass(tc);
        }

        public void shutdownInput() throws IOException {
            this.m_Socket.shutdownInput();
        }

        public void shutdownOutput() throws IOException {
            this.m_Socket.shutdownOutput();
        }

        public String toString() {
            return this.m_Socket.toString();
        }

        private static class LogStream
        extends FilterOutputStream {
            public LogStream(OutputStream stream) {
                super(stream);
            }

            public void write(byte[] buf, int offset, int len) throws IOException {
                System.err.println("LogStream.write: \"" + new String(buf, offset, len, "UTF-8") + "\"");
                this.out.write(buf, offset, len);
            }
        }
    }
}

