/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.SectionLayoutController;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.layoutprocessor.OfficeRepeatingStructureLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.VariablesCollection;
import org.libreoffice.report.pentaho.model.OfficeGroup;
import org.libreoffice.report.pentaho.model.OfficeGroupSection;

public class OfficeGroupLayoutController
extends SectionLayoutController
implements OfficeRepeatingStructureLayoutController {
    private static final int STATE_PROCESS_REPEATING_HEADER = 0;
    private static final int STATE_PROCESS_REPEATING_FOOTER = 1;
    public static final int STATE_PROCESS_NORMAL_FLOW = 3;
    private boolean waitForJoin;
    private int state;
    private VariablesCollection variablesCollection;
    private boolean repeatHeader;
    private boolean repeatFooter;

    public void initialize(Object node, FlowController flowController, LayoutController parent) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        super.initialize(node, flowController, parent);
        this.state = 0;
        this.variablesCollection = new VariablesCollection(this.computeVariablesPrefix());
        OfficeGroup group = (OfficeGroup)this.getElement();
        OfficeGroupSection header = group.getHeader();
        this.repeatHeader = header != null && header.isRepeatSection();
        OfficeGroupSection footer = group.getFooter();
        this.repeatFooter = footer != null && footer.isRepeatSection();
    }

    protected LayoutController processContent(ReportTarget target) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        if (this.state == 0) {
            OfficeGroupLayoutController controller = (OfficeGroupLayoutController)this.clone();
            controller.state = 1;
            if (!this.repeatHeader) {
                return controller;
            }
            OfficeGroup group = (OfficeGroup)this.getElement();
            OfficeGroupSection header = group.getHeader();
            controller.waitForJoin = true;
            return this.processChild(controller, header, this.getFlowController());
        }
        if (this.state == 1) {
            OfficeGroupLayoutController controller = (OfficeGroupLayoutController)this.clone();
            controller.state = 3;
            if (!this.repeatFooter) {
                return controller;
            }
            OfficeGroup group = (OfficeGroup)this.getElement();
            OfficeGroupSection footer = group.getFooter();
            controller.waitForJoin = true;
            return this.processChild(controller, footer, this.getFlowController());
        }
        return super.processContent(target);
    }

    public LayoutController join(FlowController flowController) {
        if (this.waitForJoin) {
            OfficeGroupLayoutController derived = (OfficeGroupLayoutController)this.clone();
            derived.setProcessingState(1);
            derived.setFlowController(flowController);
            derived.waitForJoin = false;
            return derived;
        }
        return super.join(flowController);
    }

    public boolean isNormalFlowProcessing() {
        return this.state == 3;
    }

    private String computeVariablesPrefix() {
        int count = 0;
        for (LayoutController lc = this; lc != null; lc = lc.getParent()) {
            if (!(lc instanceof OfficeGroupLayoutController)) continue;
            ++count;
        }
        return "auto_group_" + count + "_";
    }

    public VariablesCollection getVariablesCollection() {
        return this.variablesCollection;
    }

    protected AttributeMap computeAttributes(FlowController fc, Element element, ReportTarget target) throws DataSourceException {
        AttributeMap map = new AttributeMap(super.computeAttributes(fc, element, target));
        String value = String.valueOf(this.repeatHeader || this.repeatFooter);
        map.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "repeating-header-or-footer", (Object)value);
        map.makeReadOnly();
        return map;
    }
}

