/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns.bitext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.bitext.StringPair;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.bitext.IncorrectBitextExample;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleHandler;
import org.languagetool.rules.patterns.bitext.BitextPatternRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class BitextPatternRuleHandler
extends PatternRuleHandler {
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String SRC_EXAMPLE = "srcExample";
    private static final String TRG_EXAMPLE = "trgExample";
    private final List<BitextPatternRule> rules = new ArrayList<BitextPatternRule>();
    private PatternRule srcRule;
    private PatternRule trgRule;
    private IncorrectExample trgExample;
    private IncorrectExample srcExample;
    private Language srcLang;
    private List<StringPair> correctExamples = new ArrayList<StringPair>();
    private List<IncorrectBitextExample> incorrectExamples = new ArrayList<IncorrectBitextExample>();

    BitextPatternRuleHandler() {
    }

    List<BitextPatternRule> getBitextRules() {
        return this.rules;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        switch (qName) {
            case "rules": {
                String languageStr = attrs.getValue("targetLang");
                this.language = Languages.getLanguageForShortName(languageStr);
                break;
            }
            case "rule": {
                super.startElement(namespaceURI, lName, qName, attrs);
                this.correctExamples = new ArrayList<StringPair>();
                this.incorrectExamples = new ArrayList<IncorrectBitextExample>();
                break;
            }
            case "target": {
                this.startPattern(attrs);
                break;
            }
            case "source": {
                this.srcLang = Languages.getLanguageForShortName(attrs.getValue("lang"));
                break;
            }
            default: {
                super.startElement(namespaceURI, lName, qName, attrs);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        switch (qName) {
            case "rule": {
                this.trgRule.setMessage(this.message.toString());
                for (Match m : this.suggestionMatches) {
                    this.trgRule.addSuggestionMatch(m);
                }
                if (this.phrasePatternTokens.size() <= 1) {
                    this.suggestionMatches.clear();
                }
                BitextPatternRule bRule = new BitextPatternRule(this.srcRule, this.trgRule);
                bRule.setCorrectBitextExamples(this.correctExamples);
                bRule.setIncorrectBitextExamples(this.incorrectExamples);
                bRule.setSourceLanguage(this.srcLang);
                this.rules.add(bRule);
                break;
            }
            case "srcExample": {
                this.srcExample = this.setExample();
                break;
            }
            case "trgExample": {
                this.trgExample = this.setExample();
                break;
            }
            case "source": {
                this.srcRule = this.finalizeRule();
                break;
            }
            case "target": {
                this.trgRule = this.finalizeRule();
                break;
            }
            case "example": {
                if (this.inCorrectExample) {
                    this.correctExamples.add(new StringPair(this.srcExample.getExample(), this.trgExample.getExample()));
                } else if (this.inIncorrectExample) {
                    StringPair examplePair = new StringPair(this.srcExample.getExample(), this.trgExample.getExample());
                    if (this.trgExample.getCorrections() == null) {
                        this.incorrectExamples.add(new IncorrectBitextExample(examplePair));
                    } else {
                        List<String> corrections = this.trgExample.getCorrections();
                        this.incorrectExamples.add(new IncorrectBitextExample(examplePair, corrections));
                    }
                }
                this.inCorrectExample = false;
                this.inIncorrectExample = false;
                break;
            }
            default: {
                super.endElement(namespaceURI, sName, qName);
            }
        }
    }

    private IncorrectExample setExample() {
        IncorrectExample example = null;
        if (this.inCorrectExample) {
            example = new IncorrectExample(this.correctExample.toString());
        } else if (this.inIncorrectExample) {
            String[] corrections = this.exampleCorrection.toString().split("\\|");
            example = corrections.length > 0 && corrections[0].length() > 0 ? new IncorrectExample(this.incorrectExample.toString(), Arrays.asList(corrections)) : new IncorrectExample(this.incorrectExample.toString());
        }
        this.correctExample = new StringBuilder();
        this.incorrectExample = new StringBuilder();
        this.exampleCorrection = new StringBuilder();
        return example;
    }

    private PatternRule finalizeRule() {
        PatternRule rule = null;
        if (this.phrasePatternTokens.isEmpty()) {
            rule = new PatternRule(this.id, this.language, this.patternTokens, this.name, "", this.shortMessage.toString());
            this.prepareRule(rule);
        } else {
            if (!this.patternTokens.isEmpty()) {
                for (List ph : this.phrasePatternTokens) {
                    ph.addAll(new ArrayList(this.patternTokens));
                }
            }
            for (List phrasePatternToken : this.phrasePatternTokens) {
                this.processElement(phrasePatternToken);
                rule = new PatternRule(this.id, this.language, phrasePatternToken, this.name, this.message.toString(), this.shortMessage.toString(), "", this.phrasePatternTokens.size() > 1);
                this.prepareRule(rule);
            }
        }
        this.patternTokens.clear();
        if (this.phrasePatternTokens != null) {
            this.phrasePatternTokens.clear();
        }
        this.startPositionCorrection = 0;
        this.endPositionCorrection = 0;
        return rule;
    }
}

