/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ngrams;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneSingleIndexLanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;
import org.languagetool.rules.ngrams.GoogleToken;

public class ConfusionProbabilityRuleTest {
    private final ConfusionProbabilityRule rule = new FakeRule((LanguageModel)new FakeLanguageModel(), new FakeLanguage());
    private final JLanguageTool lt = new JLanguageTool((Language)new FakeLanguage());

    @Test
    public void testRule() throws IOException {
        this.assertMatch("Their are new ideas to explore.");
        this.assertGood("There are new ideas to explore.");
        this.assertMatch("Why is there car broken again?");
        this.assertGood("Why is their car broken again?");
        this.assertGood("Is this their useful test?");
        this.assertGood("Is this there useful test?");
        FakeRule ruleWithException = new FakeRule((LanguageModel)new FakeLanguageModel(), new FakeLanguage()){

            protected boolean isException(String sentenceText) {
                return sentenceText.contains("Their are");
            }
        };
        this.assertGood("Their are new ideas to explore.", (Rule)ruleWithException);
    }

    @Test
    public void testGetContext() throws IOException {
        List<GoogleToken> tokens = Arrays.asList(new GoogleToken("_START_", 0, 0), new GoogleToken("This", 0, 0), new GoogleToken("is", 0, 0), new GoogleToken("a", 0, 0), new GoogleToken("test", 0, 0));
        GoogleToken token = tokens.get(3);
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 1, 1).toString(), (Matcher)Is.is((Object)"[is, XX, test]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 0, 2).toString(), (Matcher)Is.is((Object)"[XX, test, .]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 2, 0).toString(), (Matcher)Is.is((Object)"[This, is, XX]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 3, 0).toString(), (Matcher)Is.is((Object)"[_START_, This, is, XX]"));
    }

    @Test
    public void testGetContext2() throws IOException {
        List<GoogleToken> tokens = Arrays.asList(new GoogleToken("_START_", 0, 0), new GoogleToken("This", 0, 0), new GoogleToken("is", 0, 0));
        GoogleToken token = tokens.get(2);
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 1, 1).toString(), (Matcher)Is.is((Object)"[This, XX, .]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 2, 1).toString(), (Matcher)Is.is((Object)"[_START_, This, XX, .]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 0, 2).toString(), (Matcher)Is.is((Object)"[XX, ., .]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 2, 0).toString(), (Matcher)Is.is((Object)"[_START_, This, XX]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 3, 0).toString(), (Matcher)Is.is((Object)"[_START_, This, XX]"));
    }

    @Test
    public void testGetContext3() throws IOException {
        List<GoogleToken> tokens = Arrays.asList(new GoogleToken("This", 0, 0));
        GoogleToken token = tokens.get(0);
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 1, 1).toString(), (Matcher)Is.is((Object)"[XX]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 0, 2).toString(), (Matcher)Is.is((Object)"[XX, ., .]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 2, 0).toString(), (Matcher)Is.is((Object)"[XX]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 3, 0).toString(), (Matcher)Is.is((Object)"[XX]"));
    }

    @Test
    public void testGetContext4() throws IOException {
        List<GoogleToken> tokens = Arrays.asList(new GoogleToken("_START_", 0, 0), new GoogleToken("This", 0, 0));
        GoogleToken token = tokens.get(1);
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 1, 1).toString(), (Matcher)Is.is((Object)"[_START_, XX, .]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 0, 2).toString(), (Matcher)Is.is((Object)"[XX, ., .]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 2, 0).toString(), (Matcher)Is.is((Object)"[_START_, XX]"));
        Assert.assertThat((Object)this.rule.getContext(token, tokens, "XX", 3, 0).toString(), (Matcher)Is.is((Object)"[_START_, XX]"));
    }

    private void assertMatch(String input, Rule rule) throws IOException {
        RuleMatch[] matches = rule.match(this.lt.getAnalyzedSentence(input));
        Assert.assertThat((String)("Did not find match in: " + input), (Object)matches.length, (Matcher)Is.is((Object)1));
    }

    private void assertMatch(String input) throws IOException {
        this.assertMatch(input, (Rule)this.rule);
    }

    private void assertGood(String input, Rule rule) throws IOException {
        RuleMatch[] matches = rule.match(this.lt.getAnalyzedSentence(input));
        Assert.assertThat((String)("Got unexpected match in: " + input), (Object)matches.length, (Matcher)Is.is((Object)0));
    }

    private void assertGood(String input) throws IOException {
        this.assertGood(input, (Rule)this.rule);
    }

    private static class FakeRule
    extends ConfusionProbabilityRule {
        private FakeRule(LanguageModel languageModel, Language language) {
            super(JLanguageTool.getMessageBundle(), languageModel, language);
        }
    }

    static class FakeLanguageModel
    extends LuceneSingleIndexLanguageModel {
        static Map<String, Integer> map = new HashMap<String, Integer>();

        FakeLanguageModel() {
            super(3);
            map.put("There are", 10);
            map.put("There are new", 5);
            map.put("Their are", 2);
            map.put("Their are new", 1);
            map.put("Why is", 50);
            map.put("Why is there", 5);
            map.put("Why is their", 5);
            map.put("their car", 11);
            map.put("their car broken", 2);
        }

        public void doValidateDirectory(File topIndexDir) {
        }

        public long getCount(List<String> tokens) {
            Integer count = map.get(String.join((CharSequence)" ", tokens));
            return count == null ? 0L : (long)count.intValue();
        }

        public long getCount(String token1) {
            return this.getCount(Arrays.asList(token1));
        }

        public long getTotalTokenCount() {
            int sum = 0;
            for (int val : map.values()) {
                sum += val;
            }
            return sum;
        }

        public void close() {
        }
    }
}

