/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringUtils;
import org.languagetool.Language;
import org.languagetool.gui.LanguageToolEvent;
import org.languagetool.gui.LanguageToolListener;
import org.languagetool.gui.LanguageToolSupport;
import org.languagetool.gui.RetainLineBreakTransferHandler;
import org.languagetool.gui.RuleLink;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.ContextTools;
import org.languagetool.tools.Tools;

class ResultArea {
    private static final String DEACTIVATE_URL = "http://languagetool.org/deactivate/";
    private static final String REACTIVATE_URL = "http://languagetool.org/reactivate/";
    private static final String LT_ERROR_MARKER_START = "<b><font bgcolor=\"#d7d7ff\">";
    private static final String SPELL_ERROR_MARKER_START = "<b><font bgcolor=\"#ffd7d7\">";
    private final ResourceBundle messages;
    private final JTextPane statusPane;
    private final LanguageToolSupport ltSupport;
    private final Object marker = new Object();
    private String inputText;
    private String startText;
    private List<RuleMatch> allRuleMatches;
    private List<RuleMatch> ruleMatches;
    private long runTime;

    ResultArea(final ResourceBundle messages, final LanguageToolSupport ltSupport, final JTextPane statusPane) {
        this.messages = messages;
        this.ltSupport = ltSupport;
        this.statusPane = statusPane;
        statusPane.setContentType("text/html");
        statusPane.setText("<font face='Arial,Helvetica' color='#666666'>" + messages.getString("resultAreaText") + "</font>");
        statusPane.setEditable(false);
        statusPane.addHyperlinkListener(new MyHyperlinkListener());
        statusPane.setTransferHandler(new RetainLineBreakTransferHandler());
        ltSupport.addLanguageToolListener(new LanguageToolListener(){

            @Override
            public void languageToolEventOccurred(LanguageToolEvent event) {
                if (event.getType() == LanguageToolEvent.Type.CHECKING_STARTED) {
                    Language lang = ltSupport.getLanguage();
                    String langName = lang.isExternal() ? lang.getTranslatedName(messages) + " (ext.)" : lang.getTranslatedName(messages);
                    String startCheckText = "<font face='Arial,Helvetica' color='#666666'>" + Tools.i18n(messages, "startChecking", langName) + "..." + "</font>";
                    statusPane.setText(startCheckText);
                    ResultArea.this.setStartText(startCheckText);
                    if (event.getCaller() == ResultArea.this.marker) {
                        statusPane.setCursor(Cursor.getPredefinedCursor(3));
                    }
                } else if (event.getType() == LanguageToolEvent.Type.CHECKING_FINISHED) {
                    ResultArea.this.inputText = event.getSource().getTextComponent().getText();
                    ResultArea.this.setRuleMatches(event.getSource().getMatches());
                    if (event.getCaller() == ResultArea.this.marker || event.getCaller() == null) {
                        ResultArea.this.displayResult();
                        if (event.getCaller() == ResultArea.this.marker) {
                            statusPane.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                } else if (event.getType() == LanguageToolEvent.Type.RULE_DISABLED || event.getType() == LanguageToolEvent.Type.RULE_ENABLED) {
                    ResultArea.this.inputText = event.getSource().getTextComponent().getText();
                    ResultArea.this.setRuleMatches(event.getSource().getMatches());
                    ResultArea.this.displayResult();
                }
            }
        });
    }

    private String getRuleMatchHtml(List<RuleMatch> ruleMatches, String text, String startCheckText) {
        ContextTools contextTools = new ContextTools();
        StringBuilder sb = new StringBuilder(200);
        sb.append(startCheckText);
        sb.append("<br>\n");
        int i = 0;
        for (RuleMatch match : ruleMatches) {
            String output = Tools.i18n(this.messages, "result1", i + 1, match.getLine() + 1, match.getColumn());
            sb.append(output);
            String msg = match.getMessage().replaceAll("<suggestion>", "<b>").replaceAll("</suggestion>", "</b>").replaceAll("<old>", "<b>").replaceAll("</old>", "</b>");
            sb.append("<b>").append(this.messages.getString("errorMessage")).append("</b> ");
            sb.append(msg);
            RuleLink ruleLink = RuleLink.buildDeactivationLink(match.getRule());
            sb.append(" <a href=\"").append(ruleLink).append("\">").append(this.messages.getString("deactivateRule")).append("</a><br>\n");
            if (match.getSuggestedReplacements().size() > 0) {
                String replacement = String.join((CharSequence)"; ", match.getSuggestedReplacements());
                sb.append("<b>").append(this.messages.getString("correctionMessage")).append("</b> ").append(replacement).append("<br>\n");
            }
            if (ITSIssueType.Misspelling.equals((Object)match.getRule().getLocQualityIssueType())) {
                contextTools.setErrorMarkerStart(SPELL_ERROR_MARKER_START);
            } else {
                contextTools.setErrorMarkerStart(LT_ERROR_MARKER_START);
            }
            String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text);
            sb.append("<b>").append(this.messages.getString("errorContext")).append("</b> ").append(context);
            sb.append("<br>\n");
            if (match.getRule().getUrl() != null && Desktop.isDesktopSupported()) {
                sb.append("<b>").append(this.messages.getString("moreInfo")).append("</b> <a href=\"");
                String url = match.getRule().getUrl().toString();
                sb.append(url);
                String shortUrl = StringUtils.abbreviate(url, 60);
                sb.append("\">").append(shortUrl).append("</a><br>\n");
            }
            ++i;
        }
        sb.append("<font face='Arial,Helvetica' color='#666666'>");
        sb.append(this.getDisabledRulesHtml());
        String checkDone = Tools.i18n(this.messages, "checkDone", ruleMatches.size(), this.runTime);
        sb.append("<br>\n").append(checkDone);
        sb.append("<br>\n").append(this.messages.getString("makeLanguageToolBetter"));
        sb.append("</font>").append("<br>\n");
        return sb.toString();
    }

    private String getDisabledRulesHtml() {
        StringBuilder sb = new StringBuilder(40);
        sb.append(this.messages.getString("deactivatedRulesText"));
        int i = 0;
        int deactivatedRuleCount = 0;
        for (String ruleId : this.ltSupport.getConfig().getDisabledRuleIds()) {
            Rule rule;
            if (ruleId.trim().isEmpty() || (rule = this.ltSupport.getRuleForId(ruleId)) == null || rule.isDefaultOff()) continue;
            if (i++ > 0) {
                sb.append(',');
            }
            RuleLink reactivationLink = RuleLink.buildReactivationLink(rule);
            sb.append(" <a href=\"").append(reactivationLink).append("\">").append(rule.getDescription()).append("</a>");
            ++deactivatedRuleCount;
        }
        sb.append("<br>");
        if (deactivatedRuleCount == 0) {
            return "";
        }
        return sb.toString();
    }

    private void setStartText(String startText) {
        this.startText = startText;
    }

    void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    void setRuleMatches(List<RuleMatch> ruleMatches) {
        this.allRuleMatches = new ArrayList<RuleMatch>(ruleMatches);
        this.ruleMatches = new ArrayList<RuleMatch>(ruleMatches);
    }

    void displayResult() {
        this.ruleMatches = this.filterRuleMatches();
        String ruleMatchHtml = this.getRuleMatchHtml(this.ruleMatches, this.inputText, this.startText);
        this.displayText(ruleMatchHtml);
    }

    private void displayText(String text) {
        this.statusPane.setText("<font face='Arial,Helvetica'>" + text + "</font>");
        this.statusPane.setCaretPosition(0);
    }

    private List<RuleMatch> filterRuleMatches() {
        ArrayList<RuleMatch> filtered = new ArrayList<RuleMatch>();
        Set<String> disabledRuleIds = this.ltSupport.getConfig().getDisabledRuleIds();
        for (RuleMatch ruleMatch : this.allRuleMatches) {
            if (disabledRuleIds.contains(ruleMatch.getRule().getId())) continue;
            filtered.add(ruleMatch);
        }
        return filtered;
    }

    private class MyHyperlinkListener
    implements HyperlinkListener {
        private MyHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                URL url = e.getURL();
                try {
                    String uri = url.toURI().toString();
                    if (uri.startsWith(ResultArea.DEACTIVATE_URL) || uri.startsWith(ResultArea.REACTIVATE_URL)) {
                        this.handleRuleLinkClick(uri);
                    } else {
                        this.handleHttpClick(url);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Could not handle URL click: " + url, ex);
                }
            }
        }

        private void handleRuleLinkClick(String uri) throws IOException {
            RuleLink ruleLink = RuleLink.getFromString(uri);
            String ruleId = ruleLink.getId();
            if (uri.startsWith(ResultArea.DEACTIVATE_URL)) {
                ResultArea.this.ltSupport.disableRule(ruleId);
            } else {
                ResultArea.this.ltSupport.enableRule(ruleId);
            }
            ResultArea.this.ltSupport.getConfig().saveConfiguration(ResultArea.this.ltSupport.getLanguage());
            ResultArea.this.ltSupport.checkImmediately(ResultArea.this.marker);
        }

        private void handleHttpClick(URL url) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    desktop.browse(url.toURI());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Could not open URL: " + url, ex);
                }
            }
        }
    }
}

