/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.jar.Manifest;
import morfologik.tools.FSABuildTool;
import morfologik.tools.FSADumpTool;
import morfologik.tools.MorphEncodingTool;
import morfologik.tools.PolishStemmingTool;
import morfologik.tools.Tool;
import morfologik.util.FileUtils;

public final class Launcher {
    public static void main(String[] args) throws Exception {
        TreeMap<String, ToolInfo> tools = Launcher.initTools();
        if (tools == null) {
            return;
        }
        if (args.length == 0) {
            System.out.println("Provide tool name and its command-line options. Available tools:");
            for (String key : tools.keySet()) {
                ToolInfo toolInfo = tools.get(key);
                System.out.println(String.format("  %-10s - %s", key, toolInfo.info));
            }
        } else {
            String toolName = args[0];
            if (!tools.containsKey(toolName)) {
                System.out.println("Unknown tool: " + toolName);
                return;
            }
            String[] subArgs = new String[args.length - 1];
            System.arraycopy(args, 1, subArgs, 0, subArgs.length);
            ToolInfo toolInfo = tools.get(toolName);
            toolInfo.invoke(subArgs);
        }
    }

    static TreeMap<String, ToolInfo> initTools() {
        TreeMap<String, ToolInfo> tools = new TreeMap<String, ToolInfo>();
        tools.put("fsa_build", new ToolInfo(FSABuildTool.class, "Create an automaton from plain text files."));
        tools.put("fsa_dump", new ToolInfo(FSADumpTool.class, "Dump an FSA dictionary."));
        tools.put("tab2morph", new ToolInfo(MorphEncodingTool.class, "Convert tabbed dictionary to fsa encoding format."));
        tools.put("plstem", new ToolInfo(PolishStemmingTool.class, "Apply Polish dictionary stemming to the input."));
        for (ToolInfo ti : tools.values()) {
            try {
                ti.clazz.newInstance().isAvailable();
            }
            catch (NoClassDefFoundError e) {
                Launcher.logJarWarning();
                return null;
            }
            catch (Throwable e) {
                System.out.println("Tools could not be initialized because of an exception during initialization: " + e.getClass().getName() + ", " + e.getMessage());
                return null;
            }
        }
        return tools;
    }

    private static void logJarWarning() {
        System.out.println("Tools are unavailable, at least one JAR dependency missing.");
        try {
            Class<Launcher> clazz = Launcher.class;
            ClassLoader classLoader = clazz.getClassLoader();
            String clazzName = clazz.getName().replace('.', '/') + ".class";
            URL launcherLocation = classLoader.getResource(clazzName);
            if (launcherLocation == null) {
                return;
            }
            String launcherPrefix = launcherLocation.toString().replace(clazzName, "");
            URL manifestResource = null;
            Enumeration<URL> manifests = classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL candidate = manifests.nextElement();
                if (!candidate.toString().startsWith(launcherPrefix)) continue;
                manifestResource = candidate;
                break;
            }
            if (manifestResource == null) {
                return;
            }
            InputStream stream = null;
            try {
                stream = manifestResource.openStream();
                Manifest manifest = new Manifest(stream);
                System.out.println("Required JARs: " + manifest.getMainAttributes().getValue("Class-Path"));
            }
            catch (IOException e) {
                FileUtils.close((Closeable[])new Closeable[]{stream});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static final class ToolInfo {
        public final Class<? extends Tool> clazz;
        public final String info;

        public ToolInfo(Class<? extends Tool> clazz, String info) {
            this.clazz = clazz;
            this.info = info;
        }

        public void invoke(String[] subArgs) throws Exception {
            Method m = this.clazz.getMethod("main", String[].class);
            m.invoke(null, new Object[]{subArgs});
        }
    }
}

