/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.nio.file.Path;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.EnvironmentModule;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNameModule;
import org.elasticsearch.index.analysis.AnalysisModule;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettingsModule;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.elasticsearch.indices.mapper.MapperRegistry;

public class MapperTestUtils {
    public static MapperService newMapperService(Path tempDir, Settings indexSettings) {
        IndicesModule indicesModule = new IndicesModule();
        return MapperTestUtils.newMapperService(tempDir, indexSettings, indicesModule);
    }

    public static MapperService newMapperService(Path tempDir, Settings indexSettings, IndicesModule indicesModule) {
        Settings.Builder settingsBuilder = Settings.builder().put("path.home", tempDir).put(indexSettings);
        if (indexSettings.get("index.version.created") == null) {
            settingsBuilder.put("index.version.created", Version.CURRENT);
        }
        Settings settings = settingsBuilder.build();
        MapperRegistry mapperRegistry = indicesModule.getMapperRegistry();
        return new MapperService(new Index("test"), settings, MapperTestUtils.newAnalysisService(settings), MapperTestUtils.newSimilarityLookupService(settings), null, mapperRegistry);
    }

    private static AnalysisService newAnalysisService(Settings indexSettings) {
        Injector parentInjector = new ModulesBuilder().add(new SettingsModule(indexSettings), new EnvironmentModule(new Environment(indexSettings))).createInjector();
        Index index = new Index("test");
        Injector injector = new ModulesBuilder().add(new IndexSettingsModule(index, indexSettings), new IndexNameModule(index), new AnalysisModule(indexSettings, parentInjector.getInstance(IndicesAnalysisService.class))).createChildInjector(parentInjector);
        return injector.getInstance(AnalysisService.class);
    }

    private static SimilarityLookupService newSimilarityLookupService(Settings indexSettings) {
        return new SimilarityLookupService(new Index("test"), indexSettings);
    }
}

