/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptedMetricAggregator
extends MetricsAggregator {
    private final SearchScript mapScript;
    private final ExecutableScript combineScript;
    private final Script reduceScript;
    private Map<String, Object> params;

    protected ScriptedMetricAggregator(String name, Script initScript, Script mapScript, Script combineScript, Script reduceScript, Map<String, Object> params, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.params = params;
        ScriptService scriptService = context.searchContext().scriptService();
        if (initScript != null) {
            scriptService.executable(initScript, ScriptContext.Standard.AGGS, context.searchContext()).run();
        }
        this.mapScript = scriptService.search(context.searchContext().lookup(), mapScript, ScriptContext.Standard.AGGS);
        this.combineScript = combineScript != null ? scriptService.executable(combineScript, ScriptContext.Standard.AGGS, context.searchContext()) : null;
        this.reduceScript = reduceScript;
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final LeafSearchScript leafMapScript = this.mapScript.getLeafSearchScript(ctx);
        return new LeafBucketCollectorBase(sub, this.mapScript){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L) : bucket;
                leafMapScript.setDocument(doc);
                leafMapScript.run();
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        Object aggregation = this.combineScript != null ? this.combineScript.run() : this.params.get("_agg");
        return new InternalScriptedMetric(this.name, aggregation, this.reduceScript, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalScriptedMetric(this.name, null, this.reduceScript, this.pipelineAggregators(), this.metaData());
    }

    public static class Factory
    extends AggregatorFactory {
        private Script initScript;
        private Script mapScript;
        private Script combineScript;
        private Script reduceScript;
        private Map<String, Object> params;

        public Factory(String name, Script initScript, Script mapScript, Script combineScript, Script reduceScript, Map<String, Object> params) {
            super(name, InternalScriptedMetric.TYPE.name());
            this.initScript = initScript;
            this.mapScript = mapScript;
            this.combineScript = combineScript;
            this.reduceScript = reduceScript;
            this.params = params;
        }

        @Override
        public Aggregator createInternal(AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            if (!collectsFromSingleBucket) {
                return Factory.asMultiBucketAggregator(this, context, parent);
            }
            Map<String, Object> params = this.params;
            if (params != null) {
                params = Factory.deepCopyParams(params, context.searchContext());
            } else {
                params = new HashMap<String, Object>();
                params.put("_agg", new HashMap());
            }
            return new ScriptedMetricAggregator(this.name, Factory.insertParams(this.initScript, params), Factory.insertParams(this.mapScript, params), Factory.insertParams(this.combineScript, params), Factory.deepCopyScript(this.reduceScript, context.searchContext()), params, context, parent, pipelineAggregators, metaData);
        }

        private static Script insertParams(Script script, Map<String, Object> params) {
            if (script == null) {
                return null;
            }
            return new Script(script.getScript(), script.getType(), script.getLang(), params);
        }

        private static Script deepCopyScript(Script script, SearchContext context) {
            if (script != null) {
                Map<String, Object> params = script.getParams();
                if (params != null) {
                    params = Factory.deepCopyParams(params, context);
                }
                return new Script(script.getScript(), script.getType(), script.getLang(), params);
            }
            return null;
        }

        private static <T> T deepCopyParams(T original, SearchContext context) {
            Object clone;
            if (original instanceof Map) {
                Map originalMap = (Map)original;
                HashMap clonedMap = new HashMap();
                for (Map.Entry e : originalMap.entrySet()) {
                    clonedMap.put(Factory.deepCopyParams(e.getKey(), context), Factory.deepCopyParams(e.getValue(), context));
                }
                clone = clonedMap;
            } else if (original instanceof List) {
                List originalList = (List)original;
                ArrayList clonedList = new ArrayList();
                for (Object o : originalList) {
                    clonedList.add(Factory.deepCopyParams(o, context));
                }
                clone = clonedList;
            } else if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Short || original instanceof Byte || original instanceof Float || original instanceof Double || original instanceof Character || original instanceof Boolean) {
                clone = original;
            } else {
                throw new SearchParseException(context, "Can only clone primitives, String, ArrayList, and HashMap. Found: " + original.getClass().getCanonicalName(), null);
            }
            return clone;
        }
    }
}

