/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.bkdtree3d.BKD3DTreeWriter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.DocIdSetBuilder;

final class BKD3DTreeReader
implements Accountable {
    private final int[] splitValues;
    private final int leafNodeOffset;
    private final long[] leafBlockFPs;
    final int maxDoc;
    final IndexInput in;

    public BKD3DTreeReader(IndexInput in, int maxDoc) throws IOException {
        int i;
        int numLeaves;
        this.leafNodeOffset = numLeaves = in.readVInt();
        this.splitValues = new int[numLeaves];
        for (i = 0; i < numLeaves; ++i) {
            this.splitValues[i] = in.readInt();
        }
        this.leafBlockFPs = new long[numLeaves];
        for (i = 0; i < numLeaves; ++i) {
            this.leafBlockFPs[i] = in.readVLong();
        }
        this.maxDoc = maxDoc;
        this.in = in;
    }

    public DocIdSet intersect(ValueFilter filter) throws IOException {
        return this.intersect(Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, filter);
    }

    public DocIdSet intersect(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, ValueFilter filter) throws IOException {
        QueryState state = new QueryState(this.in.clone(), this.maxDoc, xMin, xMax, yMin, yMax, zMin, zMax, filter);
        int hitCount = this.intersect(state, 1, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        return state.docs.build((long)hitCount);
    }

    private int addAll(QueryState state, int nodeID) throws IOException {
        if (nodeID >= this.leafNodeOffset) {
            long fp = this.leafBlockFPs[nodeID - this.leafNodeOffset];
            state.in.seek(fp);
            int count = state.in.readVInt();
            state.docs.grow(count);
            for (int i = 0; i < count; ++i) {
                int docID = state.in.readInt();
                state.docs.add(docID);
            }
            return count;
        }
        int count = this.addAll(state, 2 * nodeID);
        return count += this.addAll(state, 2 * nodeID + 1);
    }

    private int intersect(QueryState state, int nodeID, int cellXMin, int cellXMax, int cellYMin, int cellYMax, int cellZMin, int cellZMax) throws IOException {
        if (cellXMin >= state.xMin || cellXMax <= state.xMax || cellYMin >= state.yMin || cellYMax <= state.yMax || cellZMin >= state.zMin || cellZMax <= state.zMax) {
            Relation r = state.valueFilter.compare(cellXMin, cellXMax, cellYMin, cellYMax, cellZMin, cellZMax);
            if (r == Relation.SHAPE_OUTSIDE_CELL) {
                return 0;
            }
            if (r == Relation.CELL_INSIDE_SHAPE) {
                return this.addAll(state, nodeID);
            }
        } else assert (state.valueFilter.compare(cellXMin, cellXMax, cellYMin, cellYMax, cellZMin, cellZMax) == Relation.SHAPE_INSIDE_CELL) : "got " + (Object)((Object)state.valueFilter.compare(cellXMin, cellXMax, cellYMin, cellYMax, cellZMin, cellZMax));
        if (nodeID >= this.leafNodeOffset) {
            int hitCount = 0;
            long fp = this.leafBlockFPs[nodeID - this.leafNodeOffset];
            state.in.seek(fp);
            int count = state.in.readVInt();
            state.docs.grow(count);
            for (int i = 0; i < count; ++i) {
                int docID = state.in.readInt();
                if (!state.valueFilter.accept(docID)) continue;
                state.docs.add(docID);
                ++hitCount;
            }
            return hitCount;
        }
        int splitDim = BKD3DTreeWriter.getSplitDim(cellXMin, cellXMax, cellYMin, cellYMax, cellZMin, cellZMax);
        int splitValue = this.splitValues[nodeID];
        int count = 0;
        if (splitDim == 0) {
            if (state.xMin <= splitValue) {
                count += this.intersect(state, 2 * nodeID, cellXMin, splitValue, cellYMin, cellYMax, cellZMin, cellZMax);
            }
            if (state.xMax >= splitValue) {
                count += this.intersect(state, 2 * nodeID + 1, splitValue, cellXMax, cellYMin, cellYMax, cellZMin, cellZMax);
            }
        } else if (splitDim == 1) {
            if (state.yMin <= splitValue) {
                count += this.intersect(state, 2 * nodeID, cellXMin, cellXMax, cellYMin, splitValue, cellZMin, cellZMax);
            }
            if (state.yMax >= splitValue) {
                count += this.intersect(state, 2 * nodeID + 1, cellXMin, cellXMax, splitValue, cellYMax, cellZMin, cellZMax);
            }
        } else {
            if (state.zMin <= splitValue) {
                count += this.intersect(state, 2 * nodeID, cellXMin, cellXMax, cellYMin, cellYMax, cellZMin, splitValue);
            }
            if (state.zMax >= splitValue) {
                count += this.intersect(state, 2 * nodeID + 1, cellXMin, cellXMax, cellYMin, cellYMax, splitValue, cellZMax);
            }
        }
        return count;
    }

    public long ramBytesUsed() {
        return this.splitValues.length * 4 + this.leafBlockFPs.length * 8;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static final class QueryState {
        final IndexInput in;
        byte[] scratch = new byte[16];
        final ByteArrayDataInput scratchReader = new ByteArrayDataInput(this.scratch);
        final DocIdSetBuilder docs;
        final int xMin;
        final int xMax;
        final int yMin;
        final int yMax;
        final int zMin;
        final int zMax;
        final ValueFilter valueFilter;

        public QueryState(IndexInput in, int maxDoc, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, ValueFilter valueFilter) {
            this.in = in;
            this.docs = new DocIdSetBuilder(maxDoc);
            this.xMin = xMin;
            this.xMax = xMax;
            this.yMin = yMin;
            this.yMax = yMax;
            this.zMin = zMin;
            this.zMax = zMax;
            this.valueFilter = valueFilter;
        }
    }

    static interface ValueFilter {
        public boolean accept(int var1);

        public Relation compare(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    static enum Relation {
        CELL_INSIDE_SHAPE,
        SHAPE_CROSSES_CELL,
        SHAPE_OUTSIDE_CELL,
        SHAPE_INSIDE_CELL;

    }
}

