/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.spans.SpanContainQuery;
import org.apache.lucene.search.spans.SpanContainingQuery;
import org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.SpanWithinQuery;
import org.apache.lucene.search.spans.Spans;

public final class SpanBoostQuery
extends SpanQuery {
    private static final Set<Class<? extends SpanQuery>> NO_PARENS_REQUIRED_QUERIES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(SpanTermQuery.class, SpanNearQuery.class, SpanOrQuery.class, SpanFirstQuery.class, SpanContainingQuery.class, SpanContainQuery.class, SpanNotQuery.class, SpanWithinQuery.class)));
    private final SpanQuery query;

    public SpanBoostQuery(SpanQuery query, float boost) {
        this.query = Objects.requireNonNull(query);
        this.setBoost(boost);
    }

    public SpanQuery getQuery() {
        return this.query;
    }

    @Override
    public float getBoost() {
        return super.getBoost();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SpanBoostQuery that = (SpanBoostQuery)obj;
        return this.query.equals(that.query);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 31 * h + this.query.hashCode();
        return h;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewritten = (SpanQuery)this.query.rewrite(reader);
        if (this.getBoost() == 1.0f) {
            return rewritten;
        }
        if (rewritten.getClass() == SpanBoostQuery.class) {
            SpanBoostQuery in = (SpanBoostQuery)rewritten;
            return new SpanBoostQuery(in.query, this.getBoost() * in.getBoost());
        }
        if (this.query != rewritten) {
            return new SpanBoostQuery(rewritten, this.getBoost());
        }
        return this;
    }

    @Override
    public String toString(String field) {
        boolean needsParens = !NO_PARENS_REQUIRED_QUERIES.contains(this.query.getClass());
        StringBuilder builder = new StringBuilder();
        if (needsParens) {
            builder.append("(");
        }
        builder.append(this.query.toString(field));
        if (needsParens) {
            builder.append(")");
        }
        builder.append("^");
        builder.append(this.getBoost());
        return builder.toString();
    }

    @Override
    public String getField() {
        return this.query.getField();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final SpanWeight weight = this.query.createWeight(searcher, needsScores);
        if (!needsScores) {
            return weight;
        }
        TreeMap<Term, TermContext> terms = new TreeMap<Term, TermContext>();
        weight.extractTermContexts(terms);
        weight.normalize(1.0f, this.getBoost());
        return new SpanWeight(this, searcher, terms){

            @Override
            public void extractTerms(Set<Term> terms) {
                weight.extractTerms(terms);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return weight.explain(context, doc);
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return weight.getValueForNormalization();
            }

            @Override
            public void normalize(float norm, float boost) {
                weight.normalize(norm, SpanBoostQuery.this.getBoost() * boost);
            }

            @Override
            public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
                return weight.getSpans(ctx, requiredPostings);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return weight.scorer(context);
            }

            @Override
            public void extractTermContexts(Map<Term, TermContext> contexts) {
                weight.extractTermContexts(contexts);
            }
        };
    }
}

