/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.rhino.worker.internal;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.gradle.internal.UncheckedException;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorker;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoClientWorkerProtocol;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoWorkerClientProtocol;
import org.mozilla.javascript.RhinoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoWorkerReceiver<P extends Serializable>
implements RhinoClientWorkerProtocol<P> {
    private final Class<P> payloadType;
    private final RhinoWorker<?, P> worker;
    private final RhinoWorkerClientProtocol clientHandle;
    private final CountDownLatch latch = new CountDownLatch(1);

    public RhinoWorkerReceiver(Class<P> payloadType, RhinoWorkerClientProtocol clientHandle, RhinoWorker<?, P> worker) {
        this.payloadType = payloadType;
        this.clientHandle = clientHandle;
        this.worker = worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(P payload) {
        if (!this.payloadType.isInstance(payload)) {
            this.clientHandle.initialisationError(new IllegalArgumentException(String.format("Expected payload of type '%s', received '%s' with type '%s'", this.payloadType.getName(), payload, payload.getClass().getName())));
            return;
        }
        try {
            Object result = this.worker.process(payload);
            this.clientHandle.receiveResult((Serializable)result);
        }
        catch (RhinoException e) {
            this.clientHandle.executionError(this.worker.convertException(e));
        }
        catch (Exception e) {
            this.clientHandle.executionError(e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public void waitFor() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

