/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.testkit.jarjar.org.gradle.internal.event.ListenerNotificationException;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ListenerFailedException;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestExecutionException;
import org.gradle.tooling.exceptions.UnsupportedBuildArgumentException;
import org.gradle.tooling.exceptions.UnsupportedOperationConfigurationException;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.ResultHandlerVersion1;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultHandlerAdapter<T>
implements ResultHandlerVersion1<T> {
    private final ResultHandler<? super T> handler;

    protected ResultHandlerAdapter(ResultHandler<? super T> handler) {
        this.handler = handler;
    }

    @Override
    public void onComplete(T result) {
        this.handler.onComplete(result);
    }

    @Override
    public void onFailure(Throwable failure) {
        if (failure instanceof InternalUnsupportedBuildArgumentException) {
            this.handler.onFailure(new UnsupportedBuildArgumentException(this.connectionFailureMessage(failure) + "\n" + failure.getMessage(), failure));
        } else if (failure instanceof UnsupportedOperationConfigurationException) {
            this.handler.onFailure(new UnsupportedOperationConfigurationException(this.connectionFailureMessage(failure) + "\n" + failure.getMessage(), failure.getCause()));
        } else if (failure instanceof GradleConnectionException) {
            this.handler.onFailure((GradleConnectionException)failure);
        } else if (failure instanceof InternalBuildCancelledException) {
            this.handler.onFailure(new BuildCancelledException(this.connectionFailureMessage(failure), failure.getCause()));
        } else if (failure instanceof InternalTestExecutionException) {
            this.handler.onFailure(new TestExecutionException(this.connectionFailureMessage(failure), failure.getCause()));
        } else if (failure instanceof BuildExceptionVersion1) {
            this.handler.onFailure(new BuildException(this.connectionFailureMessage(failure), failure.getCause()));
        } else if (failure instanceof ListenerNotificationException) {
            this.handler.onFailure(new ListenerFailedException(this.connectionFailureMessage(failure), ((ListenerNotificationException)failure).getCauses()));
        } else {
            this.handler.onFailure(new GradleConnectionException(this.connectionFailureMessage(failure), failure));
        }
    }

    protected abstract String connectionFailureMessage(Throwable var1);
}

