/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionValidationException;
import org.gradle.model.Mutate;
import org.gradle.model.internal.inspect.DefaultRuleSourceValidationProblemCollector;
import org.gradle.model.internal.inspect.FormattingValidationProblemCollector;
import org.gradle.model.internal.inspect.ValidationProblemCollector;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSourceBackedRuleAction<R, T>
implements RuleAction<T> {
    private final R instance;
    private final JavaMethod<R, T> ruleMethod;
    private final List<Class<?>> inputTypes;

    private RuleSourceBackedRuleAction(R instance, JavaMethod<R, T> ruleMethod) {
        this.instance = instance;
        this.ruleMethod = ruleMethod;
        this.inputTypes = RuleSourceBackedRuleAction.determineInputTypes(ruleMethod.getParameterTypes());
    }

    public static <R, T> RuleSourceBackedRuleAction<R, T> create(ModelType<T> subjectType, R ruleSourceInstance) {
        ModelType ruleSourceType = ModelType.typeOf(ruleSourceInstance);
        List mutateMethods = JavaReflectionUtil.findAllMethods((Class)ruleSourceType.getConcreteClass(), (Spec)new Spec<Method>(){

            public boolean isSatisfiedBy(Method element) {
                return element.isAnnotationPresent(Mutate.class);
            }
        });
        FormattingValidationProblemCollector problemsFormatter = new FormattingValidationProblemCollector("rule source", ruleSourceType);
        DefaultRuleSourceValidationProblemCollector problems = new DefaultRuleSourceValidationProblemCollector((ValidationProblemCollector)problemsFormatter);
        if (mutateMethods.size() == 0) {
            problems.add("Must have at exactly one method annotated with @" + Mutate.class.getName());
        } else {
            if (mutateMethods.size() > 1) {
                problems.add("More than one method is annotated with @" + Mutate.class.getName());
            }
            for (Method ruleMethod : mutateMethods) {
                Type[] parameterTypes;
                if (ruleMethod.getReturnType() != Void.TYPE) {
                    problems.add(ruleMethod, "A rule method must return void");
                }
                if ((parameterTypes = ruleMethod.getGenericParameterTypes()).length != 0 && subjectType.isAssignableFrom(ModelType.of((Type)parameterTypes[0]))) continue;
                problems.add(ruleMethod, String.format("First parameter of a rule method must be of type %s", subjectType));
            }
        }
        if (problemsFormatter.hasProblems()) {
            throw new RuleActionValidationException(problemsFormatter.format());
        }
        return new RuleSourceBackedRuleAction<R, T>(ruleSourceInstance, new JavaMethod(ruleSourceType.getConcreteClass(), subjectType.getConcreteClass(), (Method)mutateMethods.get(0)));
    }

    public static List<Class<?>> determineInputTypes(Class<?>[] parameterTypes) {
        return Arrays.asList(parameterTypes).subList(1, parameterTypes.length);
    }

    @Override
    public List<Class<?>> getInputTypes() {
        return this.inputTypes;
    }

    @Override
    public void execute(T subject, List<?> inputs) {
        Object[] args = new Object[inputs.size() + 1];
        args[0] = subject;
        for (int i = 0; i < inputs.size(); ++i) {
            Object input = inputs.get(i);
            args[i + 1] = input;
        }
        this.ruleMethod.invoke(this.instance, args);
    }
}

