/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Lists;
import groovy.lang.MissingPropertyException;
import java.util.LinkedList;
import java.util.Map;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.CompositeDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.internal.plugins.ExtraPropertiesDynamicObjectAdapter;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleDynamicObject
extends CompositeDynamicObject
implements HasConvention {
    private final AbstractDynamicObject dynamicDelegate;
    private DynamicObject parent;
    private Convention convention;
    private DynamicObject beforeConvention;
    private DynamicObject afterConvention;
    private DynamicObject extraPropertiesDynamicObject;

    public ExtensibleDynamicObject(Object delegate) {
        this(delegate, (AbstractDynamicObject)new BeanDynamicObject(delegate), new DefaultConvention());
    }

    public ExtensibleDynamicObject(Object delegate, Instantiator instantiator) {
        this(delegate, (AbstractDynamicObject)new BeanDynamicObject(delegate), new DefaultConvention(instantiator));
    }

    public ExtensibleDynamicObject(Object delegate, AbstractDynamicObject dynamicDelegate, Instantiator instantiator) {
        this(delegate, dynamicDelegate, new DefaultConvention(instantiator));
    }

    public ExtensibleDynamicObject(Object delegate, AbstractDynamicObject dynamicDelegate, Convention convention) {
        this.dynamicDelegate = dynamicDelegate;
        this.convention = convention;
        this.extraPropertiesDynamicObject = new ExtraPropertiesDynamicObjectAdapter(delegate.getClass(), convention.getExtraProperties());
        this.updateDelegates();
    }

    private void updateDelegates() {
        LinkedList delegates = Lists.newLinkedList();
        delegates.add(this.dynamicDelegate);
        delegates.add(this.extraPropertiesDynamicObject);
        if (this.beforeConvention != null) {
            delegates.add(this.beforeConvention);
        }
        if (this.convention != null) {
            delegates.add(this.convention.getExtensionsAsDynamicObject());
        }
        if (this.afterConvention != null) {
            delegates.add(this.afterConvention);
        }
        boolean addedParent = false;
        if (this.parent != null) {
            addedParent = true;
            delegates.add(this.parent);
        }
        this.setObjects(delegates.toArray(new DynamicObject[0]));
        if (addedParent) {
            delegates.remove(delegates.size() - 1);
        }
        delegates.add(this.extraPropertiesDynamicObject);
        this.setObjectsForUpdate(delegates.toArray(new DynamicObject[0]));
    }

    @Override
    protected String getDisplayName() {
        return this.dynamicDelegate.getDisplayName();
    }

    public ExtraPropertiesExtension getDynamicProperties() {
        return this.convention.getExtraProperties();
    }

    public void addProperties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.getDynamicProperties().set(entry.getKey(), entry.getValue());
        }
    }

    public DynamicObject getParent() {
        return this.parent;
    }

    public void setParent(DynamicObject parent) {
        this.parent = parent;
        this.updateDelegates();
    }

    @Override
    public Convention getConvention() {
        return this.convention;
    }

    public void addObject(DynamicObject object, Location location) {
        switch (location) {
            case BeforeConvention: {
                this.beforeConvention = object;
                break;
            }
            case AfterConvention: {
                this.afterConvention = object;
            }
        }
        this.updateDelegates();
    }

    public DynamicObject getInheritable() {
        return new InheritedDynamicObject();
    }

    private ExtensibleDynamicObject snapshotInheritable() {
        AbstractDynamicObject emptyBean = new AbstractDynamicObject(){

            protected String getDisplayName() {
                return ExtensibleDynamicObject.this.dynamicDelegate.getDisplayName();
            }
        };
        ExtensibleDynamicObject extensibleDynamicObject = new ExtensibleDynamicObject(emptyBean);
        extensibleDynamicObject.parent = this.parent;
        extensibleDynamicObject.convention = this.convention;
        extensibleDynamicObject.extraPropertiesDynamicObject = this.extraPropertiesDynamicObject;
        if (this.beforeConvention != null) {
            extensibleDynamicObject.beforeConvention = this.beforeConvention;
        }
        extensibleDynamicObject.updateDelegates();
        return extensibleDynamicObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InheritedDynamicObject
    implements DynamicObject {
        private InheritedDynamicObject() {
        }

        @Override
        public void setProperty(String name, Object value) {
            throw new MissingPropertyException(String.format("Could not find property '%s' inherited from %s.", name, ExtensibleDynamicObject.this.dynamicDelegate.getDisplayName()));
        }

        @Override
        public boolean hasProperty(String name) {
            return ExtensibleDynamicObject.this.snapshotInheritable().hasProperty(name);
        }

        @Override
        public Object getProperty(String name) {
            return ExtensibleDynamicObject.this.snapshotInheritable().getProperty(name);
        }

        public Map<String, Object> getProperties() {
            return ExtensibleDynamicObject.this.snapshotInheritable().getProperties();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return ExtensibleDynamicObject.this.snapshotInheritable().hasMethod(name, arguments);
        }

        @Override
        public Object invokeMethod(String name, Object ... arguments) {
            return ExtensibleDynamicObject.this.snapshotInheritable().invokeMethod(name, arguments);
        }

        @Override
        public boolean isMayImplementMissingMethods() {
            return ExtensibleDynamicObject.this.snapshotInheritable().isMayImplementMissingMethods();
        }

        @Override
        public boolean isMayImplementMissingProperties() {
            return ExtensibleDynamicObject.this.snapshotInheritable().isMayImplementMissingProperties();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        BeforeConvention,
        AfterConvention;

    }
}

