/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import org.gradle.internal.progress.ProgressFormatter;

class PercentageProgressFormatter
implements ProgressFormatter {
    private int current;
    private int total;
    private String prefix;

    public PercentageProgressFormatter(String prefix, int total) {
        this.total = total;
        this.prefix = prefix;
    }

    public String incrementAndGetProgress() {
        if (this.current == this.total) {
            throw new IllegalStateException("Cannot increment beyond the total of: " + this.total);
        }
        ++this.current;
        return this.getProgress();
    }

    public String getProgress() {
        return this.prefix + " " + (int)((double)this.current * 100.0 / (double)this.total) + "%";
    }
}

