/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.ObjectMarshaller;
import org.grails.web.json.JSONWriter;

public class InstanceMethodBasedMarshaller
implements ObjectMarshaller<JSON> {
    @Override
    public boolean supports(Object object) {
        return this.getToJSONMethod(object) != null;
    }

    @Override
    public void marshalObject(Object object, JSON converter) throws ConverterException {
        MetaMethod method = this.getToJSONMethod(object);
        try {
            Object result = method.invoke(object, new Object[]{converter});
            if (result != null && !(result instanceof JSON) && !(result instanceof JSONWriter)) {
                converter.convertAnother(result);
            }
        }
        catch (Throwable e) {
            throw e instanceof ConverterException ? (ConverterException)e : new ConverterException("Error invoking toJSON method of object with class " + object.getClass().getName(), e);
        }
    }

    protected MetaMethod getToJSONMethod(Object object) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(object.getClass());
        if (mc != null) {
            return mc.getMetaMethod("toJSON", new Object[]{JSON.class});
        }
        return null;
    }
}

