/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.util.ArrayList;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;

public class RunAfterTestClassCallbacks
extends Statement {
    private final Statement next;
    private final TestContextManager testContextManager;

    public RunAfterTestClassCallbacks(Statement next, TestContextManager testContextManager) {
        this.next = next;
        this.testContextManager = testContextManager;
    }

    public void evaluate() throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.next.evaluate();
        }
        catch (Throwable ex) {
            errors.add(ex);
        }
        try {
            this.testContextManager.afterTestClass();
        }
        catch (Throwable ex) {
            errors.add(ex);
        }
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            throw (Throwable)errors.get(0);
        }
        throw new MultipleFailureException(errors);
    }
}

