/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.ImageEncoderPNG;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSImageHandlerRawPNG
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_PNG};

    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRawPNG png = (ImageRawPNG)image;
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        Rectangle2D.Float targetRect = new Rectangle2D.Float(x, y, w, h);
        ImageEncoderPNG encoder = new ImageEncoderPNG(png);
        ImageInfo info = image.getInfo();
        Dimension imgDim = info.getSize().getDimensionPx();
        String imgDescription = image.getClass().getName();
        ColorModel cm = png.getColorModel();
        PSImageUtils.writeImage(encoder, imgDim, imgDescription, targetRect, cm, gen);
    }

    @Override
    public void generateForm(RenderingContext context, Image image, PSImageFormResource form) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRawPNG png = (ImageRawPNG)image;
        ImageInfo info = image.getInfo();
        String imageDescription = info.getMimeType() + " " + info.getOriginalURI();
        ImageEncoderPNG encoder = new ImageEncoderPNG(png);
        ImageFormGenerator formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), info.getSize().getDimensionPx(), encoder, png.getColorSpace(), false);
        formGen.generate(gen);
    }

    public int getPriority() {
        return 200;
    }

    public Class<ImageRawPNG> getSupportedImageClass() {
        return ImageRawPNG.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext targetContext, Image image) {
        PSRenderingContext psContext;
        if (targetContext instanceof PSRenderingContext && (psContext = (PSRenderingContext)targetContext).getGenerator().getPSLevel() >= 2) {
            return image == null || image instanceof ImageRawPNG;
        }
        return false;
    }
}

