/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryText;

public class HistoryTextArea
extends JTextArea {
    private HistoryText controller;

    public HistoryTextArea(String string) {
        super(3, 15);
        this.controller = new HistoryText(this, string);
        this.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke(9, 0)));
        this.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke(9, 1)));
    }

    public HistoryModel getModel() {
        return this.controller.getModel();
    }

    public void setModel(String string) {
        this.controller.setModel(string);
    }

    public void setInstantPopups(boolean bl) {
        this.controller.setInstantPopups(bl);
    }

    public boolean getInstantPopups() {
        return this.controller.getInstantPopups();
    }

    public void addCurrentToHistory() {
        this.controller.addCurrentToHistory();
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.controller.setIndex(-1);
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    if (!keyEvent.isControlDown()) break;
                    this.replaceSelection("\n");
                    keyEvent.consume();
                    break;
                }
                case 9: {
                    if (!keyEvent.isControlDown()) break;
                    this.replaceSelection("\t");
                    keyEvent.consume();
                    break;
                }
                case 33: {
                    if (keyEvent.isShiftDown()) {
                        this.controller.doBackwardSearch();
                    } else {
                        this.controller.historyPrevious();
                    }
                    keyEvent.consume();
                    break;
                }
                case 34: {
                    if (keyEvent.isShiftDown()) {
                        this.controller.doForwardSearch();
                    } else {
                        this.controller.historyNext();
                    }
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    if (!keyEvent.isAltDown()) break;
                    this.controller.showPopupMenu(keyEvent.isShiftDown());
                    keyEvent.consume();
                    break;
                }
                case 525: {
                    this.controller.showPopupMenu(keyEvent.isShiftDown());
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (GUIUtilities.isPopupTrigger(mouseEvent)) {
                    this.controller.showPopupMenu(mouseEvent.isShiftDown());
                    break;
                }
                super.processMouseEvent(mouseEvent);
                break;
            }
            default: {
                super.processMouseEvent(mouseEvent);
            }
        }
    }
}

