/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMeasure;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

public class SmilesParser {
    private boolean isSmarts;
    private boolean isBioSequence;
    private char bioType = '\u0000';
    private Map<Integer, SmilesBond> ringBonds = new Hashtable<Integer, SmilesBond>();
    private int braceCount;
    private int branchLevel;
    private int flags;
    Map<String, SmilesMeasure> htMeasures = new Hashtable<String, SmilesMeasure>();
    private Map<String, SmilesAtom> atomRefs;

    public static SmilesSearch getMolecule(String string, boolean bl) throws InvalidSmilesException {
        return new SmilesParser(bl).parse(string);
    }

    SmilesParser(boolean bl) {
        this.isSmarts = bl;
    }

    void reset() {
        this.braceCount = 0;
        this.branchLevel = 0;
    }

    SmilesSearch parse(String string) throws InvalidSmilesException {
        String[] stringArray;
        if (string == null) {
            throw new InvalidSmilesException("expression must not be null");
        }
        SmilesSearch smilesSearch = new SmilesSearch();
        if (string.indexOf("$(select") >= 0) {
            string = this.parseNested(smilesSearch, string, "select");
        }
        string = SmilesParser.cleanPattern(string);
        this.flags = 0;
        while (string.startsWith("/")) {
            stringArray = SmilesParser.getSubPattern(string, 0, '/').toUpperCase();
            string = string.substring(stringArray.length() + 2);
            if (stringArray.indexOf("NONCANONICAL") >= 0) {
                this.flags |= 0x40;
            }
            if (stringArray.indexOf("NOAROMATIC") >= 0) {
                this.flags |= 1;
            }
            if (stringArray.indexOf("AROMATICSTRICT") >= 0) {
                this.flags |= 8;
            }
            if (stringArray.indexOf("AROMATICDEFINED") >= 0) {
                this.flags |= 0x10;
            }
            if (stringArray.indexOf("AROMATICDOUBLE") >= 0) {
                this.flags |= 0x20;
            }
            if (stringArray.indexOf("NOSTEREO") >= 0) {
                this.flags |= 2;
                continue;
            }
            if (stringArray.indexOf("INVERTSTEREO") < 0) continue;
            this.flags |= 4;
        }
        if (string.indexOf("$") >= 0) {
            string = this.parseVariables(string);
        }
        if (this.isSmarts && string.indexOf("[$") >= 0) {
            string = this.parseVariableLength(string);
        }
        if (string.indexOf("||") >= 0) {
            stringArray = PT.split(string, "||");
            String string2 = "";
            smilesSearch.subSearches = new SmilesSearch[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = "|" + stringArray[i] + "|";
                if (string2.indexOf(string3) >= 0) continue;
                smilesSearch.subSearches[i] = this.getSearch(smilesSearch, stringArray[i], this.flags);
                string2 = string2 + string3;
            }
            Logger.info(string2);
            return smilesSearch;
        }
        return this.getSearch(smilesSearch, string, this.flags);
    }

    private String parseVariableLength(String string) throws InvalidSmilesException {
        int n;
        SB sB = new SB();
        int n2 = string.length() - 1;
        int n3 = 0;
        boolean bl = false;
        block11: for (n = 0; n < n2; ++n) {
            switch (string.charAt(n)) {
                case '(': {
                    ++n3;
                    continue block11;
                }
                case ')': {
                    --n3;
                    continue block11;
                }
                case '|': {
                    if (n3 <= 0) continue block11;
                    bl = true;
                    if (string.charAt(n + 1) != '|') continue block11;
                    string = string.substring(0, n) + string.substring(n + 1);
                    --n2;
                }
            }
        }
        if (string.indexOf("||") >= 0) {
            String[] stringArray = PT.split(string, "||");
            for (int i = 0; i < stringArray.length; ++i) {
                sB.append("||").append(this.parseVariableLength(stringArray[i]));
            }
        } else {
            n = -1;
            int[] nArray = new int[1];
            boolean bl2 = true;
            String string2 = null;
            while ((n = string.indexOf("[$", n + 1)) >= 0) {
                int n4;
                int n5;
                int n6 = n;
                int n7 = Integer.MIN_VALUE;
                int n8 = Integer.MIN_VALUE;
                n = SmilesParser.getDigits(string, n + 2, nArray);
                n7 = nArray[0];
                if (n7 != Integer.MIN_VALUE && SmilesParser.getChar(string, n) == '-') {
                    n = SmilesParser.getDigits(string, n + 1, nArray);
                    n8 = nArray[0];
                }
                if (SmilesParser.getChar(string, n) != '(' || !(string2 = SmilesParser.getSubPattern(string, n6, '[')).endsWith(")")) continue;
                int n9 = n6 + string2.length() + 2;
                String string3 = SmilesParser.getSubPattern(string, n, '(');
                int n10 = n;
                string2 = SmilesParser.getSubPattern(string, n, '[');
                n += 1 + string3.length();
                if (string3.indexOf(58) >= 0 && string3.indexOf(124) < 0) {
                    n5 = 0;
                    int n11 = string3.length();
                    n4 = -1;
                    block14: for (int i = 0; i < n11; ++i) {
                        switch (string3.charAt(i)) {
                            case '(': 
                            case '[': {
                                ++n5;
                                continue block14;
                            }
                            case ')': 
                            case ']': {
                                --n5;
                                continue block14;
                            }
                            case '.': {
                                if (n4 < 0 || n5 != 0) continue block14;
                                n11 = i;
                                continue block14;
                            }
                            case ':': {
                                if (n4 >= 0 || n5 != 0) continue block14;
                                n4 = i;
                            }
                        }
                    }
                    if (n4 > 0) {
                        string3 = string3.substring(0, n4) + "(" + string3.substring(n4, n11) + ")" + string3.substring(n11);
                    }
                }
                if (n7 == Integer.MIN_VALUE) {
                    n5 = string3.indexOf("|");
                    if (n5 < 0) continue;
                    return this.parseVariableLength(string.substring(0, n6) + "[$1" + string.substring(n10, n10 + n5 + 1) + ")]" + string.substring(n9) + "||" + string.substring(0, n6) + "[$1(" + string.substring(n10 + n5 + 2) + string.substring(n9));
                }
                if (n8 == Integer.MIN_VALUE) {
                    n8 = n7;
                }
                if (string3.indexOf("|") >= 0) {
                    string3 = "[$(" + string3 + ")]";
                }
                for (n5 = n7; n5 <= n8; ++n5) {
                    SB sB2 = new SB();
                    sB2.append("||").append(string.substring(0, n6));
                    for (n4 = 0; n4 < n5; ++n4) {
                        sB2.append(string3);
                    }
                    sB2.append(string.substring(n9));
                    sB.appendSB(sB2);
                }
            }
            if (!bl2) {
                throw new InvalidSmilesException("bad variable expression: " + string2);
            }
        }
        return bl ? this.parseVariableLength(sB.substring(2)) : (sB.length() < 2 ? string : sB.substring(2));
    }

    SmilesSearch getSearch(SmilesSearch smilesSearch, String string, int n) throws InvalidSmilesException {
        SmilesAtom smilesAtom;
        this.htMeasures = new Hashtable<String, SmilesMeasure>();
        SmilesSearch smilesSearch2 = new SmilesSearch();
        smilesSearch2.setTop(smilesSearch);
        smilesSearch2.isSmarts = this.isSmarts;
        smilesSearch2.pattern = string;
        smilesSearch2.flags = n;
        if (string.indexOf("$(") >= 0) {
            string = this.parseNested(smilesSearch2, string, "");
        }
        this.parseSmiles(smilesSearch2, string, null, false);
        if (this.braceCount != 0) {
            throw new InvalidSmilesException("unmatched '{'");
        }
        if (!this.ringBonds.isEmpty()) {
            throw new InvalidSmilesException("Open ring");
        }
        smilesSearch2.setAtomArray();
        smilesSearch2.isTopology = true;
        int n2 = smilesSearch2.ac;
        while (--n2 >= 0) {
            smilesAtom = smilesSearch2.patternAtoms[n2];
            if (smilesSearch2.isTopology && smilesAtom.isDefined()) {
                smilesSearch2.isTopology = false;
            }
            smilesAtom.setBondArray();
            if (this.isSmarts || smilesAtom.bioType != '\u0000' || smilesAtom.setHydrogenCount(smilesSearch2)) continue;
            throw new InvalidSmilesException("unbracketed atoms must be one of: B, C, N, O, P, S, F, Cl, Br, I, *,");
        }
        if (this.isSmarts) {
            n2 = smilesSearch2.ac;
            while (--n2 >= 0) {
                int n3;
                smilesAtom = smilesSearch2.patternAtoms[n2];
                this.checkNested(smilesSearch2, smilesAtom, n);
                for (n3 = 0; n3 < smilesAtom.nAtomsOr; ++n3) {
                    this.checkNested(smilesSearch2, smilesAtom.atomsOr[n3], n);
                }
                for (n3 = 0; n3 < smilesAtom.nPrimitives; ++n3) {
                    this.checkNested(smilesSearch2, smilesAtom.primitives[n3], n);
                }
            }
        }
        if (!this.isSmarts && !this.isBioSequence) {
            smilesSearch2.elementCounts[1] = smilesSearch2.getMissingHydrogenCount();
        }
        this.fixChirality(smilesSearch2);
        return smilesSearch2;
    }

    private void checkNested(SmilesSearch smilesSearch, SmilesAtom smilesAtom, int n) throws InvalidSmilesException {
        Object object;
        if (smilesAtom.iNested > 0 && (object = smilesSearch.getNested(smilesAtom.iNested)) instanceof String) {
            String string = (String)object;
            if (string.startsWith("select")) {
                return;
            }
            if (string.charAt(0) != '~' && smilesAtom.bioType != '\u0000') {
                string = "~" + smilesAtom.bioType + "~" + string;
            }
            SmilesSearch smilesSearch2 = this.getSearch(smilesSearch, string, n);
            if (smilesSearch2.ac > 0 && smilesSearch2.patternAtoms[0].selected) {
                smilesAtom.selected = true;
            }
            smilesSearch.setNested(smilesAtom.iNested, smilesSearch2);
        }
    }

    private void fixChirality(SmilesSearch smilesSearch) throws InvalidSmilesException {
        int n = smilesSearch.ac;
        while (--n >= 0) {
            SmilesAtom smilesAtom = smilesSearch.patternAtoms[n];
            if (smilesAtom.stereo == null) continue;
            smilesAtom.stereo.fixStereo(smilesAtom);
        }
    }

    private void parseSmiles(SmilesSearch smilesSearch, String string, SmilesAtom smilesAtom, boolean bl) throws InvalidSmilesException {
        int[] nArray = new int[1];
        int n = 0;
        SmilesBond smilesBond = null;
        while (string != null && string.length() != 0) {
            int n2;
            char c;
            boolean bl2;
            int n3 = 0;
            if (smilesAtom == null || smilesBond != null && smilesBond.order == 0) {
                n3 = this.checkBioType(string, 0);
                if (n3 == string.length()) {
                    string = string + "*";
                }
                if (this.isBioSequence) {
                    smilesSearch.top.needAromatic = false;
                    smilesSearch.needAromatic = false;
                }
            }
            if (bl2 = this.checkBrace(smilesSearch, c = SmilesParser.getChar(string, n3), '{')) {
                c = SmilesParser.getChar(string, ++n3);
            }
            if (c == '(') {
                String string2 = SmilesParser.getSubPattern(string, n3, '(');
                if (string2.length() > 0 && PT.isDigit(string2.charAt(0))) {
                    if (SmilesParser.getDigits(string2, 0, nArray) == string2.length() && nArray[0] > 0) {
                        SmilesAtom smilesAtom2;
                        n2 = nArray[0] - 1;
                        if (n2 < 0 || n2 >= smilesSearch.patternAtoms.length || (smilesAtom2 = smilesSearch.patternAtoms[n2]) == null || smilesAtom2 == smilesAtom || smilesAtom2.getBondTo(smilesAtom) != null) {
                            throw new InvalidSmilesException("Improper direct atom reference (" + string2 + ").");
                        }
                        if (smilesBond != null && smilesBond.order != -1 && smilesBond.order != 0) {
                            smilesBond.set2a(null, smilesAtom2);
                        } else {
                            new SmilesBond(smilesAtom2, smilesAtom, -1, false);
                        }
                    }
                } else {
                    boolean bl3;
                    boolean bl4 = bl3 = SmilesParser.getChar(string, n3 + 1) == '.';
                    if (smilesAtom == null) {
                        throw new InvalidSmilesException("No previous atom for " + (bl3 ? "measure" : "branch"));
                    }
                    if (string2.startsWith(".")) {
                        this.parseMeasure(smilesSearch, string2.substring(1), smilesAtom);
                    } else if (string2.length() == 0 && this.isBioSequence) {
                        smilesAtom.notCrossLinked = true;
                    } else {
                        ++this.branchLevel;
                        this.parseSmiles(smilesSearch, string2, smilesAtom, true);
                        --this.branchLevel;
                    }
                }
                if ((c = SmilesParser.getChar(string, n3 = string2.length() + 2)) == '}' && this.checkBrace(smilesSearch, c, '}')) {
                    ++n3;
                }
            } else {
                boolean bl5;
                n = n3;
                while (SmilesBond.isBondType(c, this.isSmarts, this.isBioSequence)) {
                    c = SmilesParser.getChar(string, ++n3);
                }
                smilesBond = this.parseBond(smilesSearch, null, string.substring(n, n3), null, smilesAtom, false, bl);
                if (bl2 && smilesBond.order != -1) {
                    n3 = n;
                }
                if (this.checkBrace(smilesSearch, c = SmilesParser.getChar(string, n3), '{')) {
                    c = SmilesParser.getChar(string, ++n3);
                }
                if (c == '~' && smilesBond.order == 0 && (n3 = this.checkBioType(string, n3)) == string.length()) {
                    string = string + "*";
                }
                if (c == '\u0000' && smilesBond.order == 0) {
                    return;
                }
                boolean bl6 = PT.isDigit(c) || c == '%';
                boolean bl7 = bl5 = !bl6 && (c == '_' || c == '[' || c == '*' || PT.isLetter(c));
                if (bl6) {
                    n3 = SmilesParser.getRingNumber(string, n3, c, nArray);
                    n2 = nArray[0];
                    this.parseRing(smilesSearch, n2, smilesAtom, smilesBond);
                    smilesBond = null;
                } else if (bl5) {
                    switch (c) {
                        case '[': 
                        case '_': {
                            String string3 = SmilesParser.getSubPattern(string, n3, c);
                            n3 += string3.length() + (c == '[' ? 2 : 0);
                            if (this.isBioSequence && c == '[' && string3.indexOf(".") < 0 && string3.indexOf("_") < 0) {
                                string3 = string3 + ".0";
                            }
                            smilesAtom = this.parseAtom(smilesSearch, null, string3, smilesAtom, smilesBond, c == '[', false, bl);
                            smilesAtom.hasSubpattern = true;
                            if (smilesBond.order != -1 && smilesBond.order != 0) {
                                smilesBond.set2a(null, smilesAtom);
                            }
                            smilesBond = null;
                            break;
                        }
                        default: {
                            char c2;
                            char c3 = c2 = !this.isBioSequence && PT.isUpperCase(c) ? SmilesParser.getChar(string, n3 + 1) : (char)'\u0000';
                            if (!(c == 'X' && c2 == 'x' || PT.isLowerCase(c2) && Elements.elementNumberFromSymbol(string.substring(n3, n3 + 2), true) != 0)) {
                                c2 = '\u0000';
                            }
                            if (c2 != '\u0000' && "NA CA BA PA SC AC".indexOf(string.substring(n3, n3 + 2)) >= 0) {
                                c2 = '\u0000';
                            }
                            int n4 = PT.isUpperCase(c) && PT.isLowerCase(c2) ? 2 : 1;
                            smilesAtom = this.parseAtom(smilesSearch, null, string.substring(n3, n3 + n4), smilesAtom, smilesBond, false, false, bl);
                            smilesBond = null;
                            n3 += n4;
                            break;
                        }
                    }
                } else if (c != '(') {
                    throw new InvalidSmilesException("Unexpected character: " + SmilesParser.getChar(string, n3));
                }
                c = SmilesParser.getChar(string, n3);
                if (c == '}' && this.checkBrace(smilesSearch, c, '}')) {
                    ++n3;
                }
            }
            string = string.substring(n3);
            bl = false;
        }
    }

    static int getRingNumber(String string, int n, char c, int[] nArray) throws InvalidSmilesException {
        int n2;
        switch (c) {
            case '%': {
                if (SmilesParser.getChar(string, n + 1) == '(') {
                    String string2 = SmilesParser.getSubPattern(string, n + 1, '(');
                    SmilesParser.getDigits(string2, 0, nArray);
                    n += string2.length() + 3;
                    if (nArray[0] < 0) {
                        throw new InvalidSmilesException("Invalid number designation: " + string2);
                    }
                } else {
                    if (n + 3 <= string.length()) {
                        n = SmilesParser.getDigits(string.substring(0, n + 3), n + 1, nArray);
                    }
                    if (nArray[0] < 10) {
                        throw new InvalidSmilesException("Two digits must follow the % sign");
                    }
                }
                n2 = nArray[0];
                break;
            }
            default: {
                n2 = c - 48;
                ++n;
            }
        }
        nArray[0] = n2;
        return n;
    }

    private int checkBioType(String string, int n) {
        boolean bl = this.isBioSequence = string.charAt(n) == '~';
        if (this.isBioSequence) {
            ++n;
            this.bioType = (char)42;
            char c = SmilesParser.getChar(string, 2);
            if (c == '~' && ((c = string.charAt(1)) == '*' || PT.isLowerCase(c))) {
                this.bioType = c;
                n = 3;
            }
        }
        return n;
    }

    private void parseMeasure(SmilesSearch smilesSearch, String string, SmilesAtom smilesAtom) throws InvalidSmilesException {
        block11: {
            SmilesMeasure smilesMeasure;
            String string2;
            int n = string.indexOf(":");
            String string3 = string2 = n < 0 ? string : string.substring(0, n);
            if (n == 0) break block11;
            int n2 = string2.length();
            if (n2 == 1) {
                string2 = string2 + "0";
            }
            if ((smilesMeasure = this.htMeasures.get(string2)) == null == n < 0 || n2 == 0) break block11;
            try {
                block14: {
                    block12: {
                        int n3;
                        block13: {
                            String[] stringArray;
                            boolean bl;
                            if (n <= 0) break block12;
                            int n4 = "__dat".indexOf(string2.charAt(0));
                            if (n4 < 2) break block11;
                            int[] nArray = new int[1];
                            SmilesParser.getDigits(string2, 1, nArray);
                            n3 = nArray[0];
                            string = string.substring(n + 1);
                            boolean bl2 = string.startsWith("!");
                            if (bl2) {
                                string = string.substring(1);
                            }
                            if (bl = string.startsWith("-")) {
                                string = string.substring(1);
                            }
                            string = PT.rep(string, "-", ",");
                            string = PT.rep(string, ",,", ",-");
                            if (bl) {
                                string = "-" + string;
                            }
                            if ((stringArray = PT.split(string, ",")).length % 2 == 1) break block11;
                            float[] fArray = new float[stringArray.length];
                            int n5 = stringArray.length;
                            while (--n5 >= 0 && !Float.isNaN(fArray[n5] = PT.fVal(stringArray[n5]))) {
                            }
                            if (n5 >= 0) break block11;
                            smilesMeasure = new SmilesMeasure(smilesSearch, n3, n4, bl2, fArray);
                            smilesSearch.measures.addLast(smilesMeasure);
                            if (n3 <= 0) break block13;
                            this.htMeasures.put(string2, smilesMeasure);
                            break block14;
                        }
                        if (n3 != 0 || !Logger.debugging) break block14;
                        Logger.debug("measure created: " + smilesMeasure);
                        break block14;
                    }
                    if (smilesMeasure.addPoint(smilesAtom.index)) {
                        if (smilesMeasure.nPoints == smilesMeasure.type) {
                            this.htMeasures.remove(string2);
                            if (Logger.debugging) {
                                Logger.debug("measure created: " + smilesMeasure);
                            }
                        }
                        return;
                    }
                    break block11;
                }
                if (!smilesMeasure.addPoint(smilesAtom.index)) {
                }
            }
            catch (NumberFormatException numberFormatException) {}
            break block11;
            return;
        }
        throw new InvalidSmilesException("invalid measure: " + string);
    }

    private boolean checkBrace(SmilesSearch smilesSearch, char c, char c2) throws InvalidSmilesException {
        switch (c) {
            case '{': {
                if (c != c2) break;
                ++this.braceCount;
                smilesSearch.top.haveSelected = true;
                return true;
            }
            case '}': {
                if (c != c2 || this.braceCount <= 0) break;
                --this.braceCount;
                return true;
            }
            default: {
                return false;
            }
        }
        throw new InvalidSmilesException("Unmatched '}'");
    }

    private String parseNested(SmilesSearch smilesSearch, String string, String string2) throws InvalidSmilesException {
        int n;
        string2 = "$(" + string2;
        while ((n = string.lastIndexOf(string2)) >= 0) {
            String string3 = SmilesParser.getSubPattern(string, n + 1, '(');
            int n2 = n + string3.length() + 3;
            string = string.substring(0, n) + "_" + smilesSearch.addNested(string3) + "_" + string.substring(n2);
        }
        return string;
    }

    private String parseVariables(String string) throws InvalidSmilesException {
        String string2;
        int n;
        Lst<String> lst = new Lst<String>();
        Lst<String> lst2 = new Lst<String>();
        int n2 = 0;
        int n3 = -1;
        if (Logger.debugging) {
            Logger.info(string);
        }
        while ((n = string.indexOf("$", n2)) >= 0 && SmilesParser.getChar(string, n2 + 1) != '(' && (n2 = SmilesParser.skipTo(string, n, '=')) > n + 1 && SmilesParser.getChar(string, n2 + 1) == '\"') {
            String string3 = string.substring(n, n2);
            if (string3.lastIndexOf(36) > 0 || string3.indexOf(93) > 0) {
                throw new InvalidSmilesException("Invalid variable name: " + string3);
            }
            string2 = SmilesParser.getSubPattern(string, n2 + 1, '\"');
            lst.addLast("[" + string3 + "]");
            lst2.addLast(string2);
            n2 += string2.length() + 2;
            n2 = SmilesParser.skipTo(string, n2, ';');
            n3 = ++n2;
        }
        if (n3 < 0) {
            return string;
        }
        string = string.substring(n3);
        int n4 = lst.size();
        while (--n4 >= 0) {
            string2 = (String)lst.get(n4);
            String string4 = (String)lst2.get(n4);
            if (string4.equals(string2)) continue;
            string = PT.rep(string, string2, string4);
        }
        if (Logger.debugging) {
            Logger.info(string);
        }
        return string;
    }

    private SmilesAtom parseAtom(SmilesSearch smilesSearch, SmilesAtom smilesAtom, String string, SmilesAtom smilesAtom2, SmilesBond smilesBond, boolean bl, boolean bl2, boolean bl3) throws InvalidSmilesException {
        if (string == null || string.length() == 0) {
            throw new InvalidSmilesException("Empty atom definition");
        }
        SmilesAtom smilesAtom3 = new SmilesAtom();
        if (smilesAtom == null) {
            smilesSearch.appendAtom(smilesAtom3);
        }
        boolean bl4 = true;
        if (!this.checkLogic(smilesSearch, string, smilesAtom3, null, smilesAtom2, bl2, bl3)) {
            int[] nArray = new int[1];
            if (this.isBioSequence && string.length() == 1) {
                string = string + ".0";
            }
            char c = string.charAt(0);
            int n = 0;
            boolean bl5 = false;
            if (this.isSmarts && c == '!') {
                if ((c = SmilesParser.getChar(string, ++n)) == '\u0000') {
                    throw new InvalidSmilesException("invalid '!'");
                }
                bl5 = true;
                smilesAtom3.not = true;
            }
            int n2 = string.indexOf(46);
            int n3 = string.indexOf(64);
            if (n2 >= 0 && (n3 < 0 || n2 < n3)) {
                smilesAtom3.isBioResidue = true;
                String string2 = string.substring(n, n2);
                string = string.substring(n2 + 1).toUpperCase();
                n2 = string2.indexOf("#");
                if (n2 >= 0) {
                    SmilesParser.getDigits(string2, n2 + 1, nArray);
                    string2 = string2.substring(0, n2);
                    smilesAtom3.residueNumber = nArray[0];
                }
                if (string2.length() == 0) {
                    string2 = "*";
                }
                if (string2.length() > 1) {
                    smilesAtom3.residueName = string2.toUpperCase();
                } else if (!string2.equals("*")) {
                    smilesAtom3.residueChar = string2;
                }
                string2 = string;
                n2 = string2.indexOf("#");
                if (n2 >= 0) {
                    SmilesParser.getDigits(string2, n2 + 1, nArray);
                    smilesAtom3.elementNumber = nArray[0];
                    string2 = string2.substring(0, n2);
                }
                if (string2.length() == 0) {
                    string2 = "*";
                } else if (string2.equals("0")) {
                    string2 = "\u0000";
                }
                if (!string2.equals("*")) {
                    smilesAtom3.setAtomName(string2);
                }
                c = '\u0000';
            }
            smilesAtom3.setBioAtom(this.bioType);
            int n4 = Integer.MIN_VALUE;
            while (c != '\u0000' && bl4) {
                smilesAtom3.setAtomName(this.isBioSequence ? "\u0000" : "");
                if (PT.isDigit(c)) {
                    n = SmilesParser.getDigits(string, n, nArray);
                    int n5 = nArray[0];
                    if (n5 == Integer.MIN_VALUE) {
                        throw new InvalidSmilesException("Non numeric atomic mass");
                    }
                    if (SmilesParser.getChar(string, n) == '?') {
                        ++n;
                        n5 = -n5;
                    }
                    smilesAtom3.setAtomicMass(n5);
                } else {
                    block0 : switch (c) {
                        case '\"': {
                            String string3 = PT.getQuotedStringAt(string, n);
                            n += string3.length() + 2;
                            smilesAtom3.setAtomType(string3);
                            break;
                        }
                        case '_': {
                            n = SmilesParser.getDigits(string, n + 1, nArray) + 1;
                            if (nArray[0] == Integer.MIN_VALUE) {
                                throw new InvalidSmilesException("Invalid SEARCH primitive: " + string.substring(n));
                            }
                            smilesAtom3.iNested = nArray[0];
                            if (!this.isBioSequence || !bl || n == string.length()) break;
                            throw new InvalidSmilesException("invalid characters: " + string.substring(n));
                        }
                        case '=': {
                            n = SmilesParser.getDigits(string, n + 1, nArray);
                            smilesAtom3.jmolIndex = nArray[0];
                            break;
                        }
                        case '#': {
                            boolean bl6 = string.charAt(n + 1) == '-';
                            n = SmilesParser.getDigits(string, n + (bl6 ? 2 : 1), nArray);
                            if (bl6) {
                                smilesAtom3.atomNumber = nArray[0];
                                break;
                            }
                            smilesAtom3.elementNumber = nArray[0];
                            break;
                        }
                        case '(': {
                            String string4 = SmilesParser.getSubPattern(string, n, '(');
                            n += 2 + string4.length();
                            smilesAtom3 = this.checkReference(smilesAtom3, string4, nArray);
                            boolean bl7 = bl4 = nArray[0] == 1;
                            if (bl4) break;
                            if (bl5) {
                                n = 0;
                            }
                            bl5 = true;
                            break;
                        }
                        case '+': 
                        case '-': {
                            n = this.checkCharge(string, n, smilesAtom3);
                            break;
                        }
                        case '@': {
                            if (smilesSearch.stereo == null) {
                                smilesSearch.stereo = SmilesStereo.newStereo(null);
                            }
                            n = SmilesStereo.checkChirality(string, n, smilesSearch.patternAtoms[smilesAtom3.index]);
                            break;
                        }
                        default: {
                            boolean bl8;
                            char c2 = SmilesParser.getChar(string, n + 1);
                            String string5 = string.substring(n + 1, n + (PT.isLowerCase(c2) && (!bl || !PT.isDigit(SmilesParser.getChar(string, n + 2))) ? 2 : 1));
                            String string6 = Character.toUpperCase(c) + string5;
                            boolean bl9 = true;
                            boolean bl10 = bl8 = bl && PT.isLetter(c);
                            if (bl8) {
                                if (!bl5 && (bl2 ? smilesAtom : smilesAtom3).hasSymbol) {
                                    bl9 = false;
                                } else if (c == 'H') {
                                    bl9 = !PT.isDigit(c2) || SmilesParser.getChar(string, n + 2) == '?';
                                } else if ("DdhRrvXx".indexOf(c) >= 0 && PT.isDigit(c2)) {
                                    bl9 = false;
                                } else if (!string6.equals("A") && !string6.equals("Xx")) {
                                    boolean bl11 = bl9 = Elements.elementNumberFromSymbol(string6, true) > 0;
                                    if (!bl9 && string5 != "") {
                                        string5 = "";
                                        boolean bl12 = bl9 = Elements.elementNumberFromSymbol(string6 = string6.substring(0, 1), true) > 0;
                                    }
                                }
                            }
                            if (bl9) {
                                if (!((bl || this.isSmarts || this.isBioSequence || SmilesAtom.allowSmilesUnbracketed(string6)) && smilesAtom3.setSymbol(string6 = c + string5))) {
                                    throw new InvalidSmilesException("Invalid atom symbol: " + string6);
                                }
                                if (bl2) {
                                    smilesAtom.hasSymbol = true;
                                }
                                n += string6.length();
                                break;
                            }
                            n = SmilesParser.getDigits(string, n + 1, nArray);
                            int n6 = nArray[0];
                            switch (c) {
                                default: {
                                    throw new InvalidSmilesException("Invalid SEARCH primitive: " + string.substring(n));
                                }
                                case 'D': {
                                    smilesAtom3.setDegree(n6 == Integer.MIN_VALUE ? 1 : n6);
                                    break block0;
                                }
                                case 'd': {
                                    smilesAtom3.setNonhydrogenDegree(n6 == Integer.MIN_VALUE ? 1 : n6);
                                    break block0;
                                }
                                case 'H': {
                                    n4 = n6 == Integer.MIN_VALUE ? 1 : n6;
                                    break block0;
                                }
                                case 'h': {
                                    smilesAtom3.setImplicitHydrogenCount(n6 == Integer.MIN_VALUE ? -1 : n6);
                                    break block0;
                                }
                                case 'R': {
                                    if (n6 == Integer.MIN_VALUE) {
                                        n6 = -1;
                                    }
                                    smilesAtom3.setRingMembership(n6);
                                    smilesSearch.top.needRingData = true;
                                    break block0;
                                }
                                case 'r': {
                                    if (n6 == Integer.MIN_VALUE) {
                                        n6 = -1;
                                        smilesAtom3.setRingMembership(n6);
                                    } else {
                                        smilesAtom3.setRingSize(n6);
                                        switch (n6) {
                                            case 500: {
                                                n6 = 5;
                                                break;
                                            }
                                            case 600: {
                                                n6 = 6;
                                            }
                                        }
                                        if (n6 > smilesSearch.ringDataMax) {
                                            smilesSearch.ringDataMax = n6;
                                        }
                                    }
                                    smilesSearch.top.needRingData = true;
                                    break block0;
                                }
                                case 'v': {
                                    smilesAtom3.setValence(n6 == Integer.MIN_VALUE ? 1 : n6);
                                    break block0;
                                }
                                case 'X': {
                                    smilesAtom3.setConnectivity(n6 == Integer.MIN_VALUE ? 1 : n6);
                                    break block0;
                                }
                                case 'x': 
                            }
                            smilesAtom3.setRingConnectivity(n6 == Integer.MIN_VALUE ? -1 : n6);
                            smilesSearch.top.needRingData = true;
                        }
                    }
                }
                c = SmilesParser.getChar(string, n);
                if (!bl5 || c == '\u0000') continue;
                throw new InvalidSmilesException("'!' may only involve one primitive.");
            }
            if (n4 == Integer.MIN_VALUE && bl) {
                n4 = -2147483647;
            }
            smilesAtom3.setExplicitHydrogenCount(n4);
            smilesSearch.patternAtoms[smilesAtom3.index].setExplicitHydrogenCount(n4);
        }
        if (this.braceCount > 0) {
            smilesAtom3.selected = true;
        }
        if (bl4 && smilesAtom != null) {
            if (bl2) {
                smilesAtom.appendPrimitive(smilesAtom3);
            } else {
                smilesAtom.appendAtomOr(smilesAtom3);
            }
        }
        if (smilesAtom2 != null && smilesBond.order == 0) {
            smilesAtom3.notBondedIndex = smilesAtom2.index;
        }
        if (smilesAtom2 != null && smilesBond.order != 0) {
            if (smilesBond.order == -1) {
                int n = this.isBioSequence && bl3 ? 112 : (smilesBond.order = this.isSmarts || smilesAtom2.isAromatic() && smilesAtom3.isAromatic() ? 81 : 1);
            }
            if (!bl) {
                smilesBond.set2a(null, smilesAtom3);
            }
            if (this.branchLevel == 0 && (smilesBond.order == 17 || smilesBond.order == 112)) {
                ++this.branchLevel;
            }
        }
        if (this.branchLevel == 0) {
            smilesSearch.lastChainAtom = smilesAtom3;
        }
        return smilesAtom3;
    }

    private SmilesAtom checkReference(SmilesAtom smilesAtom, String string, int[] nArray) {
        SmilesAtom smilesAtom2;
        if (this.atomRefs == null) {
            this.atomRefs = new Hashtable<String, SmilesAtom>();
        }
        if ((smilesAtom2 = this.atomRefs.get(string)) == null) {
            smilesAtom.referance = string;
            smilesAtom2 = smilesAtom;
            this.atomRefs.put(smilesAtom.referance, smilesAtom2);
            if (!smilesAtom.hasSymbol && string.length() > 0) {
                String string2 = null;
                if (string.length() >= 2 && (Elements.elementNumberFromSymbol(string2 = string.substring(0, 2), true) > 0 || Elements.elementNumberFromSymbol(string2 = string.substring(0, 1), true) > 0)) {
                    smilesAtom.setSymbol(string2);
                }
            }
            nArray[0] = 1;
        } else {
            nArray[0] = 0;
        }
        return smilesAtom2;
    }

    private void parseRing(SmilesSearch smilesSearch, int n, SmilesAtom smilesAtom, SmilesBond smilesBond) throws InvalidSmilesException {
        Integer n2 = n;
        SmilesBond smilesBond2 = this.ringBonds.get(n2);
        if (smilesBond2 == null) {
            this.ringBonds.put(n2, smilesBond);
            return;
        }
        this.ringBonds.remove(n2);
        switch (smilesBond.order) {
            case -1: {
                smilesBond.order = smilesBond2.order != -1 ? smilesBond2.order : (this.isSmarts || smilesAtom.isAromatic() && smilesBond2.atom1.isAromatic() ? 81 : 1);
                break;
            }
            case 257: {
                smilesBond.order = 513;
                break;
            }
            case 513: {
                smilesBond.order = 257;
            }
        }
        if (smilesBond2.order != -1 && smilesBond2.order != smilesBond.order || smilesAtom == smilesBond2.atom1 || smilesBond2.atom1.getBondTo(smilesAtom) != null) {
            throw new InvalidSmilesException("Bad connection type or atom");
        }
        smilesBond2.set(smilesBond);
        --smilesAtom.bondCount;
        smilesBond2.setAtom2(smilesAtom);
    }

    private int checkCharge(String string, int n, SmilesAtom smilesAtom) throws InvalidSmilesException {
        int n2 = string.length();
        char c = string.charAt(n);
        int n3 = 1;
        if (++n < n2) {
            char c2 = string.charAt(n);
            if (PT.isDigit(c2)) {
                int[] nArray = new int[1];
                n = SmilesParser.getDigits(string, n, nArray);
                n3 = nArray[0];
                if (n3 == Integer.MIN_VALUE) {
                    throw new InvalidSmilesException("Non numeric charge");
                }
            } else {
                while (n < n2 && string.charAt(n) == c) {
                    ++n;
                    ++n3;
                }
            }
        }
        smilesAtom.setCharge(c == '+' ? n3 : -n3);
        return n;
    }

    private SmilesBond parseBond(SmilesSearch smilesSearch, SmilesBond smilesBond, String string, SmilesBond smilesBond2, SmilesAtom smilesAtom, boolean bl, boolean bl2) throws InvalidSmilesException {
        SmilesBond smilesBond3;
        char c = SmilesParser.getChar(string, 0);
        if (c == '.') {
            if (smilesBond2 != null || smilesBond != null) {
                throw new InvalidSmilesException("invalid '.'");
            }
            this.isBioSequence = SmilesParser.getChar(string, 1) == '~';
            return new SmilesBond(null, null, 0, false);
        }
        if (c == '+' && smilesBond != null) {
            throw new InvalidSmilesException("invalid '+'");
        }
        SmilesBond smilesBond4 = smilesBond == null ? (smilesBond2 == null ? new SmilesBond(smilesAtom, null, this.isBioSequence && smilesAtom != null ? (bl2 ? 112 : 96) : -1, false) : smilesBond2) : (smilesBond3 = bl ? smilesBond.addPrimitive() : smilesBond.addBondOr());
        if (c != '\u0000' && !this.checkLogic(smilesSearch, string, null, smilesBond3, smilesAtom, bl, false)) {
            boolean bl3;
            boolean bl4 = bl3 = c == '!';
            if (bl3 && ((c = SmilesParser.getChar(string, 1)) == '\u0000' || c == '!')) {
                throw new InvalidSmilesException("invalid '!'");
            }
            int n = SmilesBond.getBondTypeFromCode(c);
            if (n == 65) {
                smilesSearch.top.needRingMemberships = true;
            }
            if (smilesAtom == null && n != 0) {
                throw new InvalidSmilesException("Bond without a previous atom");
            }
            switch (n) {
                case 769: 
                case 1025: {
                    if (bl3) {
                        bl3 = false;
                        n = n == 769 ? 1025 : 769;
                    }
                    smilesSearch.haveBondStereochemistry = true;
                    break;
                }
                case 257: 
                case 513: {
                    smilesSearch.haveBondStereochemistry = true;
                    break;
                }
                case 17: {
                    break;
                }
                case 1: 
                case 2: {
                    if (!smilesAtom.isAromatic()) break;
                    smilesSearch.top.needRingData = true;
                }
            }
            smilesBond3.set2(n, bl3);
            if (this.isBioSequence && smilesBond != null) {
                smilesBond.set2(n, bl3);
            }
        }
        return smilesBond3;
    }

    private boolean checkLogic(SmilesSearch smilesSearch, String string, SmilesAtom smilesAtom, SmilesBond smilesBond, SmilesAtom smilesAtom2, boolean bl, boolean bl2) throws InvalidSmilesException {
        char c;
        int n;
        block10: {
            block13: {
                block14: {
                    Object object;
                    int n2;
                    String string2;
                    int n3;
                    block12: {
                        block11: {
                            n = string.indexOf(44);
                            n3 = string.length();
                            char c2 = c = n > 0 ? (char)'\u0001' : '\u0000';
                            if (c != '\u0000' && !this.isSmarts || n == 0) break block10;
                            string2 = "";
                            n = string.indexOf(59);
                            if (n < 0) break block11;
                            if (!this.isSmarts || n == 0) break block10;
                            string2 = "&" + string.substring(n + 1);
                            string = string.substring(0, n);
                            if (c == '\u0000') {
                                string = string + string2;
                                string2 = "";
                            }
                        }
                        n2 = 0;
                        if (c == '\u0000') break block12;
                        string = string + ",";
                        while ((n = string.indexOf(44, n2)) > 0 && n <= n3) {
                            String string3 = string.substring(n2, n) + string2;
                            if (string3.length() == 0) {
                                throw new InvalidSmilesException("missing " + (smilesBond == null ? "atom" : "bond") + " token");
                            }
                            if (smilesBond == null) {
                                this.parseAtom(smilesSearch, smilesAtom, string3, null, null, true, false, bl2);
                            } else {
                                this.parseBond(smilesSearch, smilesBond, string3, null, smilesAtom2, false, false);
                            }
                            n2 = n + 1;
                        }
                        break block13;
                    }
                    n = string.indexOf(38);
                    if (n < 0 && (smilesBond == null || n3 <= 1 || bl)) break block14;
                    if (!this.isSmarts || n == 0) break block10;
                    if (smilesBond != null && n < 0 && n3 > 1) {
                        object = new SB();
                        int n4 = 0;
                        while (n4 < n3) {
                            char c3 = string.charAt(n4++);
                            ((SB)object).appendC(c3);
                            if (c3 == '!' || n4 >= n3) continue;
                            ((SB)object).appendC('&');
                        }
                        string = ((SB)object).toString();
                        n3 = string.length();
                    }
                    string = string + "&";
                    while ((n = string.indexOf(38, n2)) > 0 && n <= n3) {
                        object = string.substring(n2, n) + string2;
                        if (smilesBond == null) {
                            this.parseAtom(smilesSearch, smilesAtom, (String)object, null, null, true, true, bl2);
                        } else {
                            this.parseBond(smilesSearch, smilesBond, (String)object, null, smilesAtom2, true, false);
                        }
                        n2 = n + 1;
                    }
                    break block13;
                }
                return false;
            }
            return true;
        }
        c = string.charAt(n);
        throw new InvalidSmilesException((this.isSmarts ? "invalid placement for '" + c + "'" : "[" + c + "] notation only valid with SMARTS, not SMILES,") + " in " + string);
    }

    static String getSubPattern(String string, int n, char c) throws InvalidSmilesException {
        char c2;
        int n2 = 1;
        switch (c) {
            case '[': {
                c2 = ']';
                break;
            }
            case '\"': 
            case '%': 
            case '/': {
                c2 = c;
                break;
            }
            case '(': {
                c2 = ')';
                break;
            }
            default: {
                c2 = c;
                n2 = 0;
            }
        }
        int n3 = string.length();
        int n4 = 1;
        for (int i = n + 1; i < n3; ++i) {
            char c3 = string.charAt(i);
            if (c3 == c2) {
                if (--n4 != 0) continue;
                return string.substring(n + n2, i + 1 - n2);
            }
            if (c3 != c) continue;
            ++n4;
        }
        throw new InvalidSmilesException("Unmatched " + c);
    }

    static char getChar(String string, int n) {
        return n < string.length() ? string.charAt(n) : (char)'\u0000';
    }

    static int getDigits(String string, int n, int[] nArray) {
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && PT.isDigit(string.charAt(n2)); ++n2) {
        }
        try {
            nArray[0] = Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            nArray[0] = Integer.MIN_VALUE;
        }
        return n2;
    }

    private static int skipTo(String string, int n, char c) {
        char c2;
        int n2 = n;
        while ((c2 = SmilesParser.getChar(string, ++n2)) != c && c2 != '\u0000') {
        }
        return c2 == '\u0000' ? -1 : n2;
    }

    static String cleanPattern(String string) {
        string = PT.replaceAllCharacters(string, " \t\n\r", "");
        string = PT.rep(string, "^^", "'");
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf("//*")) >= 0 && (n2 = string.indexOf("*//")) >= n) {
            string = string.substring(0, n) + string.substring(n2 + 3);
        }
        string = PT.rep(string, "//", "");
        return string;
    }
}

