/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

public final class IdUtil {
    public static boolean isConstant(String id2) {
        return Character.isUpperCase(id2.charAt(0));
    }

    public static boolean isClassVariable(String id2) {
        return id2.length() > 1 && id2.charAt(0) == '@' && id2.charAt(1) == '@';
    }

    public static boolean isInstanceVariable(String id2) {
        return id2.length() > 0 && id2.charAt(0) == '@' && (id2.length() < 2 || id2.charAt(1) != '@');
    }

    public static boolean isGlobal(String id2) {
        return id2.length() > 0 && id2.charAt(0) == '$';
    }

    public static boolean isPredicate(String id2) {
        return id2.endsWith("?");
    }

    public static boolean isLocal(String id2) {
        return !IdUtil.isGlobal(id2) && !IdUtil.isClassVariable(id2) && !IdUtil.isInstanceVariable(id2) && !IdUtil.isConstant(id2) && !IdUtil.isPredicate(id2) && !IdUtil.isSpecial(id2);
    }

    public static boolean isSpecial(String id2) {
        return id2.startsWith("%");
    }

    public static boolean isAttrSet(String id2) {
        return id2.endsWith("=");
    }

    public static boolean isValidConstantName(String id2) {
        char c;
        int len = id2.length();
        if (len > 0 && (c = id2.charAt(0)) <= 'Z' && c >= 'A') {
            return IdUtil.isNameString(id2, 1, len);
        }
        return false;
    }

    public static boolean isValidConstantName19(String id2) {
        char c;
        int len = id2.length();
        if (len > 0 && (c = id2.charAt(0)) <= 'Z' && c >= 'A') {
            return IdUtil.isNameString19(id2, 1, len);
        }
        return false;
    }

    public static boolean isValidInstanceVariableName(String id2) {
        int len = id2.length();
        if (len > 1 && '@' == id2.charAt(0) && IdUtil.isInitialCharacter(id2.charAt(1))) {
            return IdUtil.isNameString(id2, 2, len);
        }
        return false;
    }

    public static boolean isValidClassVariableName(String id2) {
        int len = id2.length();
        if (len > 2 && '@' == id2.charAt(0) && '@' == id2.charAt(1) && IdUtil.isInitialCharacter(id2.charAt(2))) {
            return IdUtil.isNameString(id2, 3, len);
        }
        return false;
    }

    public static boolean isInitialCharacter(int c) {
        return (c &= 0xFFFFFFDF) <= 90 && c >= 65 || c == 95;
    }

    public static boolean isNameCharacter(char c) {
        int letter = c & 0xFFFFFFDF;
        return letter <= 90 && letter >= 65 || c == '_' || c <= '9' && c >= '0';
    }

    public static boolean isNameCharacter19(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean isNameString(String id2, int start2, int limit2) {
        for (int i2 = start2; i2 < limit2; ++i2) {
            if (IdUtil.isNameCharacter(id2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameString19(String id2, int start2, int limit2) {
        for (int i2 = start2; i2 < limit2; ++i2) {
            if (IdUtil.isNameCharacter19(id2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isRubyVariable(String name2) {
        char c;
        return name2.length() > 0 && ((c = name2.charAt(0)) == '@' || c <= 'Z' && c >= 'A');
    }
}

